/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.BCEntity;
import serp.bytecode.Code;
import serp.bytecode.CodeEntry;
import serp.bytecode.Constants;
import serp.bytecode.LineNumber;
import serp.bytecode.LineNumberTable;
import serp.bytecode.Project;
import serp.bytecode.lowlevel.ConstantPool;
import serp.bytecode.visitor.BCVisitor;
import serp.bytecode.visitor.VisitAcceptor;

public class Instruction
extends CodeEntry
implements BCEntity,
VisitAcceptor {
    private Code _owner = null;
    private int _opcode = 0;

    Instruction(Code code) {
        this._owner = code;
    }

    Instruction(Code code, int n) {
        this._owner = code;
        this._opcode = n;
    }

    public Code getCode() {
        return this._owner;
    }

    public String getName() {
        return Constants.OPCODE_NAMES[this._opcode];
    }

    public int getOpcode() {
        return this._opcode;
    }

    Instruction setOpcode(int n) {
        this._opcode = n;
        return this;
    }

    public int getByteIndex() {
        if (this._owner != null) {
            return this._owner.getByteIndex(this);
        }
        return 0;
    }

    void invalidateByteIndexes() {
        if (this._owner != null) {
            this._owner.invalidateByteIndexes();
        }
    }

    public LineNumber getLineNumber() {
        LineNumberTable lineNumberTable = this._owner.getLineNumberTable(false);
        if (lineNumberTable == null) {
            return null;
        }
        return lineNumberTable.getLineNumber(this);
    }

    int getLength() {
        return 1;
    }

    public int getLogicalStackChange() {
        return this.getStackChange();
    }

    public int getStackChange() {
        return 0;
    }

    public boolean equalsInstruction(Instruction instruction) {
        if (instruction == this) {
            return true;
        }
        return instruction.getOpcode() == this.getOpcode();
    }

    public Project getProject() {
        return this._owner.getProject();
    }

    public ConstantPool getPool() {
        return this._owner.getPool();
    }

    public ClassLoader getClassLoader() {
        return this._owner.getClassLoader();
    }

    public boolean isValid() {
        return this._owner != null;
    }

    public void acceptVisit(BCVisitor bCVisitor) {
    }

    void invalidate() {
        this._owner = null;
    }

    void read(Instruction instruction) {
    }

    void read(DataInput dataInput) throws IOException {
    }

    void write(DataOutput dataOutput) throws IOException {
    }
}

