/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.LocalVariableInstruction;
import serp.bytecode.visitor.BCVisitor;

public class IIncInstruction
extends LocalVariableInstruction {
    private int _inc = 0;

    IIncInstruction(Code code) {
        super(code, 132);
    }

    int getLength() {
        return super.getLength() + 2;
    }

    public int getIncrement() {
        return this._inc;
    }

    public IIncInstruction setIncrement(int n) {
        this._inc = n;
        return this;
    }

    public boolean equalsInstruction(Instruction instruction) {
        if (this == instruction) {
            return true;
        }
        if (!(instruction instanceof IIncInstruction)) {
            return false;
        }
        if (!super.equalsInstruction(instruction)) {
            return false;
        }
        IIncInstruction iIncInstruction = (IIncInstruction)instruction;
        return this.getIncrement() == 0 || iIncInstruction.getIncrement() == 0 || this.getIncrement() == iIncInstruction.getIncrement();
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterIIncInstruction(this);
        bCVisitor.exitIIncInstruction(this);
    }

    void read(Instruction instruction) {
        super.read(instruction);
        this._inc = ((IIncInstruction)instruction).getIncrement();
    }

    void read(DataInput dataInput) throws IOException {
        super.read(dataInput);
        this.setLocal(dataInput.readUnsignedByte());
        this._inc = dataInput.readByte();
    }

    void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        dataOutput.writeByte(this.getLocal());
        dataOutput.writeByte(this._inc);
    }
}

