/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import serp.bytecode.Code;
import serp.bytecode.JumpInstruction;

public class GotoInstruction
extends JumpInstruction {
    GotoInstruction(Code code, int n) {
        super(code, n);
    }

    public int getStackChange() {
        if (this.getOpcode() == 168) {
            return 1;
        }
        return 0;
    }

    int getLength() {
        switch (this.getOpcode()) {
            case 200: 
            case 201: {
                return super.getLength() + 4;
            }
        }
        return super.getLength() + 2;
    }

    public void setOffset(int n) {
        super.setOffset(n);
        this.calculateOpcode();
    }

    private void calculateOpcode() {
        int n = this.getLength();
        switch (this.getOpcode()) {
            case 167: 
            case 200: {
                int n2 = this.getOffset();
                if (n2 < 131072) {
                    this.setOpcode(167);
                    break;
                }
                this.setOpcode(200);
                break;
            }
            case 168: 
            case 201: {
                int n3 = this.getOffset();
                if (n3 < 131072) {
                    this.setOpcode(168);
                    break;
                }
                this.setOpcode(201);
            }
        }
        if (n != this.getLength()) {
            this.invalidateByteIndexes();
        }
    }
}

