/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.BCClass;
import serp.bytecode.BCEntity;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.InstructionPtr;
import serp.bytecode.InstructionPtrStrategy;
import serp.bytecode.Project;
import serp.bytecode.lowlevel.ClassEntry;
import serp.bytecode.lowlevel.ConstantPool;
import serp.bytecode.visitor.BCVisitor;
import serp.bytecode.visitor.VisitAcceptor;
import serp.util.Strings;

public class ExceptionHandler
implements InstructionPtr,
BCEntity,
VisitAcceptor {
    private int _catchIndex = 0;
    private Code _owner = null;
    private InstructionPtrStrategy _tryStart = new InstructionPtrStrategy(this);
    private InstructionPtrStrategy _tryEnd = new InstructionPtrStrategy(this);
    private InstructionPtrStrategy _tryHandler = new InstructionPtrStrategy(this);

    ExceptionHandler(Code code) {
        this._owner = code;
    }

    public Code getCode() {
        return this._owner;
    }

    public Instruction getTryStart() {
        return this._tryStart.getTargetInstruction();
    }

    public void setTryStart(Instruction instruction) {
        this._tryStart.setTargetInstruction(instruction);
    }

    public Instruction getTryEnd() {
        return this._tryEnd.getTargetInstruction();
    }

    public void setTryEnd(Instruction instruction) {
        this._tryEnd.setTargetInstruction(instruction);
    }

    public Instruction getHandlerStart() {
        return this._tryHandler.getTargetInstruction();
    }

    public void setHandlerStart(Instruction instruction) {
        this._tryHandler.setTargetInstruction(instruction);
    }

    public int getCatchIndex() {
        return this._catchIndex;
    }

    public void setCatchIndex(int n) {
        this._catchIndex = n;
    }

    public String getCatchName() {
        if (this._catchIndex == 0) {
            return null;
        }
        ClassEntry classEntry = (ClassEntry)this.getPool().getEntry(this._catchIndex);
        return this.getProject().getNameCache().getExternalForm(classEntry.getNameEntry().getValue(), false);
    }

    public Class getCatchType() {
        String string = this.getCatchName();
        if (string == null) {
            return null;
        }
        return Strings.toClass(string, this.getClassLoader());
    }

    public BCClass getCatchBC() {
        String string = this.getCatchName();
        if (string == null) {
            return null;
        }
        return this.getProject().loadClass(string, this.getClassLoader());
    }

    public void setCatch(String string) {
        this._catchIndex = string == null ? 0 : this.getPool().findClassEntry(this.getProject().getNameCache().getInternalForm(string, false), true);
    }

    public void setCatch(Class clazz) {
        if (clazz == null) {
            this.setCatch((String)null);
        } else {
            this.setCatch(clazz.getName());
        }
    }

    public void setCatch(BCClass bCClass) {
        if (bCClass == null) {
            this.setCatch((String)null);
        } else {
            this.setCatch(bCClass.getName());
        }
    }

    public void updateTargets() {
        this._tryStart.updateTargets();
        this._tryEnd.updateTargets();
        this._tryHandler.updateTargets();
    }

    public void replaceTarget(Instruction instruction, Instruction instruction2) {
        this._tryStart.replaceTarget(instruction, instruction2);
        this._tryEnd.replaceTarget(instruction, instruction2);
        this._tryHandler.replaceTarget(instruction, instruction2);
    }

    public Project getProject() {
        return this._owner.getProject();
    }

    public ConstantPool getPool() {
        return this._owner.getPool();
    }

    public ClassLoader getClassLoader() {
        return this._owner.getClassLoader();
    }

    public boolean isValid() {
        return this._owner != null;
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterExceptionHandler(this);
        bCVisitor.exitExceptionHandler(this);
    }

    void read(ExceptionHandler exceptionHandler) {
        this._tryStart.setByteIndex(exceptionHandler._tryStart.getByteIndex());
        this._tryEnd.setByteIndex(exceptionHandler._tryEnd.getByteIndex());
        this._tryHandler.setByteIndex(exceptionHandler._tryHandler.getByteIndex());
        this.setCatch(exceptionHandler.getCatchName());
    }

    void read(DataInput dataInput) throws IOException {
        this.setTryStart(dataInput.readUnsignedShort());
        this.setTryEnd(dataInput.readUnsignedShort());
        this.setHandlerStart(dataInput.readUnsignedShort());
        this.setCatchIndex(dataInput.readUnsignedShort());
    }

    void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.getTryStartPc());
        dataOutput.writeShort(this.getTryEndPc());
        dataOutput.writeShort(this.getHandlerStartPc());
        dataOutput.writeShort(this.getCatchIndex());
    }

    public void setTryStart(int n) {
        this._tryStart.setByteIndex(n);
    }

    public int getTryStartPc() {
        return this._tryStart.getByteIndex();
    }

    public void setTryEnd(int n) {
        this.setTryEnd((Instruction)this._owner.getInstruction((int)n).prev);
    }

    public int getTryEndPc() {
        return this._tryEnd.getByteIndex() + this.getTryEnd().getLength();
    }

    public void setHandlerStart(int n) {
        this._tryHandler.setByteIndex(n);
    }

    public int getHandlerStartPc() {
        return this._tryHandler.getByteIndex();
    }

    void invalidate() {
        this._owner = null;
    }
}

