/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.Attribute;
import serp.bytecode.Attributes;
import serp.bytecode.BCClass;
import serp.bytecode.BCField;
import serp.bytecode.lowlevel.ConstantEntry;
import serp.bytecode.lowlevel.DoubleEntry;
import serp.bytecode.lowlevel.FloatEntry;
import serp.bytecode.lowlevel.IntEntry;
import serp.bytecode.lowlevel.LongEntry;
import serp.bytecode.lowlevel.StringEntry;
import serp.bytecode.visitor.BCVisitor;

public class ConstantValue
extends Attribute {
    int _valueIndex = 0;

    ConstantValue(int n, Attributes attributes) {
        super(n, attributes);
    }

    int getLength() {
        return 2;
    }

    public BCField getField() {
        return (BCField)this.getOwner();
    }

    public int getValueIndex() {
        return this._valueIndex;
    }

    public void setValueIndex(int n) {
        this._valueIndex = n;
    }

    public String getTypeName() {
        Class clazz = this.getType();
        if (clazz == null) {
            return null;
        }
        return clazz.getName();
    }

    public Class getType() {
        Object object = this.getValue();
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        return String.class;
    }

    public BCClass getTypeBC() {
        return this.getProject().loadClass(this.getType());
    }

    public Object getValue() {
        if (this._valueIndex <= 0) {
            return null;
        }
        return ((ConstantEntry)((Object)this.getPool().getEntry(this._valueIndex))).getConstant();
    }

    public void setValue(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz == Boolean.class) {
            this.setIntValue((Boolean)object != false ? 1 : 0);
        } else if (clazz == Character.class) {
            this.setIntValue(((Character)object).charValue());
        } else if (clazz == Byte.class || clazz == Integer.class || clazz == Short.class) {
            this.setIntValue(((Number)object).intValue());
        } else if (clazz == Float.class) {
            this.setFloatValue(((Number)object).floatValue());
        } else if (clazz == Double.class) {
            this.setDoubleValue(((Number)object).doubleValue());
        } else if (clazz == Long.class) {
            this.setLongValue(((Number)object).longValue());
        } else {
            this.setStringValue(object.toString());
        }
    }

    public int getIntValue() {
        if (this.getValueIndex() <= 0) {
            return 0;
        }
        return ((IntEntry)this.getPool().getEntry(this.getValueIndex())).getValue();
    }

    public void setIntValue(int n) {
        this.setValueIndex(this.getPool().findIntEntry(n, true));
    }

    public float getFloatValue() {
        if (this.getValueIndex() <= 0) {
            return 0.0f;
        }
        return ((FloatEntry)this.getPool().getEntry(this.getValueIndex())).getValue();
    }

    public void setFloatValue(float f) {
        this.setValueIndex(this.getPool().findFloatEntry(f, true));
    }

    public double getDoubleValue() {
        if (this.getValueIndex() <= 0) {
            return 0.0;
        }
        return ((DoubleEntry)this.getPool().getEntry(this.getValueIndex())).getValue();
    }

    public void setDoubleValue(double d) {
        this.setValueIndex(this.getPool().findDoubleEntry(d, true));
    }

    public long getLongValue() {
        if (this.getValueIndex() <= 0) {
            return 0L;
        }
        return ((LongEntry)this.getPool().getEntry(this.getValueIndex())).getValue();
    }

    public void setLongValue(long l) {
        this.setValueIndex(this.getPool().findLongEntry(l, true));
    }

    public String getStringValue() {
        if (this.getValueIndex() <= 0) {
            return null;
        }
        return ((StringEntry)this.getPool().getEntry(this.getValueIndex())).getStringEntry().getValue();
    }

    public void setStringValue(String string) {
        this.setValueIndex(this.getPool().findStringEntry(string, true));
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterConstantValue(this);
        bCVisitor.exitConstantValue(this);
    }

    void read(Attribute attribute) {
        this.setValue(((ConstantValue)attribute).getValue());
    }

    void read(DataInput dataInput, int n) throws IOException {
        this.setValueIndex(dataInput.readUnsignedShort());
    }

    void write(DataOutput dataOutput, int n) throws IOException {
        dataOutput.writeShort(this.getValueIndex());
    }
}

