/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import serp.bytecode.ArrayLoadInstruction;
import serp.bytecode.ArrayStoreInstruction;
import serp.bytecode.Attribute;
import serp.bytecode.Attributes;
import serp.bytecode.BCClass;
import serp.bytecode.BCMethod;
import serp.bytecode.ClassConstantInstruction;
import serp.bytecode.ClassInstruction;
import serp.bytecode.CmpInstruction;
import serp.bytecode.CodeEntry;
import serp.bytecode.ConstantInstruction;
import serp.bytecode.ConvertInstruction;
import serp.bytecode.ExceptionHandler;
import serp.bytecode.GetFieldInstruction;
import serp.bytecode.GotoInstruction;
import serp.bytecode.IIncInstruction;
import serp.bytecode.IfInstruction;
import serp.bytecode.Instruction;
import serp.bytecode.InstructionPtr;
import serp.bytecode.JumpInstruction;
import serp.bytecode.LineNumberTable;
import serp.bytecode.LoadInstruction;
import serp.bytecode.LocalVariableTable;
import serp.bytecode.LocalVariableTypeTable;
import serp.bytecode.LookupSwitchInstruction;
import serp.bytecode.MathInstruction;
import serp.bytecode.MethodInstruction;
import serp.bytecode.MonitorEnterInstruction;
import serp.bytecode.MonitorExitInstruction;
import serp.bytecode.MultiANewArrayInstruction;
import serp.bytecode.NewArrayInstruction;
import serp.bytecode.Project;
import serp.bytecode.PutFieldInstruction;
import serp.bytecode.RetInstruction;
import serp.bytecode.ReturnInstruction;
import serp.bytecode.StackInstruction;
import serp.bytecode.StoreInstruction;
import serp.bytecode.TableSwitchInstruction;
import serp.bytecode.WideInstruction;
import serp.bytecode.visitor.BCVisitor;

public class Code
extends Attribute {
    private final CodeEntry _head;
    private final CodeEntry _tail;
    private CodeIterator _ci;
    private int _maxStack = 0;
    private int _maxLocals = 0;
    private int _size = 0;
    private Collection _handlers = new LinkedList();
    private Collection _attrs = new LinkedList();
    private boolean _byteIndexesValid;

    Code(int n, Attributes attributes) {
        super(n, attributes);
        this._head = new CodeEntry();
        this._head.next = this._tail = new CodeEntry();
        this._tail.prev = this._head;
        this._ci = new CodeIterator(this._head, -1);
    }

    public Code() {
        this(0, new Project().loadClass("", null).declareMethod("", Void.TYPE, null));
    }

    public BCMethod getMethod() {
        return (BCMethod)this.getOwner();
    }

    Collection getAttributesHolder() {
        return this._attrs;
    }

    public int getMaxStack() {
        return this._maxStack;
    }

    public void setMaxStack(int n) {
        this._maxStack = n;
    }

    public int getMaxLocals() {
        return this._maxLocals;
    }

    public void setMaxLocals(int n) {
        this._maxLocals = n;
    }

    public int getLocalsIndex(int n) {
        if (n < 0) {
            return -1;
        }
        int n2 = 0;
        if (!this.getMethod().isStatic()) {
            n2 = 1;
        }
        String[] stringArray = this.getMethod().getParamNames();
        int n3 = 0;
        while (n3 < n) {
            if (n3 == stringArray.length) {
                return -1;
            }
            if (stringArray[n3].equals(Long.TYPE.getName()) || stringArray[n3].equals(Double.TYPE.getName())) {
                ++n2;
            }
            ++n3;
            ++n2;
        }
        return n2;
    }

    public int getParamsIndex(int n) {
        int n2 = 0;
        if (!this.getMethod().isStatic()) {
            n2 = 1;
        }
        String[] stringArray = this.getMethod().getParamNames();
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (n == n2) {
                return n3;
            }
            if (stringArray[n3].equals(Long.TYPE.getName()) || stringArray[n3].equals(Double.TYPE.getName())) {
                ++n2;
            }
            ++n3;
            ++n2;
        }
        return -1;
    }

    public int getNextLocalsIndex() {
        this.calculateMaxLocals();
        return this.getMaxLocals();
    }

    public void calculateMaxLocals() {
        String[] stringArray = this.getMethod().getParamNames();
        int n = 0;
        if (stringArray.length == 0 && !this.getMethod().isStatic()) {
            n = 1;
        } else if (stringArray.length > 0) {
            n = this.getLocalsIndex(stringArray.length - 1) + 1;
            if (stringArray[stringArray.length - 1].equals(Long.TYPE.getName()) || stringArray[stringArray.length - 1].equals(Double.TYPE.getName())) {
                ++n;
            }
        }
        CodeEntry codeEntry = this._head.next;
        while (codeEntry != this._tail) {
            int n2 = 0;
            if (codeEntry instanceof StoreInstruction) {
                StoreInstruction storeInstruction = (StoreInstruction)codeEntry;
                n2 = storeInstruction.getLocal() + 1;
                if (storeInstruction.getType().equals(Long.TYPE) || storeInstruction.getType().equals(Double.TYPE)) {
                    ++n2;
                }
                if (n2 > n) {
                    n = n2;
                }
            }
            codeEntry = codeEntry.next;
        }
        this.setMaxLocals(n);
    }

    public void calculateMaxStack() {
        int n = 0;
        int n2 = 0;
        ExceptionHandler[] exceptionHandlerArray = this.getExceptionHandlers();
        CodeEntry codeEntry = this._head.next;
        while (codeEntry != this._tail) {
            Instruction instruction = (Instruction)codeEntry;
            n += instruction.getStackChange();
            for (int i = 0; i < exceptionHandlerArray.length; ++i) {
                if (exceptionHandlerArray[i].getTryStart() != instruction) continue;
                ++n;
            }
            if (n > n2) {
                n2 = n;
            }
            codeEntry = codeEntry.next;
        }
        this.setMaxStack(n2);
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return this._handlers.toArray(new ExceptionHandler[this._handlers.size()]);
    }

    public ExceptionHandler getExceptionHandler(String string) {
        string = this.getProject().getNameCache().getExternalForm(string, false);
        ExceptionHandler[] exceptionHandlerArray = this.getExceptionHandlers();
        for (int i = 0; i < exceptionHandlerArray.length; ++i) {
            String string2 = exceptionHandlerArray[i].getCatchName();
            if ((string2 != null || string != null) && (string2 == null || !string2.equals(string))) continue;
            return exceptionHandlerArray[i];
        }
        return null;
    }

    public ExceptionHandler getExceptionHandler(Class clazz) {
        if (clazz == null) {
            return this.getExceptionHandler((String)null);
        }
        return this.getExceptionHandler(clazz.getName());
    }

    public ExceptionHandler getExceptionHandler(BCClass bCClass) {
        if (bCClass == null) {
            return this.getExceptionHandler((String)null);
        }
        return this.getExceptionHandler(bCClass.getName());
    }

    public ExceptionHandler[] getExceptionHandlers(String string) {
        string = this.getProject().getNameCache().getExternalForm(string, false);
        LinkedList<ExceptionHandler> linkedList = new LinkedList<ExceptionHandler>();
        ExceptionHandler[] exceptionHandlerArray = this.getExceptionHandlers();
        for (int i = 0; i < exceptionHandlerArray.length; ++i) {
            String string2 = exceptionHandlerArray[i].getCatchName();
            if ((string2 != null || string != null) && (string2 == null || !string2.equals(string))) continue;
            linkedList.add(exceptionHandlerArray[i]);
        }
        return linkedList.toArray(new ExceptionHandler[linkedList.size()]);
    }

    public ExceptionHandler[] getExceptionHandlers(Class clazz) {
        if (clazz == null) {
            return this.getExceptionHandlers((String)null);
        }
        return this.getExceptionHandlers(clazz.getName());
    }

    public ExceptionHandler[] getExceptionHandlers(BCClass bCClass) {
        if (bCClass == null) {
            return this.getExceptionHandlers((String)null);
        }
        return this.getExceptionHandlers(bCClass.getName());
    }

    public void setExceptionHandlers(ExceptionHandler[] exceptionHandlerArray) {
        this.clearExceptionHandlers();
        if (exceptionHandlerArray != null) {
            for (int i = 0; i < exceptionHandlerArray.length; ++i) {
                this.addExceptionHandler(exceptionHandlerArray[i]);
            }
        }
    }

    public ExceptionHandler addExceptionHandler(ExceptionHandler exceptionHandler) {
        ExceptionHandler exceptionHandler2 = this.addExceptionHandler();
        exceptionHandler2.read(exceptionHandler);
        return exceptionHandler2;
    }

    public ExceptionHandler addExceptionHandler() {
        ExceptionHandler exceptionHandler = new ExceptionHandler(this);
        this._handlers.add(exceptionHandler);
        return exceptionHandler;
    }

    public ExceptionHandler addExceptionHandler(Instruction instruction, Instruction instruction2, Instruction instruction3, String string) {
        ExceptionHandler exceptionHandler = this.addExceptionHandler();
        exceptionHandler.setTryStart(instruction);
        exceptionHandler.setTryEnd(instruction2);
        exceptionHandler.setHandlerStart(instruction3);
        exceptionHandler.setCatch(string);
        return exceptionHandler;
    }

    public ExceptionHandler addExceptionHandler(Instruction instruction, Instruction instruction2, Instruction instruction3, Class clazz) {
        String string = null;
        if (clazz != null) {
            string = clazz.getName();
        }
        return this.addExceptionHandler(instruction, instruction2, instruction3, string);
    }

    public ExceptionHandler addExceptionHandler(Instruction instruction, Instruction instruction2, Instruction instruction3, BCClass bCClass) {
        String string = null;
        if (bCClass != null) {
            string = bCClass.getName();
        }
        return this.addExceptionHandler(instruction, instruction2, instruction3, string);
    }

    public void clearExceptionHandlers() {
        Iterator iterator = this._handlers.iterator();
        while (iterator.hasNext()) {
            ExceptionHandler exceptionHandler = (ExceptionHandler)iterator.next();
            iterator.remove();
            exceptionHandler.invalidate();
        }
    }

    public boolean removeExceptionHandler(String string) {
        return this.removeExceptionHandler(this.getExceptionHandler(string));
    }

    public boolean removeExceptionHandler(Class clazz) {
        if (clazz == null) {
            return this.removeExceptionHandler((String)null);
        }
        return this.removeExceptionHandler(clazz.getName());
    }

    public boolean removeExceptionHandler(BCClass bCClass) {
        if (bCClass == null) {
            return this.removeExceptionHandler((String)null);
        }
        return this.removeExceptionHandler(bCClass.getName());
    }

    public boolean removeExceptionHandler(ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null || !this._handlers.remove(exceptionHandler)) {
            return false;
        }
        exceptionHandler.invalidate();
        return true;
    }

    public int size() {
        return this._size;
    }

    public void beforeFirst() {
        this._ci = new CodeIterator(this._head, -1);
    }

    public void afterLast() {
        this._ci = this._size == 0 ? new CodeIterator(this._head, -1) : new CodeIterator(this._tail.prev, this._size - 1);
    }

    public void before(Instruction instruction) {
        if (instruction.getCode() != this) {
            throw new IllegalArgumentException("ins.code != this");
        }
        this._ci = new CodeIterator(instruction.prev, -99);
    }

    public void after(Instruction instruction) {
        this.before(instruction);
        this.next();
    }

    public boolean hasNext() {
        return this._ci.hasNext();
    }

    public boolean hasPrevious() {
        return this._ci.hasPrevious();
    }

    public Instruction next() {
        return (Instruction)this._ci.next();
    }

    public int nextIndex() {
        return this._ci.nextIndex();
    }

    public Instruction previous() {
        return (Instruction)this._ci.previous();
    }

    public int previousIndex() {
        return this._ci.previousIndex();
    }

    public void before(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        CodeEntry codeEntry = this._head;
        for (int i = 0; i < n; ++i) {
            codeEntry = codeEntry.next;
        }
        this._ci = new CodeIterator(codeEntry, n - 1);
    }

    public void after(int n) {
        this.before(n);
        this.next();
    }

    public boolean searchForward(Instruction instruction) {
        if (instruction == null) {
            return false;
        }
        while (this.hasNext()) {
            if (!instruction.equalsInstruction(this.next())) continue;
            return true;
        }
        return false;
    }

    public boolean searchBackward(Instruction instruction) {
        if (instruction == null) {
            return false;
        }
        while (this.hasPrevious()) {
            if (!instruction.equalsInstruction(this.previous())) continue;
            return true;
        }
        return false;
    }

    public Instruction add(Instruction instruction) {
        Instruction instruction2 = this.createInstruction(instruction.getOpcode());
        instruction2.read(instruction);
        this._ci.add(instruction2);
        return instruction2;
    }

    public Instruction set(Instruction instruction) {
        Instruction instruction2 = this.createInstruction(instruction.getOpcode());
        instruction2.read(instruction);
        this._ci.set(instruction2);
        return instruction2;
    }

    public int replace(Instruction instruction, Instruction instruction2) {
        this.beforeFirst();
        int n = 0;
        while (this.searchForward(instruction)) {
            this.set(instruction2);
            ++n;
        }
        return n;
    }

    public int replace(Instruction[] instructionArray, Instruction[] instructionArray2) {
        if (instructionArray == null || instructionArray2 == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < instructionArray.length; ++i) {
            if (instructionArray2 == null) {
                n += this.replace(instructionArray[i], null);
                continue;
            }
            n += this.replace(instructionArray[i], instructionArray2[i]);
        }
        return n;
    }

    public void remove() {
        this._ci.remove();
    }

    public ClassConstantInstruction classconstant() {
        return new ClassConstantInstruction(this.getMethod().getDeclarer(), this, this.nop());
    }

    public Instruction nop() {
        return this.addInstruction(0);
    }

    public ConstantInstruction constant() {
        return (ConstantInstruction)this.addInstruction(new ConstantInstruction(this));
    }

    public LoadInstruction xload() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this));
    }

    public LoadInstruction iload() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this).setType(Integer.TYPE));
    }

    public LoadInstruction lload() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this).setType(Long.TYPE));
    }

    public LoadInstruction fload() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this).setType(Float.TYPE));
    }

    public LoadInstruction dload() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this).setType(Double.TYPE));
    }

    public LoadInstruction aload() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this).setType(Object.class));
    }

    public StoreInstruction xstore() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this));
    }

    public StoreInstruction istore() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this).setType(Integer.TYPE));
    }

    public StoreInstruction lstore() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this).setType(Long.TYPE));
    }

    public StoreInstruction fstore() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this).setType(Float.TYPE));
    }

    public StoreInstruction dstore() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this).setType(Double.TYPE));
    }

    public StoreInstruction astore() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this).setType(Object.class));
    }

    public RetInstruction ret() {
        return (RetInstruction)this.addInstruction(169);
    }

    public IIncInstruction iinc() {
        return (IIncInstruction)this.addInstruction(132);
    }

    public WideInstruction wide() {
        return (WideInstruction)this.addInstruction(196);
    }

    public ArrayLoadInstruction xaload() {
        return (ArrayLoadInstruction)this.addInstruction(new ArrayLoadInstruction(this));
    }

    public ArrayLoadInstruction iaload() {
        return (ArrayLoadInstruction)this.addInstruction(46);
    }

    public ArrayLoadInstruction laload() {
        return (ArrayLoadInstruction)this.addInstruction(47);
    }

    public ArrayLoadInstruction faload() {
        return (ArrayLoadInstruction)this.addInstruction(48);
    }

    public ArrayLoadInstruction daload() {
        return (ArrayLoadInstruction)this.addInstruction(49);
    }

    public ArrayLoadInstruction aaload() {
        return (ArrayLoadInstruction)this.addInstruction(50);
    }

    public ArrayLoadInstruction baload() {
        return (ArrayLoadInstruction)this.addInstruction(51);
    }

    public ArrayLoadInstruction caload() {
        return (ArrayLoadInstruction)this.addInstruction(52);
    }

    public ArrayLoadInstruction saload() {
        return (ArrayLoadInstruction)this.addInstruction(53);
    }

    public ArrayStoreInstruction xastore() {
        return (ArrayStoreInstruction)this.addInstruction(new ArrayStoreInstruction(this));
    }

    public ArrayStoreInstruction iastore() {
        return (ArrayStoreInstruction)this.addInstruction(79);
    }

    public ArrayStoreInstruction lastore() {
        return (ArrayStoreInstruction)this.addInstruction(80);
    }

    public ArrayStoreInstruction fastore() {
        return (ArrayStoreInstruction)this.addInstruction(81);
    }

    public ArrayStoreInstruction dastore() {
        return (ArrayStoreInstruction)this.addInstruction(82);
    }

    public ArrayStoreInstruction aastore() {
        return (ArrayStoreInstruction)this.addInstruction(83);
    }

    public ArrayStoreInstruction bastore() {
        return (ArrayStoreInstruction)this.addInstruction(84);
    }

    public ArrayStoreInstruction castore() {
        return (ArrayStoreInstruction)this.addInstruction(85);
    }

    public ArrayStoreInstruction sastore() {
        return (ArrayStoreInstruction)this.addInstruction(86);
    }

    public StackInstruction pop() {
        return (StackInstruction)this.addInstruction(87);
    }

    public StackInstruction pop2() {
        return (StackInstruction)this.addInstruction(88);
    }

    public StackInstruction dup() {
        return (StackInstruction)this.addInstruction(89);
    }

    public StackInstruction dupx1() {
        return (StackInstruction)this.addInstruction(90);
    }

    public StackInstruction dupx2() {
        return (StackInstruction)this.addInstruction(91);
    }

    public StackInstruction dup2() {
        return (StackInstruction)this.addInstruction(92);
    }

    public StackInstruction dup2x1() {
        return (StackInstruction)this.addInstruction(93);
    }

    public StackInstruction dup2x2() {
        return (StackInstruction)this.addInstruction(94);
    }

    public StackInstruction swap() {
        return (StackInstruction)this.addInstruction(95);
    }

    public MathInstruction math() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this));
    }

    public MathInstruction xadd() {
        MathInstruction mathInstruction = this.math();
        return mathInstruction.setOperation(96);
    }

    public MathInstruction iadd() {
        return (MathInstruction)this.addInstruction(96);
    }

    public MathInstruction ladd() {
        return (MathInstruction)this.addInstruction(97);
    }

    public MathInstruction fadd() {
        return (MathInstruction)this.addInstruction(98);
    }

    public MathInstruction dadd() {
        return (MathInstruction)this.addInstruction(99);
    }

    public MathInstruction xsub() {
        MathInstruction mathInstruction = this.math();
        return mathInstruction.setOperation(100);
    }

    public MathInstruction isub() {
        return (MathInstruction)this.addInstruction(100);
    }

    public MathInstruction lsub() {
        return (MathInstruction)this.addInstruction(101);
    }

    public MathInstruction fsub() {
        return (MathInstruction)this.addInstruction(102);
    }

    public MathInstruction dsub() {
        return (MathInstruction)this.addInstruction(103);
    }

    public MathInstruction xmul() {
        MathInstruction mathInstruction = this.math();
        return mathInstruction.setOperation(104);
    }

    public MathInstruction imul() {
        return (MathInstruction)this.addInstruction(104);
    }

    public MathInstruction lmul() {
        return (MathInstruction)this.addInstruction(105);
    }

    public MathInstruction fmul() {
        return (MathInstruction)this.addInstruction(106);
    }

    public MathInstruction dmul() {
        return (MathInstruction)this.addInstruction(107);
    }

    public MathInstruction xdiv() {
        MathInstruction mathInstruction = this.math();
        return mathInstruction.setOperation(108);
    }

    public MathInstruction idiv() {
        return (MathInstruction)this.addInstruction(108);
    }

    public MathInstruction ldiv() {
        return (MathInstruction)this.addInstruction(109);
    }

    public MathInstruction fdiv() {
        return (MathInstruction)this.addInstruction(110);
    }

    public MathInstruction ddiv() {
        return (MathInstruction)this.addInstruction(111);
    }

    public MathInstruction xrem() {
        MathInstruction mathInstruction = this.math();
        return mathInstruction.setOperation(112);
    }

    public MathInstruction irem() {
        return (MathInstruction)this.addInstruction(112);
    }

    public MathInstruction lrem() {
        return (MathInstruction)this.addInstruction(113);
    }

    public MathInstruction frem() {
        return (MathInstruction)this.addInstruction(114);
    }

    public MathInstruction drem() {
        return (MathInstruction)this.addInstruction(115);
    }

    public MathInstruction xneg() {
        MathInstruction mathInstruction = this.math();
        return mathInstruction.setOperation(116);
    }

    public MathInstruction ineg() {
        return (MathInstruction)this.addInstruction(116);
    }

    public MathInstruction lneg() {
        return (MathInstruction)this.addInstruction(117);
    }

    public MathInstruction fneg() {
        return (MathInstruction)this.addInstruction(118);
    }

    public MathInstruction dneg() {
        return (MathInstruction)this.addInstruction(119);
    }

    public MathInstruction xshl() {
        MathInstruction mathInstruction = this.math();
        return mathInstruction.setOperation(120);
    }

    public MathInstruction ishl() {
        return (MathInstruction)this.addInstruction(120);
    }

    public MathInstruction lshl() {
        return (MathInstruction)this.addInstruction(121);
    }

    public MathInstruction xshr() {
        MathInstruction mathInstruction = this.math();
        return mathInstruction.setOperation(122);
    }

    public MathInstruction ishr() {
        return (MathInstruction)this.addInstruction(122);
    }

    public MathInstruction lshr() {
        return (MathInstruction)this.addInstruction(123);
    }

    public MathInstruction xushr() {
        MathInstruction mathInstruction = this.math();
        return mathInstruction.setOperation(124);
    }

    public MathInstruction iushr() {
        return (MathInstruction)this.addInstruction(124);
    }

    public MathInstruction lushr() {
        return (MathInstruction)this.addInstruction(125);
    }

    public MathInstruction xand() {
        MathInstruction mathInstruction = this.math();
        return mathInstruction.setOperation(126);
    }

    public MathInstruction iand() {
        return (MathInstruction)this.addInstruction(126);
    }

    public MathInstruction land() {
        return (MathInstruction)this.addInstruction(127);
    }

    public MathInstruction xor() {
        MathInstruction mathInstruction = this.math();
        return mathInstruction.setOperation(128);
    }

    public MathInstruction ior() {
        return (MathInstruction)this.addInstruction(128);
    }

    public MathInstruction lor() {
        return (MathInstruction)this.addInstruction(129);
    }

    public MathInstruction xxor() {
        MathInstruction mathInstruction = this.math();
        return mathInstruction.setOperation(130);
    }

    public MathInstruction ixor() {
        return (MathInstruction)this.addInstruction(130);
    }

    public MathInstruction lxor() {
        return (MathInstruction)this.addInstruction(131);
    }

    public ConvertInstruction convert() {
        return (ConvertInstruction)this.addInstruction(new ConvertInstruction(this));
    }

    public CmpInstruction xcmp() {
        return (CmpInstruction)this.addInstruction(new CmpInstruction(this));
    }

    public CmpInstruction lcmp() {
        return (CmpInstruction)this.addInstruction(148);
    }

    public CmpInstruction fcmpl() {
        return (CmpInstruction)this.addInstruction(149);
    }

    public CmpInstruction fcmpg() {
        return (CmpInstruction)this.addInstruction(150);
    }

    public CmpInstruction dcmpl() {
        return (CmpInstruction)this.addInstruction(151);
    }

    public CmpInstruction dcmpg() {
        return (CmpInstruction)this.addInstruction(152);
    }

    public IfInstruction ifeq() {
        return (IfInstruction)this.addInstruction(153);
    }

    public IfInstruction ifne() {
        return (IfInstruction)this.addInstruction(154);
    }

    public IfInstruction iflt() {
        return (IfInstruction)this.addInstruction(155);
    }

    public IfInstruction ifge() {
        return (IfInstruction)this.addInstruction(156);
    }

    public IfInstruction ifgt() {
        return (IfInstruction)this.addInstruction(157);
    }

    public IfInstruction ifle() {
        return (IfInstruction)this.addInstruction(158);
    }

    public IfInstruction ificmpeq() {
        return (IfInstruction)this.addInstruction(159);
    }

    public IfInstruction ificmpne() {
        return (IfInstruction)this.addInstruction(160);
    }

    public IfInstruction ificmplt() {
        return (IfInstruction)this.addInstruction(161);
    }

    public IfInstruction ificmpge() {
        return (IfInstruction)this.addInstruction(162);
    }

    public IfInstruction ificmpgt() {
        return (IfInstruction)this.addInstruction(163);
    }

    public IfInstruction ificmple() {
        return (IfInstruction)this.addInstruction(164);
    }

    public IfInstruction ifacmpeq() {
        return (IfInstruction)this.addInstruction(165);
    }

    public IfInstruction ifacmpne() {
        return (IfInstruction)this.addInstruction(166);
    }

    public IfInstruction ifnull() {
        return (IfInstruction)this.addInstruction(198);
    }

    public IfInstruction ifnonnull() {
        return (IfInstruction)this.addInstruction(199);
    }

    public JumpInstruction go2() {
        return (JumpInstruction)this.addInstruction(167);
    }

    public JumpInstruction jsr() {
        return (JumpInstruction)this.addInstruction(168);
    }

    public TableSwitchInstruction tableswitch() {
        return (TableSwitchInstruction)this.addInstruction(170);
    }

    public LookupSwitchInstruction lookupswitch() {
        return (LookupSwitchInstruction)this.addInstruction(171);
    }

    public ReturnInstruction xreturn() {
        return (ReturnInstruction)this.addInstruction(new ReturnInstruction(this));
    }

    public ReturnInstruction vreturn() {
        return (ReturnInstruction)this.addInstruction(177);
    }

    public ReturnInstruction ireturn() {
        return (ReturnInstruction)this.addInstruction(172);
    }

    public ReturnInstruction lreturn() {
        return (ReturnInstruction)this.addInstruction(173);
    }

    public ReturnInstruction freturn() {
        return (ReturnInstruction)this.addInstruction(174);
    }

    public ReturnInstruction dreturn() {
        return (ReturnInstruction)this.addInstruction(175);
    }

    public ReturnInstruction areturn() {
        return (ReturnInstruction)this.addInstruction(176);
    }

    public GetFieldInstruction getfield() {
        return (GetFieldInstruction)this.addInstruction(180);
    }

    public GetFieldInstruction getstatic() {
        return (GetFieldInstruction)this.addInstruction(178);
    }

    public PutFieldInstruction putfield() {
        return (PutFieldInstruction)this.addInstruction(181);
    }

    public PutFieldInstruction putstatic() {
        return (PutFieldInstruction)this.addInstruction(179);
    }

    public MethodInstruction invokevirtual() {
        return (MethodInstruction)this.addInstruction(182);
    }

    public MethodInstruction invokespecial() {
        return (MethodInstruction)this.addInstruction(183);
    }

    public MethodInstruction invokeinterface() {
        return (MethodInstruction)this.addInstruction(185);
    }

    public MethodInstruction invokestatic() {
        return (MethodInstruction)this.addInstruction(184);
    }

    public ClassInstruction anew() {
        return (ClassInstruction)this.addInstruction(187);
    }

    public ClassInstruction anewarray() {
        return (ClassInstruction)this.addInstruction(189);
    }

    public ClassInstruction checkcast() {
        return (ClassInstruction)this.addInstruction(192);
    }

    public ClassInstruction isinstance() {
        return (ClassInstruction)this.addInstruction(193);
    }

    public MultiANewArrayInstruction multianewarray() {
        return (MultiANewArrayInstruction)this.addInstruction(197);
    }

    public NewArrayInstruction newarray() {
        return (NewArrayInstruction)this.addInstruction(188);
    }

    public Instruction arraylength() {
        return this.addInstruction(190);
    }

    public Instruction athrow() {
        return this.addInstruction(191);
    }

    public MonitorEnterInstruction monitorenter() {
        return (MonitorEnterInstruction)this.addInstruction(194);
    }

    public MonitorExitInstruction monitorexit() {
        return (MonitorExitInstruction)this.addInstruction(195);
    }

    public Instruction[] getInstructions() {
        Instruction[] instructionArray = new Instruction[this._size];
        int n = 0;
        CodeEntry codeEntry = this._head.next;
        while (codeEntry != this._tail) {
            instructionArray[n++] = (Instruction)codeEntry;
            codeEntry = codeEntry.next;
        }
        return instructionArray;
    }

    int getLength() {
        int n = 12;
        Instruction instruction = this.getLastInstruction();
        if (instruction != null) {
            n += instruction.getByteIndex() + instruction.getLength();
        }
        n += 8 * this._handlers.size();
        Attribute[] attributeArray = this.getAttributes();
        for (int i = 0; i < attributeArray.length; ++i) {
            n += attributeArray[i].getLength() + 6;
        }
        return n;
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterCode(this);
        Object object = this._head.next;
        while (object != this._tail) {
            Instruction instruction = (Instruction)object;
            bCVisitor.enterInstruction(instruction);
            instruction.acceptVisit(bCVisitor);
            bCVisitor.exitInstruction(instruction);
            object = ((CodeEntry)object).next;
        }
        object = this._handlers.iterator();
        while (object.hasNext()) {
            ((ExceptionHandler)object.next()).acceptVisit(bCVisitor);
        }
        this.visitAttributes(bCVisitor);
        bCVisitor.exitCode(this);
    }

    public LineNumberTable getLineNumberTable(boolean bl) {
        LineNumberTable lineNumberTable = (LineNumberTable)this.getAttribute("LineNumberTable");
        if (!bl || lineNumberTable != null) {
            return lineNumberTable;
        }
        return (LineNumberTable)this.addAttribute("LineNumberTable");
    }

    public boolean removeLineNumberTable() {
        return this.removeAttribute("LineNumberTable");
    }

    public LocalVariableTable getLocalVariableTable(boolean bl) {
        LocalVariableTable localVariableTable = (LocalVariableTable)this.getAttribute("LocalVariableTable");
        if (!bl || localVariableTable != null) {
            return localVariableTable;
        }
        return (LocalVariableTable)this.addAttribute("LocalVariableTable");
    }

    public boolean removeLocalVariableTables() {
        return this.removeAttribute("LocalVariableTable");
    }

    public LocalVariableTypeTable getLocalVariableTypeTable(boolean bl) {
        LocalVariableTypeTable localVariableTypeTable = (LocalVariableTypeTable)this.getAttribute("LocalVariableTypeTable");
        if (!bl || localVariableTypeTable != null) {
            return localVariableTypeTable;
        }
        return (LocalVariableTypeTable)this.addAttribute("LocalVariableTypeTable");
    }

    public boolean removeLocalVariableTypeTables() {
        return this.removeAttribute("LocalVariableTypeTable");
    }

    void read(Attribute attribute) {
        LineNumberTable lineNumberTable;
        LocalVariableTypeTable localVariableTypeTable;
        Code code = (Code)attribute;
        this._maxStack = code.getMaxStack();
        this._maxLocals = code.getMaxLocals();
        this._head.next = this._tail;
        this._tail.prev = this._head;
        this._size = 0;
        this._byteIndexesValid = false;
        this.beforeFirst();
        this._handlers.clear();
        Object object = code._head.next;
        while (object != code._tail) {
            Instruction instruction = (Instruction)object;
            Instruction instruction2 = this.createInstruction(instruction.getOpcode());
            this._ci.addInternal(instruction2);
            if (!(instruction2 instanceof ConstantInstruction)) {
                instruction2.read(instruction);
            }
            object = object.next;
        }
        object = code.getExceptionHandlers();
        for (int i = 0; i < ((ExceptionHandler[])object).length; ++i) {
            ExceptionHandler exceptionHandler = this.addExceptionHandler();
            exceptionHandler.read(object[i]);
            exceptionHandler.updateTargets();
        }
        this.updateInstructionPointers();
        this.setAttributes(code.getAttributes());
        LocalVariableTable localVariableTable = this.getLocalVariableTable(false);
        if (localVariableTable != null) {
            localVariableTable.updateTargets();
        }
        if ((localVariableTypeTable = this.getLocalVariableTypeTable(false)) != null) {
            localVariableTypeTable.updateTargets();
        }
        if ((lineNumberTable = this.getLineNumberTable(false)) != null) {
            lineNumberTable.updateTargets();
        }
        CodeEntry codeEntry = this._head.next;
        CodeEntry codeEntry2 = code._head.next;
        while (codeEntry2 != code._tail) {
            if (codeEntry2 instanceof ConstantInstruction) {
                ((ConstantInstruction)codeEntry).read((Instruction)codeEntry2);
            }
            codeEntry2 = codeEntry2.next;
            codeEntry = codeEntry.next;
        }
        this.beforeFirst();
    }

    void read(DataInput dataInput, int n) throws IOException {
        LineNumberTable lineNumberTable;
        LocalVariableTypeTable localVariableTypeTable;
        this._maxStack = dataInput.readUnsignedShort();
        this._maxLocals = dataInput.readUnsignedShort();
        this.readCode(dataInput, dataInput.readInt());
        this._handlers.clear();
        int n2 = dataInput.readUnsignedShort();
        for (int i = 0; i < n2; ++i) {
            ExceptionHandler exceptionHandler = this.addExceptionHandler();
            exceptionHandler.read(dataInput);
            exceptionHandler.updateTargets();
        }
        this.readAttributes(dataInput);
        LocalVariableTable localVariableTable = this.getLocalVariableTable(false);
        if (localVariableTable != null) {
            localVariableTable.updateTargets();
        }
        if ((localVariableTypeTable = this.getLocalVariableTypeTable(false)) != null) {
            localVariableTypeTable.updateTargets();
        }
        if ((lineNumberTable = this.getLineNumberTable(false)) != null) {
            lineNumberTable.updateTargets();
        }
    }

    void write(DataOutput dataOutput, int n) throws IOException {
        dataOutput.writeShort(this._maxStack);
        dataOutput.writeShort(this._maxLocals);
        byte[] byArray = this.toByteArray();
        dataOutput.writeInt(byArray.length);
        dataOutput.write(byArray);
        dataOutput.writeShort(this._handlers.size());
        Iterator iterator = this._handlers.iterator();
        while (iterator.hasNext()) {
            ((ExceptionHandler)iterator.next()).write(dataOutput);
        }
        this.writeAttributes(dataOutput);
    }

    private void readCode(DataInput dataInput, int n) throws IOException {
        Instruction instruction;
        this._head.next = this._tail;
        this._tail.prev = this._head;
        this._size = 0;
        this._byteIndexesValid = true;
        this.beforeFirst();
        for (int i = 0; i < n; i += instruction.getLength()) {
            instruction = this.createInstruction(dataInput.readUnsignedByte());
            this._ci.addInternal(instruction);
            instruction.byteIndex = i;
            instruction.read(dataInput);
        }
        this.updateInstructionPointers();
        this.beforeFirst();
        if (!this._byteIndexesValid) {
            throw new IllegalStateException();
        }
    }

    private void updateInstructionPointers() {
        CodeEntry codeEntry = this._head.next;
        while (codeEntry != this._tail) {
            if (codeEntry instanceof InstructionPtr) {
                ((InstructionPtr)((Object)codeEntry)).updateTargets();
            }
            codeEntry = codeEntry.next;
        }
    }

    int getByteIndex(Instruction instruction) {
        if (this._byteIndexesValid && instruction.byteIndex != -1) {
            return instruction.byteIndex;
        }
        int n = 0;
        CodeEntry codeEntry = this._head.next;
        while (codeEntry != this._tail) {
            if (codeEntry == instruction) {
                return n;
            }
            n += ((Instruction)codeEntry).getLength();
            codeEntry = codeEntry.next;
        }
        throw new IllegalArgumentException("ins.owner != this");
    }

    void invalidateByteIndexes() {
        this._byteIndexesValid = false;
    }

    Instruction getInstruction(int n) {
        if (n < 0) {
            return null;
        }
        int n2 = 0;
        CodeEntry codeEntry = this._head.next;
        while (codeEntry != this._tail) {
            if (n == n2) {
                return (Instruction)codeEntry;
            }
            n2 += ((Instruction)codeEntry).getLength();
            codeEntry = codeEntry.next;
        }
        if (n == n2) {
            return null;
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    Instruction getFirstInstruction() {
        return (Instruction)this._head.next;
    }

    Instruction getLastInstruction() {
        return (Instruction)this._tail.prev;
    }

    private int indexOf(Instruction instruction) {
        int n = 0;
        CodeEntry codeEntry = this._head.next;
        while (codeEntry != this._tail) {
            if (codeEntry == instruction) {
                return n;
            }
            codeEntry = codeEntry.next;
            ++n;
        }
        throw new IllegalArgumentException("ins.code != this");
    }

    private void writeCode(DataOutput dataOutput) throws IOException {
        CodeEntry codeEntry = this._head.next;
        while (codeEntry != this._tail) {
            Instruction instruction = (Instruction)codeEntry;
            dataOutput.writeByte(instruction.getOpcode());
            instruction.write(dataOutput);
            codeEntry = codeEntry.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] toByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.writeCode(dataOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            try {
                dataOutputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fromByteArray(byte[] byArray) throws IOException {
        if (byArray == null) {
            this._head.next = this._tail;
            this._tail.prev = this._head;
            this._size = 0;
        } else {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            try {
                this.readCode(dataInputStream, byArray.length);
            }
            finally {
                try {
                    dataInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private Instruction addInstruction(Instruction instruction) {
        this._ci.add(instruction);
        return instruction;
    }

    private Instruction addInstruction(int n) {
        return this.addInstruction(this.createInstruction(n));
    }

    private Instruction createInstruction(int n) {
        switch (n) {
            case 0: 
            case 190: 
            case 191: {
                return new Instruction(this, n);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return new ConstantInstruction(this, n);
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return new LoadInstruction(this, n);
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return new ArrayLoadInstruction(this, n);
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                return new StoreInstruction(this, n);
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                return new ArrayStoreInstruction(this, n);
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                return new StackInstruction(this, n);
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                return new MathInstruction(this, n);
            }
            case 132: {
                return new IIncInstruction(this);
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                return new ConvertInstruction(this, n);
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                return new CmpInstruction(this, n);
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 198: 
            case 199: {
                return new IfInstruction(this, n);
            }
            case 167: 
            case 168: 
            case 200: 
            case 201: {
                return new GotoInstruction(this, n);
            }
            case 169: {
                return new RetInstruction(this);
            }
            case 170: {
                return new TableSwitchInstruction(this);
            }
            case 171: {
                return new LookupSwitchInstruction(this);
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                return new ReturnInstruction(this, n);
            }
            case 178: 
            case 180: {
                return new GetFieldInstruction(this, n);
            }
            case 179: 
            case 181: {
                return new PutFieldInstruction(this, n);
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                return new MethodInstruction(this, n);
            }
            case 187: 
            case 189: 
            case 192: 
            case 193: {
                return new ClassInstruction(this, n);
            }
            case 188: {
                return new NewArrayInstruction(this);
            }
            case 194: {
                return new MonitorEnterInstruction(this);
            }
            case 195: {
                return new MonitorExitInstruction(this);
            }
            case 196: {
                return new WideInstruction(this);
            }
            case 197: {
                return new MultiANewArrayInstruction(this);
            }
        }
        throw new IllegalArgumentException("Illegal opcode: " + n);
    }

    public ListIterator listIterator() {
        return new CodeIterator(this._head, -1);
    }

    private class CodeIterator
    implements ListIterator {
        public static final int UNSET = -99;
        private CodeEntry _bn = null;
        private Instruction _last = null;
        private int _index = -99;

        public CodeIterator(CodeEntry codeEntry, int n) {
            this._bn = codeEntry;
            this._index = n;
        }

        public boolean hasNext() {
            return this._bn.next != Code.this._tail;
        }

        public boolean hasPrevious() {
            return this._bn != Code.this._head;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this._bn = this._bn.next;
            this._last = (Instruction)this._bn;
            if (this._index != -99) {
                ++this._index;
            }
            return this._last;
        }

        public int nextIndex() {
            return this.initIndex() + 1;
        }

        public Object previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this._last = (Instruction)this._bn;
            this._bn = this._bn.prev;
            if (this._index != -99) {
                --this._index;
            }
            return this._last;
        }

        public int previousIndex() {
            return this.initIndex();
        }

        private int initIndex() {
            if (this._index == -99) {
                this._index = this._bn == Code.this._head ? -1 : Code.this.indexOf((Instruction)this._bn);
            }
            return this._index;
        }

        public void add(Object object) {
            this.addInternal(object);
            Code.this.invalidateByteIndexes();
        }

        private void addInternal(Object object) {
            if (object == null) {
                throw new NullPointerException("obj = null");
            }
            Instruction instruction = (Instruction)object;
            if (Code.this._size == 0) {
                ((Code)Code.this)._head.next = instruction;
                ((Code)Code.this)._tail.prev = instruction;
                instruction.prev = Code.this._head;
                instruction.next = Code.this._tail;
                this._index = 0;
            } else {
                CodeEntry codeEntry = this._bn.next;
                this._bn.next = instruction;
                codeEntry.prev = instruction;
                instruction.prev = this._bn;
                instruction.next = codeEntry;
                if (this._index != -99) {
                    ++this._index;
                }
            }
            this._bn = instruction;
            this._last = instruction;
            Code.this._size++;
        }

        public void set(Object object) {
            if (object == null) {
                throw new NullPointerException("obj = null");
            }
            if (this._last == null) {
                throw new IllegalStateException();
            }
            Instruction instruction = (Instruction)object;
            instruction.prev = this._last.prev;
            instruction.next = this._last.next;
            instruction.prev.next = instruction;
            instruction.next.prev = instruction;
            this.replaceTarget(this._last, instruction);
            this._last.invalidate();
            if (this._bn == this._last) {
                this._bn = instruction;
            }
            this._last = instruction;
            Code.this.invalidateByteIndexes();
        }

        public void remove() {
            if (this._last == null) {
                throw new IllegalStateException();
            }
            if (this._bn == this._last) {
                this._bn = this._last.prev;
            }
            --this._index;
            this._last.prev.next = this._last.next;
            this._last.next.prev = this._last.prev;
            Code.this._size--;
            Instruction instruction = this._last;
            Instruction instruction2 = null;
            instruction2 = instruction.next != Code.this._tail ? (Instruction)instruction.next : Code.this.nop();
            this.replaceTarget(instruction, instruction2);
            instruction.invalidate();
            this._last = null;
            Code.this.invalidateByteIndexes();
        }

        private void replaceTarget(Instruction instruction, Instruction instruction2) {
            LocalVariableTypeTable localVariableTypeTable;
            LocalVariableTable localVariableTable;
            Object object = ((Code)Code.this)._head.next;
            while (object != Code.this._tail) {
                if (object instanceof InstructionPtr) {
                    ((InstructionPtr)object).replaceTarget(instruction, instruction2);
                }
                object = object.next;
            }
            object = Code.this.getExceptionHandlers();
            for (int i = 0; i < ((ExceptionHandler[])object).length; ++i) {
                object[i].replaceTarget(instruction, instruction2);
            }
            LineNumberTable lineNumberTable = Code.this.getLineNumberTable(false);
            if (lineNumberTable != null) {
                lineNumberTable.replaceTarget(instruction, instruction2);
            }
            if ((localVariableTable = Code.this.getLocalVariableTable(false)) != null) {
                localVariableTable.replaceTarget(instruction, instruction2);
            }
            if ((localVariableTypeTable = Code.this.getLocalVariableTypeTable(false)) != null) {
                localVariableTypeTable.replaceTarget(instruction, instruction2);
            }
        }
    }
}

