/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.TypedInstruction;
import serp.bytecode.lowlevel.ClassEntry;
import serp.bytecode.visitor.BCVisitor;

public class ClassInstruction
extends TypedInstruction {
    private int _index = 0;

    ClassInstruction(Code code, int n) {
        super(code, n);
    }

    public int getStackChange() {
        if (this.getOpcode() == 187) {
            return 1;
        }
        return 0;
    }

    int getLength() {
        return super.getLength() + 2;
    }

    public int getTypeIndex() {
        return this._index;
    }

    public ClassInstruction setTypeIndex(int n) {
        this._index = n;
        return this;
    }

    public String getTypeName() {
        if (this._index == 0) {
            return null;
        }
        ClassEntry classEntry = (ClassEntry)this.getPool().getEntry(this._index);
        return this.getProject().getNameCache().getExternalForm(classEntry.getNameEntry().getValue(), false);
    }

    public TypedInstruction setType(String string) {
        if (string == null) {
            this._index = 0;
        } else {
            string = this.getProject().getNameCache().getInternalForm(string, false);
            this._index = this.getPool().findClassEntry(string, true);
        }
        return this;
    }

    public boolean equalsInstruction(Instruction instruction) {
        if (instruction == this) {
            return true;
        }
        if (!super.equalsInstruction(instruction)) {
            return false;
        }
        String string = this.getTypeName();
        String string2 = ((ClassInstruction)instruction).getTypeName();
        return string == null || string2 == null || string.equals(string2);
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterClassInstruction(this);
        bCVisitor.exitClassInstruction(this);
    }

    void read(Instruction instruction) {
        super.read(instruction);
        this.setType(((ClassInstruction)instruction).getTypeName());
    }

    void read(DataInput dataInput) throws IOException {
        super.read(dataInput);
        this._index = dataInput.readUnsignedShort();
    }

    void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        dataOutput.writeShort(this._index);
    }
}

