/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.util.HashMap;
import java.util.Map;
import serp.bytecode.BCClass;
import serp.bytecode.BCField;
import serp.bytecode.BCMethod;
import serp.bytecode.Code;
import serp.bytecode.IfInstruction;
import serp.bytecode.Instruction;
import serp.bytecode.JumpInstruction;
import serp.bytecode.LocalVariableInstruction;
import serp.bytecode.ReturnInstruction;

public class ClassConstantInstruction {
    private static final Class[] _params = new Class[]{String.class};
    private static final Map _wrappers = new HashMap();
    private Instruction _ins = null;
    private Code _code = null;
    private BCClass _class = null;
    private boolean _invalid = false;

    ClassConstantInstruction(BCClass bCClass, Code code, Instruction instruction) {
        this._class = bCClass;
        this._code = code;
        this._ins = instruction;
    }

    public Instruction setClass(String string) {
        string = this._class.getProject().getNameCache().getExternalForm(string, false);
        this.setClassName(string, ClassConstantInstruction.getWrapperClass(string));
        return this._ins;
    }

    public Instruction setClass(Class clazz) {
        return this.setClass(clazz.getName());
    }

    public Instruction setClass(BCClass bCClass) {
        return this.setClass(bCClass.getName());
    }

    private void setClassName(String string, Class clazz) {
        if (this._invalid) {
            throw new IllegalStateException();
        }
        Instruction instruction = this._code.hasNext() ? this._code.next() : null;
        this._code.before(this._ins);
        this._code.next();
        if (clazz != null) {
            this._code.getstatic().setField(clazz, "TYPE", Class.class);
        } else {
            this.setObject(string);
        }
        if (instruction != null) {
            this._code.before(instruction);
        } else {
            this._code.afterLast();
        }
        this._invalid = true;
    }

    private void setObject(String string) {
        BCField bCField = this.addClassField(string);
        BCMethod bCMethod = this.addClassLoadMethod();
        this._code.getstatic().setField(bCField);
        IfInstruction ifInstruction = this._code.ifnull();
        this._code.getstatic().setField(bCField);
        JumpInstruction jumpInstruction = this._code.go2();
        ifInstruction.setTarget(this._code.constant().setValue(string));
        this._code.invokestatic().setMethod(bCMethod);
        this._code.dup();
        this._code.putstatic().setField(bCField);
        jumpInstruction.setTarget(this._code.nop());
    }

    private BCField addClassField(String string) {
        String string2 = "class$L" + string.replace('.', '$').replace('[', '$').replace(';', '$');
        BCField bCField = this._class.getDeclaredField(string2);
        if (bCField == null) {
            bCField = this._class.declareField(string2, Class.class);
            bCField.makePackage();
            bCField.setStatic(true);
            bCField.setSynthetic(true);
        }
        return bCField;
    }

    private BCMethod addClassLoadMethod() {
        BCMethod bCMethod = this._class.getDeclaredMethod("class$", _params);
        if (bCMethod != null) {
            return bCMethod;
        }
        bCMethod = this._class.declareMethod("class$", Class.class, _params);
        bCMethod.setStatic(true);
        bCMethod.makePackage();
        bCMethod.setSynthetic(true);
        Code code = bCMethod.getCode(true);
        code.setMaxStack(3);
        code.setMaxLocals(2);
        LocalVariableInstruction localVariableInstruction = code.aload().setLocal(0);
        code.invokestatic().setMethod(Class.class, "forName", Class.class, _params);
        ReturnInstruction returnInstruction = code.areturn();
        LocalVariableInstruction localVariableInstruction2 = code.astore().setLocal(1);
        code.anew().setType(NoClassDefFoundError.class);
        code.dup();
        code.aload().setLocal(1);
        code.invokevirtual().setMethod(Throwable.class, "getMessage", String.class, null);
        code.invokespecial().setMethod(NoClassDefFoundError.class, "<init>", Void.TYPE, _params);
        code.athrow();
        code.addExceptionHandler((Instruction)localVariableInstruction, (Instruction)returnInstruction, (Instruction)localVariableInstruction2, ClassNotFoundException.class);
        return bCMethod;
    }

    private static Class getWrapperClass(String string) {
        if (string == null) {
            return null;
        }
        return (Class)_wrappers.get(string);
    }

    static {
        _wrappers.put(Byte.TYPE.getName(), Byte.class);
        _wrappers.put(Boolean.TYPE.getName(), Boolean.class);
        _wrappers.put(Character.TYPE.getName(), Character.class);
        _wrappers.put(Double.TYPE.getName(), Double.class);
        _wrappers.put(Float.TYPE.getName(), Float.class);
        _wrappers.put(Integer.TYPE.getName(), Integer.class);
        _wrappers.put(Long.TYPE.getName(), Long.class);
        _wrappers.put(Short.TYPE.getName(), Short.class);
    }
}

