/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import serp.bytecode.Annotated;
import serp.bytecode.BCField;
import serp.bytecode.BCMethod;
import serp.bytecode.Code;
import serp.bytecode.InnerClasses;
import serp.bytecode.Project;
import serp.bytecode.SourceFile;
import serp.bytecode.State;
import serp.bytecode.lowlevel.ClassEntry;
import serp.bytecode.lowlevel.ConstantPool;
import serp.bytecode.visitor.BCVisitor;
import serp.bytecode.visitor.VisitAcceptor;
import serp.util.Numbers;
import serp.util.Strings;

public class BCClass
extends Annotated
implements VisitAcceptor {
    private Project _project = null;
    private State _state = null;
    private ClassLoader _loader = null;

    BCClass(Project project) {
        this._project = project;
    }

    void setState(State state) {
        this._state = state;
    }

    void invalidate() {
        this._project = null;
        this._state = State.INVALID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read(File file, ClassLoader classLoader) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.read(fileInputStream, classLoader);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    void read(InputStream inputStream, ClassLoader classLoader) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this._state.setMagic(dataInputStream.readInt());
        this._state.setMinorVersion(dataInputStream.readUnsignedShort());
        this._state.setMajorVersion(dataInputStream.readUnsignedShort());
        this._state.getPool().read(dataInputStream);
        this._state.setAccessFlags(dataInputStream.readUnsignedShort());
        this._state.setIndex(dataInputStream.readUnsignedShort());
        this._state.setSuperclassIndex(dataInputStream.readUnsignedShort());
        List list = this._state.getInterfacesHolder();
        list.clear();
        int n = dataInputStream.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            list.add(Numbers.valueOf(dataInputStream.readUnsignedShort()));
        }
        List list2 = this._state.getFieldsHolder();
        list2.clear();
        int n2 = dataInputStream.readUnsignedShort();
        for (int i = 0; i < n2; ++i) {
            BCField bCField = new BCField(this);
            list2.add(bCField);
            bCField.read(dataInputStream);
        }
        List list3 = this._state.getMethodsHolder();
        list3.clear();
        int n3 = dataInputStream.readUnsignedShort();
        for (int i = 0; i < n3; ++i) {
            BCMethod bCMethod = new BCMethod(this);
            list3.add(bCMethod);
            bCMethod.read(dataInputStream);
        }
        this.readAttributes(dataInputStream);
        this._loader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read(Class clazz) throws IOException {
        int n = clazz.getName().lastIndexOf(46) + 1;
        String string = clazz.getName().substring(n);
        InputStream inputStream = clazz.getResourceAsStream(string + ".class");
        try {
            this.read(inputStream, clazz.getClassLoader());
        }
        finally {
            inputStream.close();
        }
    }

    void read(BCClass bCClass) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bCClass.toByteArray());
            this.read(byteArrayInputStream, bCClass.getClassLoader());
            byteArrayInputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        String string = this.getName();
        int n = string.lastIndexOf(46) + 1;
        string = string.substring(n);
        Class clazz = this.getType();
        FileOutputStream fileOutputStream = new FileOutputStream(URLDecoder.decode(clazz.getResource(string + ".class").getFile()));
        try {
            this.write(fileOutputStream);
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            this.write(fileOutputStream);
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(this._state.getMagic());
        dataOutputStream.writeShort(this._state.getMinorVersion());
        dataOutputStream.writeShort(this._state.getMajorVersion());
        this._state.getPool().write(dataOutputStream);
        dataOutputStream.writeShort(this._state.getAccessFlags());
        dataOutputStream.writeShort(this._state.getIndex());
        dataOutputStream.writeShort(this._state.getSuperclassIndex());
        List list = this._state.getInterfacesHolder();
        dataOutputStream.writeShort(list.size());
        Object object = list.iterator();
        while (object.hasNext()) {
            dataOutputStream.writeShort(((Number)object.next()).intValue());
        }
        object = this._state.getFieldsHolder();
        dataOutputStream.writeShort(object.size());
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            ((BCField)object2.next()).write(dataOutputStream);
        }
        object2 = this._state.getMethodsHolder();
        dataOutputStream.writeShort(object2.size());
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            ((BCMethod)iterator.next()).write(dataOutputStream);
        }
        this.writeAttributes(dataOutputStream);
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.write(byteArrayOutputStream);
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public int getMagic() {
        return this._state.getMagic();
    }

    public void setMagic(int n) {
        this._state.setMagic(n);
    }

    public int getMajorVersion() {
        return this._state.getMajorVersion();
    }

    public void setMajorVersion(int n) {
        this._state.setMajorVersion(n);
    }

    public int getMinorVersion() {
        return this._state.getMinorVersion();
    }

    public void setMinorVersion(int n) {
        this._state.setMinorVersion(n);
    }

    public int getAccessFlags() {
        return this._state.getAccessFlags();
    }

    public void setAccessFlags(int n) {
        this._state.setAccessFlags(n);
    }

    public boolean isPublic() {
        return (this.getAccessFlags() & 1) > 0;
    }

    public void makePublic() {
        this.setAccessFlags(this.getAccessFlags() | 1);
    }

    public boolean isPackage() {
        return !this.isPublic();
    }

    public void makePackage() {
        this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFFE);
    }

    public boolean isFinal() {
        return (this.getAccessFlags() & 0x10) > 0;
    }

    public void setFinal(boolean bl) {
        if (bl) {
            this.setAccessFlags(this.getAccessFlags() | 0x10);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFEF);
        }
    }

    public boolean isInterface() {
        return (this.getAccessFlags() & 0x200) > 0;
    }

    public void setInterface(boolean bl) {
        if (bl) {
            this.setAccessFlags(this.getAccessFlags() | 0x200);
            this.setAbstract(true);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFFDFF);
        }
    }

    public boolean isAbstract() {
        return (this.getAccessFlags() & 0x400) > 0;
    }

    public void setAbstract(boolean bl) {
        if (bl) {
            this.setAccessFlags(this.getAccessFlags() | 0x400);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFFBFF);
        }
    }

    public boolean isSynthetic() {
        return (this.getAccessFlags() & 0x1000) > 0;
    }

    public void setSynthetic(boolean bl) {
        if (bl) {
            this.setAccessFlags(this.getAccessFlags() | 0x1000);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFEFFF);
        }
    }

    public boolean isAnnotation() {
        return (this.getAccessFlags() & 0x2000) > 0;
    }

    public void setAnnotation(boolean bl) {
        if (bl) {
            this.setAccessFlags(this.getAccessFlags() | 0x2000);
            this.setAccessFlags(this.getAccessFlags() | 0x200);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFDFFF);
        }
    }

    public boolean isEnum() {
        return (this.getAccessFlags() & 0x4000) > 0;
    }

    public void setEnum(boolean bl) {
        if (bl) {
            this.setAccessFlags(this.getAccessFlags() | 0x4000);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFBFFF);
        }
    }

    public boolean isPrimitive() {
        return this._state.isPrimitive();
    }

    public boolean isArray() {
        return this._state.isArray();
    }

    public int getIndex() {
        return this._state.getIndex();
    }

    public void setIndex(int n) {
        String string = this.getName();
        String string2 = ((ClassEntry)this.getPool().getEntry(n)).getNameEntry().getValue();
        this.beforeRename(string, string2);
        this._state.setIndex(n);
    }

    public String getName() {
        return this._state.getName();
    }

    public String getClassName() {
        String string = this._project.getNameCache().getExternalForm(this.getName(), true);
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public String getPackageName() {
        String string = this._project.getNameCache().getExternalForm(this.getName(), true);
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    public void setName(String string) {
        string = this._project.getNameCache().getExternalForm(string, false);
        String string2 = this.getName();
        int n = this.getIndex();
        if (n == 0) {
            n = this.getPool().findClassEntry(string, true);
        }
        ClassEntry classEntry = (ClassEntry)this.getPool().getEntry(n);
        this.beforeRename(string2, string);
        int n2 = this.getPool().findUTF8Entry(this._project.getNameCache().getInternalForm(string, false), true);
        classEntry.setNameIndex(n2);
        this._state.setIndex(n);
    }

    public Class getType() {
        return Strings.toClass(this.getName(), this.getClassLoader());
    }

    public String getComponentName() {
        return this._state.getComponentName();
    }

    public Class getComponentType() {
        String string = this.getComponentName();
        if (string == null) {
            return null;
        }
        return Strings.toClass(string, this.getClassLoader());
    }

    public BCClass getComponentBC() {
        String string = this.getComponentName();
        if (string == null) {
            return null;
        }
        return this.getProject().loadClass(string, this.getClassLoader());
    }

    public int getSuperclassIndex() {
        return this._state.getSuperclassIndex();
    }

    public void setSuperclassIndex(int n) {
        this._state.setSuperclassIndex(n);
    }

    public String getSuperclassName() {
        return this._state.getSuperclassName();
    }

    public Class getSuperclassType() {
        String string = this.getSuperclassName();
        if (string == null) {
            return null;
        }
        return Strings.toClass(string, this.getClassLoader());
    }

    public BCClass getSuperclassBC() {
        String string = this.getSuperclassName();
        if (string == null) {
            return null;
        }
        return this.getProject().loadClass(string, this.getClassLoader());
    }

    public void setSuperclass(String string) {
        if (string == null) {
            this.setSuperclassIndex(0);
        } else {
            this.setSuperclassIndex(this.getPool().findClassEntry(this._project.getNameCache().getInternalForm(string, false), true));
        }
    }

    public void setSuperclass(Class clazz) {
        if (clazz == null) {
            this.setSuperclass((String)null);
        } else {
            this.setSuperclass(clazz.getName());
        }
    }

    public void setSuperclass(BCClass bCClass) {
        if (bCClass == null) {
            this.setSuperclass((String)null);
        } else {
            this.setSuperclass(bCClass.getName());
        }
    }

    public int[] getDeclaredInterfaceIndexes() {
        List list = this._state.getInterfacesHolder();
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            nArray[i] = ((Number)list.get(i)).intValue();
        }
        return nArray;
    }

    public void setDeclaredInterfaceIndexes(int[] nArray) {
        List list = this._state.getInterfacesHolder();
        list.clear();
        for (int i = 0; i < nArray.length; ++i) {
            Integer n = Numbers.valueOf(nArray[i]);
            if (list.contains(n)) continue;
            list.add(n);
        }
    }

    public String[] getDeclaredInterfaceNames() {
        int[] nArray = this.getDeclaredInterfaceIndexes();
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            ClassEntry classEntry = (ClassEntry)this.getPool().getEntry(nArray[i]);
            stringArray[i] = this._project.getNameCache().getExternalForm(classEntry.getNameEntry().getValue(), false);
        }
        return stringArray;
    }

    public Class[] getDeclaredInterfaceTypes() {
        String[] stringArray = this.getDeclaredInterfaceNames();
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i] = Strings.toClass(stringArray[i], this.getClassLoader());
        }
        return classArray;
    }

    public BCClass[] getDeclaredInterfaceBCs() {
        String[] stringArray = this.getDeclaredInterfaceNames();
        BCClass[] bCClassArray = new BCClass[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            bCClassArray[i] = this.getProject().loadClass(stringArray[i], this.getClassLoader());
        }
        return bCClassArray;
    }

    public void setDeclaredInterfaces(String[] stringArray) {
        this.clearDeclaredInterfaces();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.declareInterface(stringArray[i]);
            }
        }
    }

    public void setDeclaredInterfaces(Class[] classArray) {
        String[] stringArray = null;
        if (classArray != null) {
            stringArray = new String[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                stringArray[i] = classArray[i].getName();
            }
        }
        this.setDeclaredInterfaces(stringArray);
    }

    public void setDeclaredInterfaces(BCClass[] bCClassArray) {
        String[] stringArray = null;
        if (bCClassArray != null) {
            stringArray = new String[bCClassArray.length];
            for (int i = 0; i < bCClassArray.length; ++i) {
                stringArray[i] = bCClassArray[i].getName();
            }
        }
        this.setDeclaredInterfaces(stringArray);
    }

    public String[] getInterfaceNames() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (BCClass bCClass = this; bCClass != null; bCClass = bCClass.getSuperclassBC()) {
            String[] stringArray = bCClass.getDeclaredInterfaceNames();
            for (int i = 0; i < stringArray.length; ++i) {
                linkedList.add(stringArray[i]);
            }
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public Class[] getInterfaceTypes() {
        LinkedList<Class> linkedList = new LinkedList<Class>();
        for (BCClass bCClass = this; bCClass != null; bCClass = bCClass.getSuperclassBC()) {
            Class[] classArray = bCClass.getDeclaredInterfaceTypes();
            for (int i = 0; i < classArray.length; ++i) {
                linkedList.add(classArray[i]);
            }
        }
        return linkedList.toArray(new Class[linkedList.size()]);
    }

    public BCClass[] getInterfaceBCs() {
        LinkedList<BCClass> linkedList = new LinkedList<BCClass>();
        for (BCClass bCClass = this; bCClass != null; bCClass = bCClass.getSuperclassBC()) {
            BCClass[] bCClassArray = bCClass.getDeclaredInterfaceBCs();
            for (int i = 0; i < bCClassArray.length; ++i) {
                linkedList.add(bCClassArray[i]);
            }
        }
        return linkedList.toArray(new BCClass[linkedList.size()]);
    }

    public void clearDeclaredInterfaces() {
        this._state.getInterfacesHolder().clear();
    }

    public boolean removeDeclaredInterface(String string) {
        String[] stringArray = this.getDeclaredInterfaceNames();
        Iterator iterator = this._state.getInterfacesHolder().iterator();
        for (int i = 0; i < stringArray.length; ++i) {
            iterator.next();
            if (!stringArray[i].equals(string)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean removeDeclaredInterface(Class clazz) {
        if (clazz == null) {
            return false;
        }
        return this.removeDeclaredInterface(clazz.getName());
    }

    public boolean removeDeclaredInterface(BCClass bCClass) {
        if (bCClass == null) {
            return false;
        }
        return this.removeDeclaredInterface(bCClass.getName());
    }

    public void moveDeclaredInterface(int n, int n2) {
        if (n == n2) {
            return;
        }
        List list = this._state.getInterfacesHolder();
        Object e = list.remove(n);
        list.add(n2, e);
    }

    public void declareInterface(String string) {
        Integer n = Numbers.valueOf(this.getPool().findClassEntry(this._project.getNameCache().getInternalForm(string, false), true));
        List list = this._state.getInterfacesHolder();
        if (!list.contains(n)) {
            list.add(n);
        }
    }

    public void declareInterface(Class clazz) {
        this.declareInterface(clazz.getName());
    }

    public void declareInterface(BCClass bCClass) {
        this.declareInterface(bCClass.getName());
    }

    public boolean isInstanceOf(String string) {
        string = this._project.getNameCache().getExternalForm(string, false);
        String[] stringArray = this.getInterfaceNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        for (BCClass bCClass = this; bCClass != null; bCClass = bCClass.getSuperclassBC()) {
            if (!bCClass.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isInstanceOf(Class clazz) {
        if (clazz == null) {
            return false;
        }
        return this.isInstanceOf(clazz.getName());
    }

    public boolean isInstanceOf(BCClass bCClass) {
        if (bCClass == null) {
            return false;
        }
        return this.isInstanceOf(bCClass.getName());
    }

    public BCField[] getDeclaredFields() {
        List list = this._state.getFieldsHolder();
        return list.toArray(new BCField[list.size()]);
    }

    public BCField getDeclaredField(String string) {
        BCField[] bCFieldArray = this.getDeclaredFields();
        for (int i = 0; i < bCFieldArray.length; ++i) {
            if (!bCFieldArray[i].getName().equals(string)) continue;
            return bCFieldArray[i];
        }
        return null;
    }

    public BCField[] getFields() {
        LinkedList<BCField> linkedList = new LinkedList<BCField>();
        for (BCClass bCClass = this; bCClass != null; bCClass = bCClass.getSuperclassBC()) {
            BCField[] bCFieldArray = bCClass.getDeclaredFields();
            for (int i = 0; i < bCFieldArray.length; ++i) {
                linkedList.add(bCFieldArray[i]);
            }
        }
        return linkedList.toArray(new BCField[linkedList.size()]);
    }

    public BCField[] getFields(String string) {
        LinkedList<BCField> linkedList = new LinkedList<BCField>();
        BCField[] bCFieldArray = this.getFields();
        for (int i = 0; i < bCFieldArray.length; ++i) {
            if (!bCFieldArray[i].getName().equals(string)) continue;
            linkedList.add(bCFieldArray[i]);
        }
        return linkedList.toArray(new BCField[linkedList.size()]);
    }

    public void setDeclaredFields(BCField[] bCFieldArray) {
        this.clearDeclaredFields();
        if (bCFieldArray != null) {
            for (int i = 0; i < bCFieldArray.length; ++i) {
                this.declareField(bCFieldArray[i]);
            }
        }
    }

    public BCField declareField(BCField bCField) {
        BCField bCField2 = this.declareField(bCField.getName(), bCField.getTypeName());
        bCField2.setAccessFlags(bCField.getAccessFlags());
        bCField2.setAttributes(bCField.getAttributes());
        return bCField2;
    }

    public BCField declareField(String string, String string2) {
        BCField bCField = new BCField(this);
        this._state.getFieldsHolder().add(bCField);
        bCField.initialize(string, this._project.getNameCache().getInternalForm(string2, true));
        return bCField;
    }

    public BCField declareField(String string, Class clazz) {
        String string2 = clazz == null ? null : clazz.getName();
        return this.declareField(string, string2);
    }

    public BCField declareField(String string, BCClass bCClass) {
        String string2 = bCClass == null ? null : bCClass.getName();
        return this.declareField(string, string2);
    }

    public void clearDeclaredFields() {
        List list = this._state.getFieldsHolder();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            BCField bCField = (BCField)iterator.next();
            iterator.remove();
            bCField.invalidate();
        }
    }

    public boolean removeDeclaredField(String string) {
        List list = this._state.getFieldsHolder();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            BCField bCField = (BCField)iterator.next();
            if (!bCField.getName().equals(string)) continue;
            iterator.remove();
            bCField.invalidate();
            return true;
        }
        return false;
    }

    public boolean removeDeclaredField(BCField bCField) {
        if (bCField == null) {
            return false;
        }
        return this.removeDeclaredField(bCField.getName());
    }

    public void moveDeclaredField(int n, int n2) {
        if (n == n2) {
            return;
        }
        List list = this._state.getFieldsHolder();
        Object e = list.remove(n);
        list.add(n2, e);
    }

    public BCMethod[] getDeclaredMethods() {
        List list = this._state.getMethodsHolder();
        return list.toArray(new BCMethod[list.size()]);
    }

    public BCMethod getDeclaredMethod(String string) {
        BCMethod[] bCMethodArray = this.getDeclaredMethods();
        for (int i = 0; i < bCMethodArray.length; ++i) {
            if (!bCMethodArray[i].getName().equals(string)) continue;
            return bCMethodArray[i];
        }
        return null;
    }

    public BCMethod[] getDeclaredMethods(String string) {
        LinkedList<BCMethod> linkedList = new LinkedList<BCMethod>();
        BCMethod[] bCMethodArray = this.getDeclaredMethods();
        for (int i = 0; i < bCMethodArray.length; ++i) {
            if (!bCMethodArray[i].getName().equals(string)) continue;
            linkedList.add(bCMethodArray[i]);
        }
        return linkedList.toArray(new BCMethod[linkedList.size()]);
    }

    public BCMethod getDeclaredMethod(String string, String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        BCMethod[] bCMethodArray = this.getDeclaredMethods();
        for (int i = 0; i < bCMethodArray.length; ++i) {
            if (!bCMethodArray[i].getName().equals(string) || !this.paramsMatch(bCMethodArray[i], stringArray)) continue;
            return bCMethodArray[i];
        }
        return null;
    }

    private boolean paramsMatch(BCMethod bCMethod, String[] stringArray) {
        String[] stringArray2 = bCMethod.getParamNames();
        if (stringArray2.length != stringArray.length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray2[i].equals(this._project.getNameCache().getExternalForm(stringArray[i], false))) continue;
            return false;
        }
        return true;
    }

    public BCMethod getDeclaredMethod(String string, Class[] classArray) {
        if (classArray == null) {
            return this.getDeclaredMethod(string, (String[])null);
        }
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        return this.getDeclaredMethod(string, stringArray);
    }

    public BCMethod getDeclaredMethod(String string, BCClass[] bCClassArray) {
        if (bCClassArray == null) {
            return this.getDeclaredMethod(string, (String[])null);
        }
        String[] stringArray = new String[bCClassArray.length];
        for (int i = 0; i < bCClassArray.length; ++i) {
            stringArray[i] = bCClassArray[i].getName();
        }
        return this.getDeclaredMethod(string, stringArray);
    }

    public BCMethod[] getDeclaredMethods(String string, String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        BCMethod[] bCMethodArray = this.getDeclaredMethods();
        ArrayList<BCMethod> arrayList = null;
        for (int i = 0; i < bCMethodArray.length; ++i) {
            if (!bCMethodArray[i].getName().equals(string) || !this.paramsMatch(bCMethodArray[i], stringArray)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<BCMethod>(3);
            }
            arrayList.add(bCMethodArray[i]);
        }
        if (arrayList == null) {
            return new BCMethod[0];
        }
        return arrayList.toArray(new BCMethod[arrayList.size()]);
    }

    public BCMethod[] getDeclaredMethods(String string, Class[] classArray) {
        if (classArray == null) {
            return this.getDeclaredMethods(string, (String[])null);
        }
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        return this.getDeclaredMethods(string, stringArray);
    }

    public BCMethod[] getDeclaredMethods(String string, BCClass[] bCClassArray) {
        if (bCClassArray == null) {
            return this.getDeclaredMethods(string, (String[])null);
        }
        String[] stringArray = new String[bCClassArray.length];
        for (int i = 0; i < bCClassArray.length; ++i) {
            stringArray[i] = bCClassArray[i].getName();
        }
        return this.getDeclaredMethods(string, stringArray);
    }

    public BCMethod getDeclaredMethod(String string, String string2, String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        BCMethod[] bCMethodArray = this.getDeclaredMethods();
        for (int i = 0; i < bCMethodArray.length; ++i) {
            if (!bCMethodArray[i].getName().equals(string) || !bCMethodArray[i].getReturnName().equals(this._project.getNameCache().getExternalForm(string2, false)) || !this.paramsMatch(bCMethodArray[i], stringArray)) continue;
            return bCMethodArray[i];
        }
        return null;
    }

    public BCMethod getDeclaredMethod(String string, Class clazz, Class[] classArray) {
        if (classArray == null) {
            return this.getDeclaredMethod(string, clazz.getName(), (String[])null);
        }
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        return this.getDeclaredMethod(string, clazz.getName(), stringArray);
    }

    public BCMethod getDeclaredMethod(String string, BCClass bCClass, BCClass[] bCClassArray) {
        if (bCClassArray == null) {
            return this.getDeclaredMethod(string, bCClass.getName(), (String[])null);
        }
        String[] stringArray = new String[bCClassArray.length];
        for (int i = 0; i < bCClassArray.length; ++i) {
            stringArray[i] = bCClassArray[i].getName();
        }
        return this.getDeclaredMethod(string, bCClass.getName(), stringArray);
    }

    public BCMethod[] getMethods() {
        LinkedList<BCMethod> linkedList = new LinkedList<BCMethod>();
        for (BCClass bCClass = this; bCClass != null; bCClass = bCClass.getSuperclassBC()) {
            BCMethod[] bCMethodArray = bCClass.getDeclaredMethods();
            for (int i = 0; i < bCMethodArray.length; ++i) {
                linkedList.add(bCMethodArray[i]);
            }
        }
        return linkedList.toArray(new BCMethod[linkedList.size()]);
    }

    public BCMethod[] getMethods(String string) {
        LinkedList<BCMethod> linkedList = new LinkedList<BCMethod>();
        BCMethod[] bCMethodArray = this.getMethods();
        for (int i = 0; i < bCMethodArray.length; ++i) {
            if (!bCMethodArray[i].getName().equals(string)) continue;
            linkedList.add(bCMethodArray[i]);
        }
        return linkedList.toArray(new BCMethod[linkedList.size()]);
    }

    public BCMethod[] getMethods(String string, String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        BCMethod[] bCMethodArray = this.getMethods();
        LinkedList<BCMethod> linkedList = new LinkedList<BCMethod>();
        for (int i = 0; i < bCMethodArray.length; ++i) {
            String[] stringArray2;
            if (!bCMethodArray[i].getName().equals(string) || (stringArray2 = bCMethodArray[i].getParamNames()).length != stringArray.length) continue;
            boolean bl = true;
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray2[j].equals(this._project.getNameCache().getExternalForm(stringArray[j], false))) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            linkedList.add(bCMethodArray[i]);
        }
        return linkedList.toArray(new BCMethod[linkedList.size()]);
    }

    public BCMethod[] getMethods(String string, Class[] classArray) {
        if (classArray == null) {
            return this.getMethods(string, (String[])null);
        }
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        return this.getMethods(string, stringArray);
    }

    public BCMethod[] getMethods(String string, BCClass[] bCClassArray) {
        if (bCClassArray == null) {
            return this.getMethods(string, (String[])null);
        }
        String[] stringArray = new String[bCClassArray.length];
        for (int i = 0; i < bCClassArray.length; ++i) {
            stringArray[i] = bCClassArray[i].getName();
        }
        return this.getMethods(string, stringArray);
    }

    public void setDeclaredMethods(BCMethod[] bCMethodArray) {
        this.clearDeclaredMethods();
        if (bCMethodArray != null) {
            for (int i = 0; i < bCMethodArray.length; ++i) {
                this.declareMethod(bCMethodArray[i]);
            }
        }
    }

    public BCMethod declareMethod(BCMethod bCMethod) {
        BCMethod bCMethod2 = this.declareMethod(bCMethod.getName(), bCMethod.getReturnName(), bCMethod.getParamNames());
        bCMethod2.setAccessFlags(bCMethod.getAccessFlags());
        bCMethod2.setAttributes(bCMethod.getAttributes());
        return bCMethod2;
    }

    public BCMethod declareMethod(String string, String string2, String[] stringArray) {
        BCMethod bCMethod = new BCMethod(this);
        this._state.getMethodsHolder().add(bCMethod);
        bCMethod.initialize(string, this._project.getNameCache().getDescriptor(string2, stringArray));
        return bCMethod;
    }

    public BCMethod declareMethod(String string, Class clazz, Class[] classArray) {
        String[] stringArray = null;
        if (classArray != null) {
            stringArray = new String[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                stringArray[i] = classArray[i].getName();
            }
        }
        String string2 = clazz == null ? null : clazz.getName();
        return this.declareMethod(string, string2, stringArray);
    }

    public BCMethod declareMethod(String string, BCClass bCClass, BCClass[] bCClassArray) {
        String[] stringArray = null;
        if (bCClassArray != null) {
            stringArray = new String[bCClassArray.length];
            for (int i = 0; i < bCClassArray.length; ++i) {
                stringArray[i] = bCClassArray[i].getName();
            }
        }
        String string2 = bCClass == null ? null : bCClass.getName();
        return this.declareMethod(string, string2, stringArray);
    }

    public void clearDeclaredMethods() {
        List list = this._state.getMethodsHolder();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            BCMethod bCMethod = (BCMethod)iterator.next();
            iterator.remove();
            bCMethod.invalidate();
        }
    }

    public boolean removeDeclaredMethod(String string) {
        List list = this._state.getMethodsHolder();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            BCMethod bCMethod = (BCMethod)iterator.next();
            if (!bCMethod.getName().equals(string)) continue;
            iterator.remove();
            bCMethod.invalidate();
            return true;
        }
        return false;
    }

    public boolean removeDeclaredMethod(BCMethod bCMethod) {
        if (bCMethod == null) {
            return false;
        }
        return this.removeDeclaredMethod(bCMethod.getName(), bCMethod.getParamNames());
    }

    public boolean removeDeclaredMethod(String string, String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        List list = this._state.getMethodsHolder();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String[] stringArray2;
            BCMethod bCMethod = (BCMethod)iterator.next();
            if (!bCMethod.getName().equals(string) || (stringArray2 = bCMethod.getParamNames()).length != stringArray.length) continue;
            boolean bl = true;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray2[i].equals(this._project.getNameCache().getExternalForm(stringArray[i], false))) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            iterator.remove();
            bCMethod.invalidate();
            return true;
        }
        return false;
    }

    public boolean removeDeclaredMethod(String string, Class[] classArray) {
        if (classArray == null) {
            return this.removeDeclaredMethod(string, (String[])null);
        }
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        return this.removeDeclaredMethod(string, stringArray);
    }

    public boolean removeDeclaredMethod(String string, BCClass[] bCClassArray) {
        if (bCClassArray == null) {
            return this.removeDeclaredMethod(string, (String[])null);
        }
        String[] stringArray = new String[bCClassArray.length];
        for (int i = 0; i < bCClassArray.length; ++i) {
            stringArray[i] = bCClassArray[i].getName();
        }
        return this.removeDeclaredMethod(string, stringArray);
    }

    public void moveDeclaredMethod(int n, int n2) {
        if (n == n2) {
            return;
        }
        List list = this._state.getMethodsHolder();
        Object e = list.remove(n);
        list.add(n2, e);
    }

    public BCMethod addDefaultConstructor() {
        BCMethod bCMethod = this.getDeclaredMethod("<init>", (String[])null);
        if (bCMethod != null) {
            return bCMethod;
        }
        bCMethod = this.declareMethod("<init>", Void.TYPE, null);
        Code code = bCMethod.getCode(true);
        code.setMaxStack(1);
        code.setMaxLocals(1);
        code.xload().setThis();
        code.invokespecial().setMethod(this.getSuperclassName(), "<init>", "void", null);
        code.vreturn();
        return bCMethod;
    }

    public SourceFile getSourceFile(boolean bl) {
        SourceFile sourceFile = (SourceFile)this.getAttribute("SourceFile");
        if (!bl || sourceFile != null) {
            return sourceFile;
        }
        return (SourceFile)this.addAttribute("SourceFile");
    }

    public boolean removeSourceFile() {
        return this.removeAttribute("SourceFile");
    }

    public InnerClasses getInnerClasses(boolean bl) {
        InnerClasses innerClasses = (InnerClasses)this.getAttribute("InnerClasses");
        if (!bl || innerClasses != null) {
            return innerClasses;
        }
        return (InnerClasses)this.addAttribute("InnerClasses");
    }

    public boolean removeInnerClasses() {
        return this.removeAttribute("InnerClasses");
    }

    public boolean isDeprecated() {
        return this.getAttribute("Deprecated") != null;
    }

    public void setDeprecated(boolean bl) {
        if (!bl) {
            this.removeAttribute("Deprecated");
        } else if (!this.isDeprecated()) {
            this.addAttribute("Deprecated");
        }
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterBCClass(this);
        ConstantPool constantPool = null;
        try {
            constantPool = this._state.getPool();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (constantPool != null) {
            constantPool.acceptVisit(bCVisitor);
        }
        BCField[] bCFieldArray = this.getDeclaredFields();
        for (int i = 0; i < bCFieldArray.length; ++i) {
            bCVisitor.enterBCMember(bCFieldArray[i]);
            bCFieldArray[i].acceptVisit(bCVisitor);
            bCVisitor.exitBCMember(bCFieldArray[i]);
        }
        BCMethod[] bCMethodArray = this.getDeclaredMethods();
        for (int i = 0; i < bCMethodArray.length; ++i) {
            bCVisitor.enterBCMember(bCMethodArray[i]);
            bCMethodArray[i].acceptVisit(bCVisitor);
            bCVisitor.exitBCMember(bCMethodArray[i]);
        }
        this.visitAttributes(bCVisitor);
        bCVisitor.exitBCClass(this);
    }

    public Project getProject() {
        return this._project;
    }

    public ConstantPool getPool() {
        return this._state.getPool();
    }

    public ClassLoader getClassLoader() {
        if (this._loader != null) {
            return this._loader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public boolean isValid() {
        return this._project != null;
    }

    Collection getAttributesHolder() {
        return this._state.getAttributesHolder();
    }

    BCClass getBCClass() {
        return this;
    }

    private void beforeRename(String string, String string2) {
        if (this._project != null && string != null) {
            this._project.renameClass(string, string2, this);
        }
    }
}

