/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import serp.bytecode.Annotation;
import serp.bytecode.Attribute;
import serp.bytecode.Attributes;
import serp.bytecode.BCClass;
import serp.bytecode.visitor.BCVisitor;

public class Annotations
extends Attribute {
    private final List _annotations = new ArrayList();

    Annotations(int n, Attributes attributes) {
        super(n, attributes);
    }

    public boolean isRuntime() {
        return this.getName().equals("RuntimeVisibleAnnotations");
    }

    public Annotation[] getAnnotations() {
        return this._annotations.toArray(new Annotation[this._annotations.size()]);
    }

    public void setAnnotations(Annotation[] annotationArray) {
        this.clear();
        if (annotationArray != null) {
            for (int i = 0; i < annotationArray.length; ++i) {
                this.addAnnotation(annotationArray[i]);
            }
        }
    }

    public Annotation getAnnotation(Class clazz) {
        return clazz == null ? null : this.getAnnotation(clazz.getName());
    }

    public Annotation getAnnotation(BCClass bCClass) {
        return bCClass == null ? null : this.getAnnotation(bCClass.getName());
    }

    public Annotation getAnnotation(String string) {
        for (int i = 0; i < this._annotations.size(); ++i) {
            Annotation annotation = (Annotation)this._annotations.get(i);
            if (!annotation.getTypeName().equals(string)) continue;
            return annotation;
        }
        return null;
    }

    public Annotation addAnnotation(Annotation annotation) {
        Annotation annotation2 = this.addAnnotation(annotation.getTypeName());
        annotation2.setProperties(annotation.getProperties());
        return annotation2;
    }

    public Annotation addAnnotation(Class clazz) {
        return this.addAnnotation(clazz.getName());
    }

    public Annotation addAnnotation(BCClass bCClass) {
        return this.addAnnotation(bCClass.getName());
    }

    public Annotation addAnnotation(String string) {
        Annotation annotation = new Annotation(this);
        annotation.setType(string);
        this._annotations.add(annotation);
        return annotation;
    }

    public void clear() {
        for (int i = 0; i < this._annotations.size(); ++i) {
            ((Annotation)this._annotations.get(i)).invalidate();
        }
        this._annotations.clear();
    }

    public boolean removeAnnotation(Annotation annotation) {
        return annotation != null && this.removeAnnotation(annotation.getTypeName());
    }

    public boolean removeAnnotation(Class clazz) {
        return clazz != null && this.removeAnnotation(clazz.getName());
    }

    public boolean removeAnnotation(BCClass bCClass) {
        return bCClass != null && this.removeAnnotation(bCClass.getName());
    }

    public boolean removeAnnotation(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < this._annotations.size(); ++i) {
            Annotation annotation = (Annotation)this._annotations.get(i);
            if (!annotation.getTypeName().equals(string)) continue;
            annotation.invalidate();
            this._annotations.remove(i);
            return true;
        }
        return false;
    }

    int getLength() {
        int n = 2;
        for (int i = 0; i < this._annotations.size(); ++i) {
            n += ((Annotation)this._annotations.get(i)).getLength();
        }
        return n;
    }

    void read(Attribute attribute) {
        this.setAnnotations(((Annotations)attribute).getAnnotations());
    }

    void read(DataInput dataInput, int n) throws IOException {
        this._annotations.clear();
        int n2 = dataInput.readUnsignedShort();
        for (int i = 0; i < n2; ++i) {
            Annotation annotation = new Annotation(this);
            annotation.read(dataInput);
            this._annotations.add(annotation);
        }
    }

    void write(DataOutput dataOutput, int n) throws IOException {
        dataOutput.writeShort(this._annotations.size());
        for (int i = 0; i < this._annotations.size(); ++i) {
            ((Annotation)this._annotations.get(i)).write(dataOutput);
        }
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterAnnotations(this);
        for (int i = 0; i < this._annotations.size(); ++i) {
            ((Annotation)this._annotations.get(i)).acceptVisit(bCVisitor);
        }
        bCVisitor.exitAnnotations(this);
    }
}

