/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import serp.bytecode.BCClass;
import serp.bytecode.BCEntity;
import serp.bytecode.Project;
import serp.bytecode.lowlevel.ConstantEntry;
import serp.bytecode.lowlevel.ConstantPool;
import serp.bytecode.lowlevel.DoubleEntry;
import serp.bytecode.lowlevel.Entry;
import serp.bytecode.lowlevel.FloatEntry;
import serp.bytecode.lowlevel.IntEntry;
import serp.bytecode.lowlevel.LongEntry;
import serp.bytecode.lowlevel.UTF8Entry;
import serp.bytecode.visitor.BCVisitor;
import serp.bytecode.visitor.VisitAcceptor;
import serp.util.Strings;

public class Annotation
implements BCEntity,
VisitAcceptor {
    private static Method ENUM_VALUEOF = null;
    private static Method ENUM_NAME = null;
    private BCEntity _owner = null;
    private int _typeIndex = 0;
    private List _properties = null;
    static /* synthetic */ Class class$java$lang$Object;

    Annotation(BCEntity bCEntity) {
        this._owner = bCEntity;
    }

    public BCEntity getOwner() {
        return this._owner;
    }

    void invalidate() {
        this._owner = null;
    }

    public int getTypeIndex() {
        return this._typeIndex;
    }

    public void setTypeIndex(int n) {
        this._typeIndex = n;
    }

    public String getTypeName() {
        String string = ((UTF8Entry)this.getPool().getEntry(this._typeIndex)).getValue();
        return this.getProject().getNameCache().getExternalForm(string, false);
    }

    public Class getType() {
        return Strings.toClass(this.getTypeName(), this.getClassLoader());
    }

    public BCClass getTypeBC() {
        return this.getProject().loadClass(this.getTypeName(), this.getClassLoader());
    }

    public void setType(String string) {
        string = this.getProject().getNameCache().getInternalForm(string, true);
        this._typeIndex = this.getPool().findUTF8Entry(string, true);
    }

    public void setType(Class clazz) {
        this.setType(clazz.getName());
    }

    public void setType(BCClass bCClass) {
        this.setType(bCClass.getName());
    }

    public Property[] getProperties() {
        if (this._properties == null) {
            return new Property[0];
        }
        return this._properties.toArray(new Property[this._properties.size()]);
    }

    public void setProperties(Property[] propertyArray) {
        this.clearProperties();
        if (propertyArray != null) {
            for (int i = 0; i < propertyArray.length; ++i) {
                this.addProperty(propertyArray[i]);
            }
        }
    }

    public Property getProperty(String string) {
        if (this._properties == null) {
            return null;
        }
        for (int i = 0; i < this._properties.size(); ++i) {
            Property property = (Property)this._properties.get(i);
            if (!property.getName().equals(string)) continue;
            return property;
        }
        return null;
    }

    public Property addProperty(Property property) {
        Property property2 = this.addProperty(property.getName());
        property2.setValue(property.getValue());
        return property2;
    }

    public Property addProperty(String string) {
        Property property = new Property(this);
        property.setName(string);
        if (this._properties == null) {
            this._properties = new ArrayList();
        }
        this._properties.add(property);
        return property;
    }

    public void clearProperties() {
        if (this._properties == null) {
            return;
        }
        for (int i = 0; i < this._properties.size(); ++i) {
            ((Property)this._properties.get(i)).invalidate();
        }
        this._properties.clear();
    }

    public boolean removeProperty(Property property) {
        return property != null && this.removeProperty(property.getName());
    }

    public boolean removeProperty(String string) {
        if (string == null || this._properties == null) {
            return false;
        }
        for (int i = 0; i < this._properties.size(); ++i) {
            Property property = (Property)this._properties.get(i);
            if (!property.getName().equals(string)) continue;
            property.invalidate();
            this._properties.remove(i);
            return true;
        }
        return false;
    }

    public Project getProject() {
        return this._owner.getProject();
    }

    public ConstantPool getPool() {
        return this._owner.getPool();
    }

    public ClassLoader getClassLoader() {
        return this._owner.getClassLoader();
    }

    public boolean isValid() {
        return this._owner != null;
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterAnnotation(this);
        if (this._properties != null) {
            for (int i = 0; i < this._properties.size(); ++i) {
                ((Property)this._properties.get(i)).acceptVisit(bCVisitor);
            }
        }
        bCVisitor.exitAnnotation(this);
    }

    int getLength() {
        int n = 4;
        if (this._properties != null) {
            for (int i = 0; i < this._properties.size(); ++i) {
                n += ((Property)this._properties.get(i)).getLength();
            }
        }
        return n;
    }

    void read(DataInput dataInput) throws IOException {
        this._typeIndex = dataInput.readUnsignedShort();
        this.clearProperties();
        int n = dataInput.readUnsignedShort();
        if (n > 0) {
            if (this._properties == null) {
                this._properties = new ArrayList(n);
            }
            for (int i = 0; i < n; ++i) {
                Property property = new Property(this);
                property.read(dataInput);
                this._properties.add(property);
            }
        }
    }

    void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this._typeIndex);
        dataOutput.writeShort(this._properties == null ? 0 : this._properties.size());
        if (this._properties != null) {
            for (int i = 0; i < this._properties.size(); ++i) {
                ((Property)this._properties.get(i)).write(dataOutput);
            }
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("java.lang.Enum");
            ENUM_VALUEOF = clazz.getMethod("valueOf", Class.class, String.class);
            ENUM_NAME = clazz.getMethod("name", null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class Property
    implements BCEntity,
    VisitAcceptor {
        private Annotation _owner = null;
        private int _nameIndex = 0;
        private final Value _value = new Value();
        private Value[] _values = null;

        Property(Annotation annotation) {
            this._owner = annotation;
        }

        public Annotation getAnnotation() {
            return this._owner;
        }

        void invalidate() {
            this._owner = null;
        }

        public int getNameIndex() {
            return this._nameIndex;
        }

        public void setNameIndex(int n) {
            this._nameIndex = n;
        }

        public String getName() {
            return ((UTF8Entry)this.getPool().getEntry(this._nameIndex)).getValue();
        }

        public void setName(String string) {
            this._nameIndex = this.getPool().findUTF8Entry(string, true);
        }

        public Object getValue() {
            if (this._values == null) {
                return this.getValue(this._value);
            }
            Object[] objectArray = new Object[this._values.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.getValue(this._values[i]);
            }
            return objectArray;
        }

        private Object getValue(Value value) {
            if (value.index == -1) {
                return value.value;
            }
            Object object = ((ConstantEntry)((Object)this.getPool().getEntry(value.index))).getConstant();
            if (value.index2 != -1) {
                String string = this.getProject().getNameCache().getExternalForm((String)object, false);
                String string2 = ((UTF8Entry)this.getPool().getEntry(value.index2)).getValue();
                try {
                    Class<?> clazz = Class.forName(string, true, this.getClassLoader());
                    return ENUM_VALUEOF.invoke(null, clazz, string2);
                }
                catch (Throwable throwable) {
                    return string + "." + string2;
                }
            }
            if (value.type == null) {
                return object;
            }
            switch (value.type.getName().charAt(0)) {
                case 'b': {
                    if (value.type == Boolean.TYPE) {
                        return ((Number)object).intValue() != 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    return new Byte(((Number)object).byteValue());
                }
                case 'c': {
                    return new Character((char)((Number)object).intValue());
                }
                case 'j': {
                    return this.getProject().getNameCache().getExternalForm((String)object, false);
                }
                case 's': {
                    return new Short(((Number)object).shortValue());
                }
            }
            return object;
        }

        public void setValue(Object object) {
            if (!object.getClass().isArray()) {
                this._values = null;
                this.setValue(this._value, object);
            } else {
                this._value.value = null;
                this._values = new Value[Array.getLength(object)];
                for (int i = 0; i < this._values.length; ++i) {
                    this._values[i] = new Value();
                    this.setValue(this._values[i], Array.get(object, i));
                }
            }
        }

        private void setValue(Value value, Object object) {
            if (object instanceof String) {
                this.setValue(value, (String)object);
            } else if (object instanceof Boolean) {
                this.setValue(value, (Boolean)object);
            } else if (object instanceof Byte) {
                this.setValue(value, (Byte)object);
            } else if (object instanceof Character) {
                this.setValue(value, ((Character)object).charValue());
            } else if (object instanceof Double) {
                this.setValue(value, (Double)object);
            } else if (object instanceof Float) {
                this.setValue(value, ((Float)object).floatValue());
            } else if (object instanceof Integer) {
                this.setValue(value, (Integer)object);
            } else if (object instanceof Long) {
                this.setValue(value, (Long)object);
            } else if (object instanceof Short) {
                this.setValue(value, (Short)object);
            } else if (object instanceof Class) {
                this.setClassNameValue(value, ((Class)object).getName());
            } else if (object instanceof BCClass) {
                this.setClassNameValue(value, ((BCClass)object).getName());
            } else if (object instanceof Annotation) {
                this.setValue(value, (Annotation)object);
            } else {
                String string = Property.getEnumName(object);
                if (string != null) {
                    String string2 = this.getProject().getNameCache().getInternalForm(object.getClass().getName(), true);
                    value.index = this.getPool().findUTF8Entry(string2, true);
                    value.index2 = this.getPool().findUTF8Entry(string, true);
                    value.value = null;
                    value.type = null;
                } else {
                    value.index = -1;
                    value.index2 = -1;
                    value.value = object;
                    value.type = object.getClass();
                }
            }
        }

        private static String getEnumName(Object object) {
            Class<?> clazz = object.getClass();
            while (true) {
                if (clazz == (class$java$lang$Object == null ? Annotation.class$("java.lang.Object") : class$java$lang$Object) || clazz == null) {
                    return null;
                }
                if ("java.lang.Enum".equals(clazz.getName())) break;
                clazz = clazz.getSuperclass();
            }
            try {
                return (String)ENUM_NAME.invoke(object, (Object[])null);
            }
            catch (Throwable throwable) {
                return object.toString();
            }
        }

        public String getStringValue() {
            return (String)this.getValue();
        }

        public boolean getBooleanValue() {
            Object object = this.getValue();
            return object == null ? false : (Boolean)object;
        }

        public byte getByteValue() {
            Object object = this.getValue();
            return object == null ? (byte)0 : ((Number)object).byteValue();
        }

        public int getIntValue() {
            Object object = this.getValue();
            return object == null ? 0 : ((Number)object).intValue();
        }

        public long getLongValue() {
            Object object = this.getValue();
            return object == null ? 0L : ((Number)object).longValue();
        }

        public float getFloatValue() {
            Object object = this.getValue();
            return object == null ? 0.0f : ((Number)object).floatValue();
        }

        public double getDoubleValue() {
            Object object = this.getValue();
            return object == null ? 0.0 : ((Number)object).doubleValue();
        }

        public short getShortValue() {
            Object object = this.getValue();
            return object == null ? (short)0 : ((Number)object).shortValue();
        }

        public String getClassNameValue() {
            return (String)this.getValue();
        }

        public Annotation getAnnotationValue() {
            return (Annotation)this.getValue();
        }

        public void setValue(String string) {
            this._values = null;
            this.setValue(this._value, string);
        }

        private void setValue(Value value, String string) {
            value.index = this.getPool().findUTF8Entry(string, true);
            value.index2 = -1;
            value.value = null;
            value.type = null;
        }

        public void setValue(boolean bl) {
            this._values = null;
            this.setValue(this._value, bl);
        }

        private void setValue(Value value, boolean bl) {
            this.setValue(value, bl ? 1 : 0);
            value.type = Boolean.TYPE;
        }

        public void setValue(byte by) {
            this._values = null;
            this.setValue(this._value, by);
        }

        private void setValue(Value value, byte by) {
            this.setValue(value, (int)by);
            value.type = Byte.TYPE;
        }

        public void setValue(int n) {
            this._values = null;
            this.setValue(this._value, n);
        }

        private void setValue(Value value, int n) {
            value.index = this.getPool().findIntEntry(n, true);
            value.index2 = -1;
            value.value = null;
            value.type = null;
        }

        public void setValue(long l) {
            this._values = null;
            this.setValue(this._value, l);
        }

        private void setValue(Value value, long l) {
            value.index = this.getPool().findLongEntry(l, true);
            value.index2 = -1;
            value.value = null;
            value.type = null;
        }

        public void setValue(float f) {
            this._values = null;
            this.setValue(this._value, f);
        }

        private void setValue(Value value, float f) {
            value.index = this.getPool().findFloatEntry(f, true);
            value.index2 = -1;
            value.value = null;
            value.type = null;
        }

        public void setValue(double d) {
            this._values = null;
            this.setValue(this._value, d);
        }

        private void setValue(Value value, double d) {
            value.index = this.getPool().findDoubleEntry(d, true);
            value.index2 = -1;
            value.value = null;
            value.type = null;
        }

        public void setValue(short s) {
            this._values = null;
            this.setValue(this._value, s);
        }

        private void setValue(Value value, short s) {
            this.setValue(value, (int)s);
            value.type = Short.TYPE;
        }

        public void setValue(Class clazz) {
            this.setClassNameValue(clazz.getName());
        }

        public void setValue(BCClass bCClass) {
            this.setClassNameValue(bCClass.getName());
        }

        public void setClassNameValue(String string) {
            this._values = null;
            this.setClassNameValue(this._value, string);
        }

        private void setClassNameValue(Value value, String string) {
            string = this.getProject().getNameCache().getInternalForm(string, true);
            value.index = this.getPool().findUTF8Entry(string, true);
            value.index2 = -1;
            value.value = null;
            value.type = class$java$lang$Class == null ? (class$java$lang$Class = Annotation.class$("java.lang.Class")) : class$java$lang$Class;
        }

        public Annotation setValue(Annotation annotation) {
            this._values = null;
            return this.setValue(this._value, annotation);
        }

        private Annotation setValue(Value value, Annotation annotation) {
            Annotation annotation2 = new Annotation(this);
            annotation2.setType(annotation.getTypeName());
            annotation2.setProperties(annotation.getProperties());
            value.index = -1;
            value.index2 = -1;
            value.value = annotation2;
            value.type = null;
            return annotation2;
        }

        public Annotation[] setValue(Annotation[] annotationArray) {
            this._value.value = null;
            this._values = new Value[annotationArray.length];
            Annotation[] annotationArray2 = new Annotation[annotationArray.length];
            for (int i = 0; i < this._values.length; ++i) {
                this._values[i] = new Value();
                annotationArray2[i] = this.setValue(this._values[i], annotationArray[i]);
            }
            return annotationArray2;
        }

        public Annotation newAnnotationValue(Class clazz) {
            return this.newAnnotationValue(clazz.getName());
        }

        public Annotation newAnnotationValue(BCClass bCClass) {
            return this.newAnnotationValue(bCClass.getName());
        }

        public Annotation newAnnotationValue(String string) {
            Annotation annotation = new Annotation(this);
            annotation.setType(string);
            this._values = null;
            this._value.index = -1;
            this._value.index2 = -1;
            this._value.value = annotation;
            this._value.type = null;
            return annotation;
        }

        public Annotation[] newAnnotationArrayValue(Class clazz, int n) {
            return this.newAnnotationArrayValue(clazz.getName(), n);
        }

        public Annotation[] newAnnotationArrayValue(BCClass bCClass, int n) {
            return this.newAnnotationArrayValue(bCClass.getName(), n);
        }

        public Annotation[] newAnnotationArrayValue(String string, int n) {
            this._value.value = null;
            this._values = new Value[n];
            Annotation[] annotationArray = new Annotation[n];
            for (int i = 0; i < n; ++i) {
                annotationArray[i] = new Annotation(this);
                annotationArray[i].setType(string);
                this._values[i] = new Value();
                this._values[i].index = -1;
                this._values[i].index2 = -1;
                this._values[i].value = annotationArray[i];
                this._values[i].type = null;
            }
            return annotationArray;
        }

        public Project getProject() {
            return this._owner.getProject();
        }

        public ConstantPool getPool() {
            return this._owner.getPool();
        }

        public ClassLoader getClassLoader() {
            return this._owner.getClassLoader();
        }

        public boolean isValid() {
            return this._owner != null && (this._values != null || this._value.index != -1 || this._value.value != null);
        }

        public void acceptVisit(BCVisitor bCVisitor) {
            bCVisitor.enterAnnotationProperty(this);
            bCVisitor.exitAnnotationProperty(this);
        }

        int getLength() {
            if (!this.isValid()) {
                throw new IllegalStateException();
            }
            int n = 2;
            if (this._values == null) {
                n += this.getLength(this._value);
            } else {
                n += 3;
                for (int i = 0; i < this._values.length; ++i) {
                    n += this.getLength(this._values[i]);
                }
            }
            return n;
        }

        private int getLength(Value value) {
            if (value.index2 != -1) {
                return 5;
            }
            if (value.index != -1) {
                return 3;
            }
            return 1 + ((Annotation)value.value).getLength();
        }

        void read(DataInput dataInput) throws IOException {
            this._nameIndex = dataInput.readUnsignedShort();
            byte by = dataInput.readByte();
            if (by == 91) {
                int n = dataInput.readUnsignedShort();
                this._values = new Value[n];
                for (int i = 0; i < n; ++i) {
                    this._values[i] = new Value();
                    this.read(this._values[i], dataInput.readByte(), dataInput);
                }
            } else {
                this.read(this._value, by, dataInput);
            }
        }

        private void read(Value value, int n, DataInput dataInput) throws IOException {
            switch (n) {
                case 66: {
                    value.index = dataInput.readUnsignedShort();
                    value.index2 = -1;
                    value.value = null;
                    value.type = Byte.TYPE;
                    break;
                }
                case 67: {
                    value.index = dataInput.readUnsignedShort();
                    value.index2 = -1;
                    value.value = null;
                    value.type = Character.TYPE;
                    break;
                }
                case 68: 
                case 70: 
                case 73: 
                case 74: 
                case 83: 
                case 115: {
                    value.index = dataInput.readUnsignedShort();
                    value.index2 = -1;
                    value.value = null;
                    value.type = null;
                    break;
                }
                case 90: {
                    value.index = dataInput.readUnsignedShort();
                    value.index2 = -1;
                    value.value = null;
                    value.type = Boolean.TYPE;
                    break;
                }
                case 99: {
                    value.index = dataInput.readUnsignedShort();
                    value.index2 = -1;
                    value.value = null;
                    value.type = class$java$lang$Class == null ? (class$java$lang$Class = Annotation.class$("java.lang.Class")) : class$java$lang$Class;
                    break;
                }
                case 101: {
                    value.index = dataInput.readUnsignedShort();
                    value.index2 = dataInput.readUnsignedShort();
                    value.value = null;
                    value.type = null;
                    break;
                }
                case 64: {
                    Annotation annotation = new Annotation(this);
                    annotation.read(dataInput);
                    value.index = -1;
                    value.index2 = -1;
                    value.value = annotation;
                    value.type = null;
                    break;
                }
                default: {
                    throw new IllegalStateException(String.valueOf(n));
                }
            }
        }

        void write(DataOutput dataOutput) throws IOException {
            if (!this.isValid()) {
                throw new IllegalStateException();
            }
            dataOutput.writeShort(this._nameIndex);
            if (this._values == null) {
                this.write(this._value, dataOutput);
            } else {
                dataOutput.writeByte(91);
                dataOutput.writeShort(this._values.length);
                for (int i = 0; i < this._values.length; ++i) {
                    this.write(this._values[i], dataOutput);
                }
            }
        }

        private void write(Value value, DataOutput dataOutput) throws IOException {
            block19: {
                block20: {
                    block22: {
                        block21: {
                            block18: {
                                if (value.index2 == -1) break block18;
                                dataOutput.writeByte(101);
                                dataOutput.writeShort(value.index);
                                dataOutput.writeShort(value.index2);
                                break block19;
                            }
                            if (value.index == -1) break block20;
                            if (value.type == null) break block21;
                            switch (value.type.getName().charAt(0)) {
                                case 'b': {
                                    if (value.type == Byte.TYPE) {
                                        dataOutput.writeByte(66);
                                    } else {
                                        dataOutput.writeByte(90);
                                    }
                                    break block22;
                                }
                                case 'c': {
                                    dataOutput.writeByte(67);
                                    break block22;
                                }
                                case 'j': {
                                    dataOutput.writeByte(99);
                                    break block22;
                                }
                                case 's': {
                                    dataOutput.writeByte(83);
                                    break block22;
                                }
                                default: {
                                    throw new IllegalStateException(value.type.getName());
                                }
                            }
                        }
                        Entry entry = this.getPool().getEntry(value.index);
                        if (entry instanceof DoubleEntry) {
                            dataOutput.writeByte(68);
                        } else if (entry instanceof FloatEntry) {
                            dataOutput.writeByte(70);
                        } else if (entry instanceof IntEntry) {
                            dataOutput.writeByte(73);
                        } else if (entry instanceof LongEntry) {
                            dataOutput.writeByte(74);
                        } else if (entry instanceof UTF8Entry) {
                            dataOutput.writeByte(115);
                        } else {
                            throw new IllegalStateException(entry.getClass().getName());
                        }
                    }
                    dataOutput.writeShort(value.index);
                    break block19;
                }
                dataOutput.writeByte(64);
                ((Annotation)value.value).write(dataOutput);
            }
        }

        private static class Value {
            public int index = -1;
            public int index2 = -1;
            public Class type = null;
            public Object value = null;

            private Value() {
            }
        }
    }
}

