/*
 * Decompiled with CFR 0.152.
 */
package com.mobileread.ixtab.jbpatch.resources;

import com.mobileread.ixtab.jbpatch.Log;
import com.mobileread.ixtab.jbpatch.resources.KeyValueResource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class KeyValueFile
implements KeyValueResource {
    public static int FLAG_NONE = 0;
    public static int FLAG_DYNAMIC = 1;
    public static int FLAG_WRITABLE = 2;
    private String[] keys;
    private String[] values;
    private final File primaryFile;
    private final int flags;
    private long lastTimestamp = 0L;

    public KeyValueFile(int n, File file) {
        this.primaryFile = file;
        this.flags = n;
        this.reload();
    }

    public String getValue(String string) {
        int n;
        if (this.isDynamic() && this.primaryFile.lastModified() != this.lastTimestamp) {
            this.reload();
        }
        return (n = Arrays.binarySearch(this.keys, string)) < 0 ? null : this.values[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reload() {
        BufferedReader bufferedReader = null;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        boolean bl = false;
        try {
            if (this.primaryFile.exists()) {
                this.lastTimestamp = this.primaryFile.lastModified();
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.primaryFile), "UTF-8"));
                this.initialize(arrayList, arrayList2, bufferedReader, this.primaryFile.getAbsolutePath());
                bl = true;
            }
        }
        catch (IOException iOException) {
            arrayList.clear();
            arrayList2.clear();
            iOException.printStackTrace(Log.INSTANCE);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.keys = new String[arrayList.size()];
        arrayList.toArray(this.keys);
        this.values = new String[arrayList2.size()];
        arrayList2.toArray(this.values);
        return bl;
    }

    private void initialize(List list, List list2, BufferedReader bufferedReader, String string) throws IOException {
        int n = 0;
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            ++n;
            if ((string2 = string2.trim()).length() != 0 && !string2.startsWith("#")) {
                int n2 = string2.indexOf(61);
                if (n2 == -1) {
                    Log.INSTANCE.println("W: Invalid line #" + n + " in file " + string + ": missing =");
                } else {
                    String string3 = string2.substring(0, n2);
                    String string4 = this.unescape(string2.substring(n2 + 1));
                    int n3 = Collections.binarySearch(list, string3);
                    if (n3 < 0) {
                        n3 = -(n3 + 1);
                    }
                    list.add(n3, string3);
                    list2.add(n3, string4);
                }
            }
            string2 = bufferedReader.readLine();
        }
    }

    public boolean setValue(String string, String string2) {
        return this.setValue(string, string2, true);
    }

    public boolean setValue(String string, String string2, boolean bl) {
        if (!this.isWritable()) {
            throw new IllegalStateException(this.primaryFile + " was opened in readonly mode");
        }
        if (string2 == null) {
            return false;
        }
        boolean bl2 = false;
        int n = Arrays.binarySearch(this.keys, string);
        if (n < 0) {
            bl2 = true;
            n = -(n + 1);
            String[] stringArray = new String[this.keys.length + 1];
            String[] stringArray2 = new String[stringArray.length];
            stringArray[n] = string;
            stringArray2[n] = string2;
            System.arraycopy(this.keys, 0, stringArray, 0, n);
            System.arraycopy(this.values, 0, stringArray2, 0, n);
            System.arraycopy(this.keys, n, stringArray, n + 1, this.keys.length - n);
            System.arraycopy(this.values, n, stringArray2, n + 1, this.values.length - n);
            this.keys = stringArray;
            this.values = stringArray2;
        } else if (!this.values[n].equals(string2)) {
            bl2 = true;
            this.values[n] = string2;
        }
        if (!bl2) {
            return true;
        }
        if (bl) {
            return this.commitChanges();
        }
        return true;
    }

    public boolean remove(String string) {
        return this.remove(string, true);
    }

    public boolean remove(String string, boolean bl) {
        if (!this.isWritable()) {
            throw new IllegalStateException(this.primaryFile + " was opened in readonly mode");
        }
        int n = Arrays.binarySearch(this.keys, string);
        if (n < 0) {
            return true;
        }
        String[] stringArray = new String[this.keys.length - 1];
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(this.keys, 0, stringArray, 0, n);
        System.arraycopy(this.values, 0, stringArray2, 0, n);
        System.arraycopy(this.keys, n + 1, stringArray, n, stringArray.length - n);
        System.arraycopy(this.values, n + 1, stringArray2, n, stringArray2.length - n);
        this.keys = stringArray;
        this.values = stringArray2;
        if (bl) {
            return this.commitChanges();
        }
        return true;
    }

    public boolean commitChanges() {
        return this.write(this.primaryFile);
    }

    private boolean write(File file) {
        if (file == null) {
            return true;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintStream printStream = new PrintStream((OutputStream)fileOutputStream, false, "UTF-8");
            printStream.print("# DO NOT DELETE THIS FILE.\r\n\r\n");
            printStream.print("# This file was automatically generated or updated.\r\n");
            printStream.print("# While is recommended to use the jbpatch UI to modify the values contained hereafter, \r\n");
            printStream.print("# you can also manually change them. Just be aware that you may need to restart\r\n");
            printStream.print("# your Kindle before you see an effect.\r\n\r\n");
            for (int i = 0; i < this.keys.length; ++i) {
                printStream.print(this.keys[i]);
                printStream.print("=");
                printStream.print(KeyValueFile.escape(this.values[i]));
                printStream.print("\r\n");
            }
            printStream.flush();
            printStream.close();
            this.lastTimestamp = file.lastModified();
        }
        catch (IOException iOException) {
            Log.INSTANCE.println("Error while writing to " + file + ":");
            iOException.printStackTrace(Log.INSTANCE);
            return false;
        }
        return true;
    }

    static String escape(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n = stringTokenizer.countTokens();
        if (n == 1) {
            return string;
        }
        int n2 = 1;
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
            if (n2++ >= n) continue;
            stringBuffer.append("\\n");
        }
        return stringBuffer.toString();
    }

    private String unescape(String string) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.indexOf("\\n", n);
        while (n2 >= 0) {
            String string2 = string.substring(n, n2);
            stringBuffer.append(string2);
            stringBuffer.append("\n");
            n = n2 + 2;
            n2 = string.indexOf("\\n", n);
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    private boolean isWritable() {
        return (this.flags & FLAG_WRITABLE) == FLAG_WRITABLE;
    }

    private boolean isDynamic() {
        return (this.flags & FLAG_DYNAMIC) == FLAG_DYNAMIC;
    }

    public List listKeys() {
        return Arrays.asList(this.keys);
    }
}

