/*
 * Decompiled with CFR 0.152.
 */
package com.mobileread.ixtab.jbpatch.resources;

import com.mobileread.ixtab.jbpatch.Log;
import com.mobileread.ixtab.jbpatch.conf.ConfigurableSettings;
import com.mobileread.ixtab.jbpatch.resources.KeyValueFile;
import com.mobileread.ixtab.jbpatch.resources.KeyValueResource;
import com.mobileread.ixtab.jbpatch.resources.LocalizationResource;
import com.mobileread.ixtab.jbpatch.resources.ResourceMapProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;

public class JBPatchResource {
    private static final String FILE_EXTENSION = ".txt";
    private static final String FILE_DELIMITER = "-";
    public static final int TYPE_LOCALIZATION = 0;
    public static final int TYPE_CONFIGURATION = 1;

    private JBPatchResource() {
    }

    public static KeyValueResource getResource(ResourceMapProvider resourceMapProvider, int n) {
        switch (n) {
            case 0: {
                return new LocalizationResource(resourceMapProvider);
            }
            case 1: {
                File file = JBPatchResource.loadOrCreateFile(resourceMapProvider.id(), null, resourceMapProvider);
                ConfigurableSettings configurableSettings = resourceMapProvider.getConfigurableSettings();
                if (configurableSettings != null && file != null) {
                    configurableSettings.setBackend(new KeyValueFile(KeyValueFile.FLAG_WRITABLE, file));
                }
                return configurableSettings;
            }
        }
        throw new IllegalArgumentException("Unsupported resource type " + n);
    }

    static File loadOrCreateFile(String string, String string2, ResourceMapProvider resourceMapProvider) {
        File file;
        String string3 = "/var/local/jbpatch/" + string;
        if (string2 != null) {
            string3 = string3 + FILE_DELIMITER + string2;
        }
        string3 = string3 + FILE_EXTENSION;
        Map map = null;
        if (string2 == null) {
            map = resourceMapProvider.getDefaultResourceMap(string2);
        }
        if ((file = new File(string3)).exists()) {
            if (file.isFile() && file.canRead()) {
                return file;
            }
            Log.INSTANCE.println("E: " + file + " is not a file, or unreadable: refusing to tamper with it");
            return null;
        }
        if (map == null) {
            map = resourceMapProvider.getDefaultResourceMap(string2);
        }
        if (map != null && JBPatchResource.initializeFileFromMap(file, map)) {
            return file;
        }
        return null;
    }

    private static boolean initializeFileFromMap(File file, Map map) {
        boolean bl = false;
        try {
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            printWriter.print("# This file is a configuration file, and may contain important settings.\r\n");
            printWriter.print("# Change this file at your own risk, and only if you know what you are doing.\r\n\r\n");
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                printWriter.print((String)entry.getKey());
                printWriter.print("=");
                printWriter.print(KeyValueFile.escape(entry.getValue().toString()));
                printWriter.print("\r\n");
            }
            printWriter.flush();
            printWriter.close();
            bl = true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace(Log.INSTANCE);
        }
        if (bl && file.exists() && file.isFile() && file.canRead()) {
            Log.INSTANCE.println("I: File " + file + " successfully initialized");
            return true;
        }
        Log.INSTANCE.println("E: Failed to initialize file " + file);
        file.delete();
        return false;
    }
}

