/*
 * Decompiled with CFR 0.152.
 */
package com.mobileread.ixtab.jbpatch.composition;

import com.mobileread.ixtab.jbpatch.Log;
import com.mobileread.ixtab.jbpatch.Patch;
import com.mobileread.ixtab.jbpatch.PatchMetadata;
import com.mobileread.ixtab.jbpatch.composition.State;
import com.mobileread.ixtab.jbpatch.composition.Transition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PathFinder {
    private final List states = new ArrayList();
    private final List transitions = new ArrayList();
    private final State start;
    private final LinkedList stateQueue = new LinkedList();

    public PathFinder(String string) {
        this.start = new State(string, new LinkedList());
        this.states.add(this.start);
        this.stateQueue.add(this.start);
    }

    public Patch[] findPath(Patch[] patchArray, String string) {
        Patch[] patchArray2;
        for (int i = 0; i < patchArray.length; ++i) {
            patchArray2 = patchArray[i];
            PatchMetadata.PatchableClass patchableClass = this.findPatchableClass(string, patchArray2.getMetadata().supportedClasses);
            this.createTransitions((Patch)patchArray2, patchableClass.checksums);
        }
        while (!this.stateQueue.isEmpty()) {
            State state = (State)this.stateQueue.removeFirst();
            this.addTransitionsFrom(state);
        }
        Collections.sort(this.states);
        State state = (State)this.states.get(0);
        if (state.appliedTransitions.size() < patchArray.length) {
            Log.INSTANCE.println("W: There are " + patchArray.length + " patches registered for " + string + ", but there is no possible order in which all of them can be applied!");
            Log.INSTANCE.println("W: This is likely a problem of separately developed patches. To use all patches at the same time,");
            Log.INSTANCE.println("W: make sure that there is at least one possible order to feed the output of one patch to the next.");
        }
        patchArray2 = new Patch[state.appliedTransitions.size()];
        for (int i = 0; i < patchArray2.length; ++i) {
            patchArray2[i] = ((Transition)state.appliedTransitions.get((int)i)).patch;
        }
        return patchArray2;
    }

    private PatchMetadata.PatchableClass findPatchableClass(String string, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PatchMetadata.PatchableClass patchableClass = (PatchMetadata.PatchableClass)iterator.next();
            if (!patchableClass.className.equals(string)) continue;
            return patchableClass;
        }
        return null;
    }

    private void createTransitions(Patch patch, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PatchMetadata.ClassChecksum classChecksum = (PatchMetadata.ClassChecksum)iterator.next();
            this.transitions.add(new Transition(patch, classChecksum.beforePatch, classChecksum.afterPatch));
        }
    }

    private void addTransitionsFrom(State state) {
        Iterator iterator = this.transitions.iterator();
        while (iterator.hasNext()) {
            Transition transition = (Transition)iterator.next();
            if (!transition.fromMd5.equals(state.md5) || state.isPatchApplied(transition.patch)) continue;
            State state2 = State.create(state, transition);
            boolean bl = true;
            Iterator iterator2 = this.states.iterator();
            while (iterator2.hasNext()) {
                State state3 = (State)iterator2.next();
                if (!state3.isEquivalent(state2)) continue;
                state2 = state3;
                bl = false;
                break;
            }
            if (bl) {
                this.states.add(state2);
                this.stateQueue.add(state2);
            }
            state.nextTransitions.add(transition);
            transition.nextStates.add(state2);
        }
    }
}

