/*
 * Decompiled with CFR 0.152.
 */
package com.mobileread.ixtab.jbpatch.bootstrap;

import com.mobileread.ixtab.jbpatch.Log;
import com.mobileread.ixtab.jbpatch.MD5;
import com.mobileread.ixtab.jbpatch.Patch;
import com.mobileread.ixtab.jbpatch.PatchMetadata;
import com.mobileread.ixtab.jbpatch.Patches;
import com.mobileread.ixtab.jbpatch.composition.PathFinder;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import sun.misc.Resource;
import sun.misc.URLClassPath;

class PatchingClassLoader
extends URLClassLoader {
    private static final String PACKAGE_NOFIND = "com.mobileread.ixtab.jbpatch.bootstrap.";
    private static final String PACKAGE_NOPATCH = "com.mobileread.ixtab.jbpatch.";
    private static final String LOG_CLASS_NAME = "com.mobileread.ixtab.jbpatch.Log";
    private static final String LOG_INSTANCE_NAME = "INSTANCE";
    private final AccessControlContext acc;
    private final URLClassPath ucp;
    private PrintStream log;
    private final Map avoidPackages;

    static PatchingClassLoader inject() throws Exception {
        ClassLoader classLoader = PatchingClassLoader.class.getClassLoader();
        if (!(classLoader instanceof URLClassLoader)) {
            throw new IllegalStateException();
        }
        ClassLoader classLoader2 = classLoader.getParent();
        if (classLoader2 instanceof PatchingClassLoader) {
            return (PatchingClassLoader)classLoader2;
        }
        URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
        PatchingClassLoader patchingClassLoader = new PatchingClassLoader(uRLArray, classLoader2, classLoader);
        PatchingClassLoader.replaceParent(classLoader, patchingClassLoader);
        return patchingClassLoader;
    }

    private static void replaceParent(ClassLoader classLoader, PatchingClassLoader patchingClassLoader) throws NoSuchFieldException, IllegalAccessException {
        Field field = ClassLoader.class.getDeclaredField("parent");
        field.setAccessible(true);
        field.set(classLoader, patchingClassLoader);
    }

    PatchingClassLoader(URL[] uRLArray, ClassLoader classLoader, ClassLoader classLoader2) {
        super(uRLArray, classLoader);
        this.ucp = new URLClassPath(uRLArray);
        this.acc = AccessController.getContext();
        this.avoidPackages = this.getPackagesToAvoid(classLoader2);
        this.log = this.loadLog();
        this.onInit();
    }

    private Map getPackagesToAvoid(ClassLoader classLoader) {
        try {
            Field field = ClassLoader.class.getDeclaredField("packages");
            field.setAccessible(true);
            return (Map)field.get(classLoader);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private PrintStream loadLog() {
        try {
            Class<?> clazz = this.loadClass(LOG_CLASS_NAME, true);
            Field field = clazz.getDeclaredField(LOG_INSTANCE_NAME);
            return (PrintStream)field.get(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return System.err;
        }
    }

    private void onInit() {
        this.log("");
        this.log("Log start timestamp: " + new Date());
        this.log("Bootstrap OK, PatchingClassLoader instantiated");
        this.log("   Packages still handled by original ClassLoader:");
        Iterator iterator = this.avoidPackages.keySet().iterator();
        while (iterator.hasNext()) {
            this.log("   - " + iterator.next().toString());
        }
        this.log("");
    }

    protected Class findClass(final String string) throws ClassNotFoundException {
        if (string.startsWith(PACKAGE_NOFIND)) {
            throw new ClassNotFoundException();
        }
        try {
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        String string2 = string.replace('.', '/').concat(".class");
                        Resource resource = PatchingClassLoader.this.ucp.getResource(string2, false);
                        if (resource != null) {
                            try {
                                return PatchingClassLoader.this.defineClass(string, resource);
                            }
                            catch (IOException iOException) {
                                throw new ClassNotFoundException(string, iOException);
                            }
                        }
                        throw new ClassNotFoundException(string);
                    }
                }, this.acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (ClassNotFoundException)privilegedActionException.getException();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Throwable throwable = classNotFoundException.getCause();
            if (throwable != null && throwable instanceof AvoidThisPackageException) {
                throw classNotFoundException;
            }
            return super.findClass(string);
        }
    }

    private Class defineClass(String string, Resource resource) throws IOException {
        URL uRL = resource.getCodeSourceURL();
        String string2 = this.getPackageName(string);
        if (string2 != null) {
            if (this.avoidPackages.containsKey(string2)) {
                throw new AvoidThisPackageException();
            }
            this.defineOrVerifyPackage(resource, uRL, string2);
        }
        return this.defineClass(string, resource, uRL);
    }

    private String getPackageName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        return string2;
    }

    private void defineOrVerifyPackage(Resource resource, URL uRL, String string) throws IOException {
        Manifest manifest = resource.getManifest();
        Package package_ = this.getPackage(string);
        if (package_ != null) {
            this.verifyPackageSecurity(uRL, string, package_, manifest);
        } else {
            this.definePackage(uRL, string, manifest);
        }
    }

    private void verifyPackageSecurity(URL uRL, String string, Package package_, Manifest manifest) {
        if (package_.isSealed()) {
            if (!package_.isSealed(uRL)) {
                throw new SecurityException("sealing violation: package " + string + " is sealed");
            }
        } else if (manifest != null && this.isSealed(string, manifest)) {
            throw new SecurityException("sealing violation: can't seal package " + string + ": already loaded");
        }
    }

    private void definePackage(URL uRL, String string, Manifest manifest) {
        if (manifest != null) {
            this.definePackage(string, manifest, uRL);
        } else {
            this.definePackage(string, null, null, null, null, null, null, null);
        }
    }

    private Class defineClass(String string, Resource resource, URL uRL) throws IOException {
        byte[] byArray = resource.getBytes();
        if (this.okToPatch(string)) {
            byArray = this.patch(string, byArray);
        }
        Certificate[] certificateArray = resource.getCertificates();
        CodeSource codeSource = new CodeSource(uRL, certificateArray);
        return this.defineClass(string, byArray, 0, byArray.length, codeSource);
    }

    private boolean okToPatch(String string) {
        return !string.startsWith(PACKAGE_NOPATCH);
    }

    Class defineClass(String string, byte[] byArray) {
        return this.defineClass(string, byArray, 0, byArray.length, (CodeSource)null);
    }

    private boolean isSealed(String string, Manifest manifest) {
        String string2 = string.replace('.', '/').concat("/");
        Attributes attributes = manifest.getAttributes(string2);
        String string3 = null;
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if (string3 == null && (attributes = manifest.getMainAttributes()) != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(string3);
    }

    void log(String string) {
        this.log.println(string);
        this.log.flush();
    }

    private byte[] patch(String string, byte[] byArray) {
        Patch[] patchArray = Patches.get(string);
        if (patchArray == null || patchArray.length == 0) {
            return byArray;
        }
        byte[] byArray2 = byArray;
        String string2 = MD5.getMd5String(byArray);
        if (patchArray.length > 1) {
            PathFinder pathFinder = new PathFinder(string2);
            patchArray = pathFinder.findPath(patchArray, string);
        }
        for (int i = 0; i < patchArray.length; ++i) {
            Patch patch = patchArray[i];
            PatchMetadata.ClassChecksum classChecksum = patch.getMetadata().getChecksumsFor(string, string2);
            if (classChecksum == null) {
                Log.INSTANCE.println("E: " + patch + " does not support MD5 " + string2 + " for class " + string);
                continue;
            }
            byArray2 = patch.patch(string, byArray, string2);
            if (byArray2 == byArray) continue;
            byArray = byArray2;
            String string3 = string2;
            string2 = MD5.getMd5String(byArray);
            this.log("I: " + patch.id() + " applied to " + string + " (" + string3 + " -> " + string2 + ")");
            if (string2.equals(classChecksum.afterPatch)) continue;
            this.log("W: " + patch + " produced MD5 \"" + string2 + "\", but declared \"" + classChecksum.afterPatch + "\"");
        }
        return byArray2;
    }

    boolean injectUrl(URL uRL) {
        URL[] uRLArray = this.getURLs();
        this.addURL(uRL);
        URL[] uRLArray2 = this.getURLs();
        return uRLArray.length + 1 == uRLArray2.length;
    }

    private static class AvoidThisPackageException
    extends IOException {
        private static final long serialVersionUID = 1L;

        private AvoidThisPackageException() {
        }
    }
}

