/*
 * Decompiled with CFR 0.152.
 */
package com.mobileread.ixtab.jbpatch;

import com.mobileread.ixtab.jbpatch.KindleDirectories;
import com.mobileread.ixtab.jbpatch.Log;
import com.mobileread.ixtab.jbpatch.Patch;
import com.mobileread.ixtab.jbpatch.PatchContainer;
import com.mobileread.ixtab.jbpatch.PatchMetadata;
import com.mobileread.ixtab.jbpatch.PatchPolicy;
import com.mobileread.ixtab.jbpatch.PatchRepository;
import com.mobileread.ixtab.jbpatch.builtin.DeviceInfoPatch;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import serp.bytecode.BCClass;
import serp.bytecode.Project;

public class Patches {
    private static final String PCL_CLASSNAME = "com.mobileread.ixtab.jbpatch.bootstrap.PatchingClassLoader";
    private static final String PCL_DEFINECLASS_METHODNAME = "defineClass";
    private static final Map patches = new TreeMap();
    private static final PrintStream log = Log.INSTANCE;
    private static int active = 0;
    private static int available = 0;
    private static Method defineClassMethod = null;
    private static boolean initialized = false;

    private Patches() {
    }

    private static void log(String string) {
        log.println(string);
    }

    public static Patch[] get(String string) {
        List list = (List)patches.get(string);
        if (list == null) {
            return null;
        }
        Object[] objectArray = list.toArray();
        Patch[] patchArray = new Patch[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            patchArray[i] = (Patch)objectArray[i];
        }
        return patchArray;
    }

    private static boolean enable(Patch patch) {
        List list = patch.metadata().supportedClasses;
        if (list != null) {
            int n;
            for (n = 0; n < list.size(); ++n) {
                PatchMetadata.PatchableClass patchableClass = (PatchMetadata.PatchableClass)list.get(n);
                Patches.registerForClass(patchableClass, patch);
            }
            n = PatchPolicy.register(patch);
            if (n > 0) {
                Patches.log("I: " + patch.id() + " has been granted " + n + " additional permission" + (n == 1 ? "" : "s") + " on request");
            }
            return true;
        }
        return false;
    }

    private static void registerForClass(PatchMetadata.PatchableClass patchableClass, Patch patch) {
        String string = patchableClass.className;
        List list = Patches.getNonNullList(string);
        list.add(patch);
        Patches.log("I: " + patch.id() + " registered for " + string);
        ++available;
    }

    private static List getNonNullList(String string) {
        ArrayList arrayList = (ArrayList)patches.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            patches.put(string, arrayList);
        }
        return arrayList;
    }

    private static Patch add(File file, boolean bl) {
        ClassLoader classLoader = Patches.class.getClassLoader();
        if (Patches.isPatchingClassLoader(classLoader)) {
            String string = file.getName();
            try {
                Patch patch = null;
                String string2 = null;
                if (string.endsWith(".class")) {
                    string2 = string.substring(0, string.length() - ".class".length());
                    patch = Patches.instantiate(new BufferedInputStream(new FileInputStream(file)), classLoader, string);
                } else if (string.endsWith(".jar")) {
                    string2 = string.substring(0, string.length() - ".jar".length());
                    patch = PatchContainer.instantiatePatch(file, classLoader, string);
                } else {
                    throw new IllegalStateException();
                }
                if (patch != null) {
                    patch.setId(string2);
                    if (!bl) {
                        return patch;
                    }
                    if (bl && Patches.enable(patch)) {
                        return patch;
                    }
                }
            }
            catch (Throwable throwable) {
                Patches.log("E: while instantiating " + string + ": ");
                throwable.printStackTrace(log);
            }
        }
        return null;
    }

    private static boolean isPatchingClassLoader(ClassLoader classLoader) {
        return classLoader.getClass().getName().equals(PCL_CLASSNAME);
    }

    private static Patch instantiate(InputStream inputStream, ClassLoader classLoader, String string) throws Throwable {
        BCClass bCClass = new Project().loadClass(inputStream);
        String string2 = bCClass.getName();
        byte[] byArray = bCClass.toByteArray();
        try {
            return Patches.instantiate(string2, byArray, classLoader, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable != null && throwable instanceof LinkageError) {
                try {
                    Class.forName(string2);
                    Patches.log("E: " + string + " not instantiated: another class with name " + string2 + " is already loaded");
                    return null;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
            throw invocationTargetException;
        }
    }

    private static Patch instantiate(String string, byte[] byArray, ClassLoader classLoader, String string2) throws Throwable {
        Class clazz;
        if (!Patch.class.isAssignableFrom(clazz = Patches.defineClass(classLoader, string, byArray))) {
            Patches.log("E: " + string + " is not a valid patch.");
            return null;
        }
        if (!string2.equals(clazz.getName() + ".class")) {
            Patches.log("W: " + clazz.getName() + " deployed with mismatching file name, ignoring: Expected " + clazz.getName() + ".class" + ", but filename is " + string2);
            return null;
        }
        return (Patch)clazz.newInstance();
    }

    private static synchronized Class defineClass(ClassLoader classLoader, String string, byte[] byArray) throws Throwable {
        Patches.ensureDefineClassMethodIsSet(classLoader);
        return (Class)defineClassMethod.invoke((Object)classLoader, string, byArray);
    }

    private static void ensureDefineClassMethodIsSet(ClassLoader classLoader) throws NoSuchMethodException {
        if (defineClassMethod == null) {
            Class<?> clazz = classLoader.getClass();
            defineClassMethod = clazz.getDeclaredMethod(PCL_DEFINECLASS_METHODNAME, String.class, [B.class);
            defineClassMethod.setAccessible(true);
        }
    }

    public static void init() {
        if (initialized) {
            return;
        }
        Patches.log("JBPatch version 2.4.0: initializing patches");
        initialized = true;
        Patches.log("");
        KindleDirectories.init();
        Patches.addBuiltins();
        Patches.addExternals();
    }

    private static void addBuiltins() {
        if (!Patches.enable(new DeviceInfoPatch().setId("(builtin) DeviceInfo"))) {
            Patches.log("E: built-in device info patch could not be enabled!");
        }
    }

    private static void addExternals() {
        PatchRepository patchRepository = PatchRepository.getInstance();
        Map map = patchRepository.initialize();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Boolean bl;
            Map.Entry entry = iterator.next();
            File file = (File)entry.getKey();
            Patch patch = Patches.add(file, bl = (Boolean)entry.getValue());
            if (patch == null) continue;
            patchRepository.addAvailable(patch, bl);
        }
    }

    static void reportActive() {
        ++active;
    }

    public static int getActiveCount() {
        return active;
    }

    public static int getAvailableCount() {
        return available;
    }
}

