/*
 * Decompiled with CFR 0.152.
 */
package com.mobileread.ixtab.jbpatch;

import com.mobileread.ixtab.jbpatch.Log;
import com.mobileread.ixtab.jbpatch.Patch;
import com.mobileread.ixtab.jbpatch.resources.KeyValueFile;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class PatchRepository {
    public static final String EXTENSION_PATCH_STANDALONE = ".class";
    public static final String EXTENSION_PATCH_JARRED = ".jar";
    private static final String EXTENSION_TXT = ".txt";
    private static final String CONFIGFILE_NAME = "CONFIG.txt";
    private static final char[] SPECIAL_CHARS_OK = new char[]{'.', '_'};
    private static final String VALUE_ENABLED = "enabled";
    private static final String VALUE_DISABLED = "disabled";
    private static final PatchRepository instance = new PatchRepository();
    private final KeyValueFile backend;
    private final Map patchStateMap = new TreeMap();

    public static PatchRepository getInstance() {
        return instance;
    }

    private PatchRepository() {
        File file = new File("/var/local/jbpatch/CONFIG.txt");
        this.backend = new KeyValueFile(KeyValueFile.FLAG_WRITABLE, file);
    }

    Map initialize() {
        Object object;
        int n;
        boolean bl = false;
        File[] fileArray = this.listPresentPatchFiles();
        ArrayList arrayList = new ArrayList(this.backend.listKeys());
        TreeMap<File, Object> treeMap = new TreeMap<File, Object>();
        for (n = 0; n < fileArray.length; ++n) {
            object = null;
            String string = this.getPatchId(fileArray[n].getName());
            arrayList.remove(string);
            String string2 = this.backend.getValue(string);
            if (string2 == null) {
                this.log("I: " + string + " was not found in configuration, adding entry and enabling patch");
                if (!this.backend.setValue(string, VALUE_ENABLED, false)) {
                    this.log("E: failed to add patch " + string + " to configuration!");
                }
                object = Boolean.TRUE;
                bl = true;
            } else {
                object = this.parseStatus(string2);
                if (object == null) {
                    this.log("W: " + string + " has wrong entry in configuration file, fixing entry and enabling patch");
                    if (!this.backend.setValue(string, VALUE_ENABLED, false)) {
                        this.log("E: failed to fix state for patch " + string + " in configuration!");
                    }
                    object = Boolean.TRUE;
                    bl = true;
                }
            }
            treeMap.put(fileArray[n], object);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = (String)arrayList.get(n);
            if (!this.backend.remove((String)object, false)) {
                this.log("E: failed to remove patch " + (String)object + " from configuration!");
            }
            bl = true;
        }
        if (bl) {
            if (!this.backend.commitChanges()) {
                this.log("E: failed to update configuration file!");
            } else {
                this.log("I: updated configuration file");
            }
        }
        return treeMap;
    }

    private File[] listPresentPatchFiles() {
        File file = new File("/var/local/jbpatch");
        if (!file.exists() || !file.isDirectory()) {
            return new File[0];
        }
        return file.listFiles(new FilenamesFilter(false, false));
    }

    private void log(String string) {
        Log.INSTANCE.println(string);
    }

    private Boolean parseStatus(String string) {
        if (VALUE_ENABLED.equals(string)) {
            return Boolean.TRUE;
        }
        if (VALUE_DISABLED.equals(string)) {
            return Boolean.FALSE;
        }
        return null;
    }

    private String getPatchId(String string) {
        if (string.endsWith(EXTENSION_PATCH_STANDALONE)) {
            return string.substring(0, string.length() - EXTENSION_PATCH_STANDALONE.length());
        }
        if (string.endsWith(EXTENSION_PATCH_JARRED)) {
            return string.substring(0, string.length() - EXTENSION_PATCH_JARRED.length());
        }
        throw new IllegalStateException();
    }

    void addAvailable(Patch patch, Boolean bl) {
        this.patchStateMap.put(patch, bl);
    }

    public static Character checkForWrongCharacters(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || PatchRepository.isAllowedSpecialChar(c)) continue;
            return new Character(c);
        }
        return null;
    }

    private static boolean isAllowedSpecialChar(char c) {
        for (int i = 0; i < SPECIAL_CHARS_OK.length; ++i) {
            if (c != SPECIAL_CHARS_OK[i]) continue;
            return true;
        }
        return false;
    }

    public synchronized Map getAvailablePatches() {
        return this.patchStateMap;
    }

    public boolean setPatchState(Patch patch, boolean bl) {
        this.patchStateMap.put(patch, bl);
        return this.backend.setValue(patch.id(), bl ? VALUE_ENABLED : VALUE_DISABLED, true);
    }

    public static class FilenamesFilter
    implements FilenameFilter {
        private final boolean allowAuxiliaryFiles;
        private final boolean allowMainConfigurationFile;

        public FilenamesFilter(boolean bl, boolean bl2) {
            this.allowAuxiliaryFiles = bl;
            this.allowMainConfigurationFile = bl2;
        }

        public boolean accept(File file, String string) {
            if (string.equals(PatchRepository.CONFIGFILE_NAME)) {
                return this.allowMainConfigurationFile;
            }
            if (this.allowAuxiliaryFiles && string.endsWith(PatchRepository.EXTENSION_TXT)) {
                return true;
            }
            return (string.endsWith(PatchRepository.EXTENSION_PATCH_STANDALONE) || string.endsWith(PatchRepository.EXTENSION_PATCH_JARRED)) && PatchRepository.checkForWrongCharacters(string) == null;
        }
    }
}

