/*
 * Decompiled with CFR 0.152.
 */
package com.mobileread.ixtab.jbpatch;

import com.mobileread.ixtab.jbpatch.Log;
import com.mobileread.ixtab.jbpatch.Patch;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class PatchPolicy
extends Policy {
    private static final PatchPolicy instance = new PatchPolicy(PatchPolicy.getPolicy());
    private final Policy delegate;
    private final Map extendedPolicies = new HashMap();

    private PatchPolicy(Policy policy) {
        this.delegate = policy;
        Policy.setPolicy(this);
    }

    public static int register(Patch patch) {
        Permission[] permissionArray = patch.getRequiredPermissions();
        return instance.register(patch, permissionArray);
    }

    private int register(Patch patch, Permission[] permissionArray) {
        if (permissionArray != null && permissionArray.length != 0) {
            ProtectionDomain protectionDomain = patch.getClass().getProtectionDomain();
            this.extendedPolicies.put(protectionDomain, this.combinePermissions(permissionArray, this.delegate.getPermissions(protectionDomain)));
            return permissionArray.length;
        }
        return 0;
    }

    private PermissionCollection combinePermissions(Permission[] permissionArray, PermissionCollection permissionCollection) {
        Permissions permissions = new Permissions();
        this.copyAllPermissions(permissionArray, permissions);
        this.copyPermissions(permissionCollection, permissions);
        permissions.setReadOnly();
        return permissions;
    }

    private void copyAllPermissions(Permission[] permissionArray, Permissions permissions) {
        for (int i = 0; i < permissionArray.length; ++i) {
            permissions.add(permissionArray[i]);
        }
    }

    private void copyPermissions(PermissionCollection permissionCollection, Permissions permissions) {
        Enumeration<Permission> enumeration = permissionCollection.elements();
        while (enumeration.hasMoreElements()) {
            permissions.add(enumeration.nextElement());
        }
    }

    public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
        PermissionCollection permissionCollection = (PermissionCollection)this.extendedPolicies.get(protectionDomain);
        if (permissionCollection != null) {
            return permissionCollection;
        }
        return this.delegate.getPermissions(protectionDomain);
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        return this.delegate.getPermissions(codeSource);
    }

    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        return this.getPermissions(protectionDomain).implies(permission);
    }

    public void refresh() {
    }

    static {
        Log.INSTANCE.println("I: Patch policy initialized");
    }
}

