/*
 * Decompiled with CFR 0.152.
 */
package com.mobileread.ixtab.jbpatch;

import com.mobileread.ixtab.jbpatch.Log;
import com.mobileread.ixtab.jbpatch.Patch;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

public final class PatchContainer {
    private static Method injectMethod;

    private PatchContainer() {
    }

    public static Patch instantiatePatch(File file, ClassLoader classLoader, String string) throws Throwable {
        JarFile jarFile = PatchContainer.verifyAsJar(file);
        String string2 = PatchContainer.getMainClassInManifest(jarFile);
        if (string2 == null) {
            throw new IllegalStateException(string + " does not specify a patch to execute");
        }
        URL uRL = file.toURI().toURL();
        PatchContainer.ensurePatchIsValid(classLoader, string2, uRL);
        if (!PatchContainer.validateName(string, string2)) {
            return null;
        }
        PatchContainer.injectUrlIntoClassLoader(uRL, classLoader);
        return (Patch)classLoader.loadClass(string2).newInstance();
    }

    private static JarFile verifyAsJar(File file) {
        try {
            return new JarFile(file);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("not a valid jar file: " + file);
        }
    }

    private static String getMainClassInManifest(JarFile jarFile) {
        try {
            Attributes attributes = jarFile.getManifest().getMainAttributes();
            return attributes.getValue(Attributes.Name.MAIN_CLASS);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Unable to determine patch in " + jarFile);
        }
    }

    private static void ensurePatchIsValid(ClassLoader classLoader, String string, URL uRL) {
        try {
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL}, classLoader);
            Class<?> clazz = uRLClassLoader.loadClass(string);
            if (clazz == null || !Patch.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException();
            }
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(string + " in " + uRL + " is not a valid Patch");
        }
    }

    private static boolean validateName(String string, String string2) {
        int n = string2.lastIndexOf(46);
        if (n == -1) {
            throw new IllegalArgumentException("Main class \"" + string2 + "\" in patch \"" + string + " \" must not be in default package");
        }
        String string3 = string2.substring(0, n);
        if (!(string3 + ".jar").equals(string)) {
            Log.INSTANCE.println("W: " + string + " deployed with mismatching file name, ignoring: Expected " + string3 + ".jar" + ", but filename is " + string);
            return false;
        }
        return true;
    }

    private static void injectUrlIntoClassLoader(URL uRL, ClassLoader classLoader) throws Throwable {
        PatchContainer.ensureInjectMethodIsSet(classLoader);
        Boolean bl = (Boolean)injectMethod.invoke((Object)classLoader, uRL);
        if (!bl.booleanValue()) {
            throw new RuntimeException("Unable to inject " + uRL + " into classpath");
        }
    }

    private static void ensureInjectMethodIsSet(ClassLoader classLoader) throws NoSuchMethodException {
        if (injectMethod == null) {
            Class<?> clazz = classLoader.getClass();
            injectMethod = clazz.getDeclaredMethod("injectUrl", URL.class);
            injectMethod.setAccessible(true);
        }
    }
}

