/*
 * Decompiled with CFR 0.152.
 */
package com.mobileread.ixtab.jbpatch;

import com.mobileread.ixtab.jbpatch.Log;
import com.mobileread.ixtab.jbpatch.MD5;
import com.mobileread.ixtab.jbpatch.PatchMetadata;
import com.mobileread.ixtab.jbpatch.Patches;
import com.mobileread.ixtab.jbpatch.conf.ConfigurableSettings;
import com.mobileread.ixtab.jbpatch.resources.JBPatchResource;
import com.mobileread.ixtab.jbpatch.resources.KeyValueResource;
import com.mobileread.ixtab.jbpatch.resources.ResourceMapProvider;
import java.io.ByteArrayInputStream;
import java.io.PrintStream;
import java.security.Permission;
import java.util.Map;
import java.util.TreeMap;
import serp.bytecode.BCClass;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.Project;

public abstract class Patch
implements Comparable,
ResourceMapProvider {
    public static final String I18N_JBPATCH_NAME = "jbpatch.name";
    public static final String I18N_JBPATCH_DESCRIPTION = "jbpatch.description";
    protected static final PrintStream logger = Log.INSTANCE;
    private KeyValueResource localizationResource = null;
    private ConfigurableSettings configurableSettings = null;
    private String id;
    private PatchMetadata metadata = null;

    protected abstract void initLocalization(String var1, Map var2);

    public abstract int getVersion();

    public abstract PatchMetadata getMetadata();

    public Permission[] getRequiredPermissions() {
        return null;
    }

    protected ConfigurableSettings initConfigurableSettings() {
        return null;
    }

    public abstract String perform(String var1, BCClass var2) throws Throwable;

    protected final String getConfigured(String string) {
        return this.configurableSettings.getValue(string);
    }

    public final String localize(String string) {
        if (this.localizationResource != null) {
            return this.localizationResource.getValue(string);
        }
        return string;
    }

    protected static final void log(String string) {
        logger.println(string);
    }

    public static void dump(Code code) {
        if (code != null) {
            Instruction[] instructionArray = code.getInstructions();
            for (int i = 0; i < instructionArray.length; ++i) {
                Instruction instruction = instructionArray[i];
                Patch.log(i + " " + instruction);
            }
        }
    }

    protected final String md5(BCClass bCClass) {
        return MD5.getMd5String(bCClass.toByteArray());
    }

    public final String id() {
        return this.id;
    }

    private void initResources() {
        this.localizationResource = JBPatchResource.getResource(this, 0);
        JBPatchResource.getResource(this, 1);
    }

    public final Map getDefaultResourceMap(String string) {
        if (string == RESOURCE_ID_CONFIGURATION) {
            this.configurableSettings = this.initConfigurableSettings();
            return this.configurableSettings;
        }
        TreeMap treeMap = new TreeMap();
        this.initLocalization(string, treeMap);
        if (!treeMap.isEmpty()) {
            return treeMap;
        }
        return null;
    }

    public final ConfigurableSettings getConfigurableSettings() {
        return this.configurableSettings;
    }

    public final byte[] patch(String string, byte[] byArray, String string2) {
        try {
            BCClass bCClass = Patch.loadBCClass(byArray);
            String string3 = this.perform(string2, bCClass);
            if (string3 == null) {
                Patches.reportActive();
                return bCClass.toByteArray();
            }
            Patch.log("E: " + this.id + " failed to patch " + string + " (" + string2 + "): " + string3);
        }
        catch (Throwable throwable) {
            Patch.log("E: " + this.id + " failed to patch " + string + " (" + string2 + "):");
            throwable.printStackTrace(logger);
        }
        return byArray;
    }

    static BCClass loadBCClass(byte[] byArray) {
        return new Project().loadClass(new ByteArrayInputStream(byArray));
    }

    final Patch setId(String string) {
        this.id = string;
        this.initResources();
        return this;
    }

    public final String getName() {
        return this.localizationResource.getValue(I18N_JBPATCH_NAME);
    }

    public final String getDescription() {
        return this.localizationResource.getValue(I18N_JBPATCH_DESCRIPTION);
    }

    public final PatchMetadata metadata() {
        if (this.metadata == null) {
            this.metadata = this.getMetadata();
        }
        return this.metadata;
    }

    public int compareTo(Object object) {
        Patch patch = (Patch)object;
        return this.id().compareTo(patch.id());
    }

    public String toString() {
        return this.id();
    }
}

