/*
 * Decompiled with CFR 0.152.
 */
package com.mobileread.ixtab.jbpatch;

import com.mobileread.ixtab.jbpatch.Log;
import com.mobileread.ixtab.jbpatch.MD5;
import com.mobileread.ixtab.jbpatch.PatchRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class KindleDirectories {
    public static final String USERSTORE_DIRECTORY = "/mnt/us/opt/jbpatch";
    public static final String LOCAL_DIRECTORY = "/var/local/jbpatch";
    private static final int SYNC_INTERVAL_MS = 5000;
    private static final int SYNC_WAIT_AFTER_START_MS = 1000;
    private static File sourceDir;
    private static File targetDir;
    private static SynchLock synchLock;

    public static void init() {
        targetDir = new File(LOCAL_DIRECTORY);
        if (!targetDir.exists()) {
            targetDir.mkdir();
        }
        sourceDir = new File(USERSTORE_DIRECTORY);
        new SynchThread().start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(File file, File file2) throws IOException {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            byte[] byArray = new byte[4096];
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            int n = fileInputStream.read(byArray);
            while (n != -1) {
                fileOutputStream.write(byArray, 0, n);
                n = fileInputStream.read(byArray);
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reverseSync() {
        SynchLock synchLock = KindleDirectories.synchLock;
        synchronized (synchLock) {
            int n = 0;
            try {
                File[] fileArray = targetDir.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    File file = fileArray[i];
                    if (!file.isFile() || !file.canRead()) continue;
                    File file2 = new File(sourceDir + File.separator + file.getName());
                    KindleDirectories.copy(file, file2);
                    ++n;
                }
            }
            catch (Throwable throwable) {
                Log.INSTANCE.println("Error during reverse sync, exception follows.");
                throwable.printStackTrace(Log.INSTANCE);
                return false;
            }
            if (n != 0) {
                Log.INSTANCE.println("Reverse sync complete, copied " + n + " files.");
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean cleanup() {
        SynchLock synchLock = KindleDirectories.synchLock;
        synchronized (synchLock) {
            if (!KindleDirectories.synchLock.synchronizeAllFiles) {
                KindleDirectories.synchLock.synchronizeAllFiles = true;
                try {
                    KindleDirectories.synchLock.wait(15000L);
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
                return !KindleDirectories.synchLock.synchronizeAllFiles;
            }
            return false;
        }
    }

    static {
        synchLock = new SynchLock();
    }

    private static class SynchLock {
        private volatile boolean synchronizeAllFiles = false;

        private SynchLock() {
        }
    }

    private static class ShutdownThread
    extends Thread {
        private final SynchThread sync;

        public ShutdownThread(SynchThread synchThread) {
            super("JBPatchSynchronizerShutdownThread");
            this.sync = synchThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ShutdownStatus shutdownStatus = this.sync.shutdown;
            synchronized (shutdownStatus) {
                this.sync.shutdown.isRequested = true;
                this.sync.shutdown.notifyAll();
            }
        }
    }

    private static class FileModificationInfo {
        private final long sourceTimestamp;
        private final long targetTimestamp;

        public FileModificationInfo(long l, long l2) {
            this.sourceTimestamp = l;
            this.targetTimestamp = l2;
        }
    }

    private static class ShutdownStatus {
        private volatile boolean isRequested = false;

        private ShutdownStatus() {
        }
    }

    private static class SynchThread
    extends Thread {
        private final ShutdownStatus shutdown = new ShutdownStatus();
        private final Map knownFiles = new HashMap();
        private final FilenameFilter normalFileFilter = new PatchRepository.FilenamesFilter(true, false);
        private final FilenameFilter fullFileFilter = new PatchRepository.FilenamesFilter(true, true);
        private boolean targetWasOkLastTime = true;

        public SynchThread() {
            super("JBPatchDirectoriesSynchronizerThread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Runtime.getRuntime().addShutdownHook(new ShutdownThread(this));
            ShutdownStatus shutdownStatus = this.shutdown;
            synchronized (shutdownStatus) {
                this.log("I: Directory synchronization thread started");
                while (!this.shutdown.isRequested) {
                    try {
                        this.synchronize();
                    }
                    catch (Throwable throwable) {
                        this.log("E: " + new Date() + ": unexpected error while synchronizing directories:");
                        throwable.printStackTrace(Log.INSTANCE);
                    }
                    try {
                        this.shutdown.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.log("I: Directory synchronization thread exiting");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void synchronize() {
            SynchLock synchLock = synchLock;
            synchronized (synchLock) {
                File[] fileArray = this.listTargetFiles();
                if (fileArray == null) {
                    return;
                }
                File[] fileArray2 = sourceDir.listFiles(synchLock.synchronizeAllFiles ? this.fullFileFilter : this.normalFileFilter);
                if (fileArray2 == null) {
                    return;
                }
                if (synchLock.synchronizeAllFiles) {
                    this.removeObsoleteFilesInTarget(fileArray2, fileArray);
                }
                for (int i = 0; i < fileArray2.length; ++i) {
                    File file = fileArray2[i];
                    if (!file.isFile() || !file.canRead()) continue;
                    this.synchronize(file);
                }
                if (synchLock.synchronizeAllFiles) {
                    synchLock.synchronizeAllFiles = false;
                    synchLock.notifyAll();
                }
            }
        }

        private File[] listTargetFiles() {
            if (!targetDir.exists()) {
                this.knownFiles.clear();
                if (this.targetWasOkLastTime) {
                    this.log("W: " + new Date() + ": " + KindleDirectories.LOCAL_DIRECTORY + " does not exist, attempting to re-create it!");
                }
                if (targetDir.mkdir()) {
                    this.log("I: " + new Date() + ": created " + KindleDirectories.LOCAL_DIRECTORY);
                    this.targetWasOkLastTime = true;
                } else {
                    if (this.targetWasOkLastTime) {
                        this.log("E: " + new Date() + ": failed to create " + KindleDirectories.LOCAL_DIRECTORY);
                    }
                    this.targetWasOkLastTime = false;
                }
            }
            return this.targetWasOkLastTime ? targetDir.listFiles() : null;
        }

        private void removeObsoleteFilesInTarget(File[] fileArray, File[] fileArray2) {
            int n;
            HashSet<String> hashSet = new HashSet<String>();
            for (n = 0; n < fileArray.length; ++n) {
                hashSet.add(fileArray[n].getName());
            }
            for (n = 0; n < fileArray2.length; ++n) {
                File file = fileArray2[n];
                if (hashSet.contains(file.getName())) continue;
                this.knownFiles.remove(file.getName());
                if (file.delete()) {
                    this.log("I: " + new Date() + ": deleted obsolete file " + file);
                    continue;
                }
                this.log("E: " + new Date() + ": unable to delete obsolete file " + file);
            }
        }

        private void synchronize(File file) {
            boolean bl = false;
            File file2 = new File(targetDir + File.separator + file.getName());
            FileModificationInfo fileModificationInfo = (FileModificationInfo)this.knownFiles.get(file.getName());
            if (fileModificationInfo == null) {
                bl = true;
            } else if (file.lastModified() != fileModificationInfo.sourceTimestamp) {
                bl = true;
            } else if (!file2.exists() || file2.lastModified() != fileModificationInfo.targetTimestamp) {
                bl = true;
            }
            if (bl) {
                this.copyIfNeeded(file, file2, fileModificationInfo == null);
            }
        }

        private void copyIfNeeded(File file, File file2, boolean bl) {
            if (bl && this.filesAreEqual(file, file2)) {
                FileModificationInfo fileModificationInfo = new FileModificationInfo(file.lastModified(), file2.lastModified());
                this.knownFiles.put(file.getName(), fileModificationInfo);
                return;
            }
            if (file2.exists() && !file2.delete()) {
                this.log("E: " + new Date() + ": unable to delete " + file2);
            }
            try {
                KindleDirectories.copy(file, file2);
                FileModificationInfo fileModificationInfo = new FileModificationInfo(file.lastModified(), file2.lastModified());
                this.knownFiles.put(file.getName(), fileModificationInfo);
                this.log("I: " + new Date() + ": synchronized " + file.getName());
            }
            catch (Throwable throwable) {
                this.log("E: " + new Date() + ": error while copying " + file + " :");
                throwable.printStackTrace(Log.INSTANCE);
            }
        }

        private boolean filesAreEqual(File file, File file2) {
            String string = this.getMd5(file);
            String string2 = this.getMd5(file2);
            return string != null && string2 != null && string.equals(string2);
        }

        private String getMd5(File file) {
            try {
                byte[] byArray = new byte[(int)file.length()];
                FileInputStream fileInputStream = new FileInputStream(file);
                int n = fileInputStream.read(byArray);
                if (n != byArray.length) {
                    this.log("E: " + new Date() + ": error while reading " + file + "; expected " + byArray.length + " bytes, but got " + n);
                    return null;
                }
                String string = MD5.getMd5String(byArray);
                return string;
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        private void log(String string) {
            Log.INSTANCE.println(string);
        }
    }
}

