/*
 * Decompiled with CFR 0.152.
 */
package com.mobileread.ixtab.jbpatch;

import com.mobileread.ixtab.jbpatch.MD5;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public final class KindleDevice {
    private static final String VERSION_FILENAME = "/etc/version.txt";
    private static final String MD5_KT_510_1557760049 = "4d14b7af911080e6a073121eb3262e54";
    private static final String MD5_KT_511_1568190003 = "27828f5c87c8d7f345ddf157bdcac1df";
    private static final Map md5Map = KindleDevice.buildFirmwareMap();
    public static KindleDevice THIS_DEVICE = new KindleDevice(KindleDevice.getVersionMd5());
    public static final KindleDevice KT_510_1557760049 = new KindleDevice("4d14b7af911080e6a073121eb3262e54");
    public static final KindleDevice KT_511_1568190003 = new KindleDevice("27828f5c87c8d7f345ddf157bdcac1df");
    public final String md5;
    private final String description;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getVersionMd5() {
        String string = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(VERSION_FILENAME));
            String string2 = bufferedReader.readLine();
            if (string2 != null) {
                string = MD5.getMd5String(string2.getBytes());
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string;
    }

    private static Map buildFirmwareMap() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put(MD5_KT_510_1557760049, "Kindle 5.1.0 (1557760049)");
        treeMap.put(MD5_KT_511_1568190003, "Kindle 5.1.1 (1568190003)");
        return treeMap;
    }

    private KindleDevice(String string) {
        this.md5 = string;
        this.description = (String)md5Map.get(string);
    }

    public String getDescription() {
        return this.description;
    }

    public String getSafeDescription() {
        return this.description != null ? this.description : "UNKNOWN FIRMWARE WITH ID " + this.md5;
    }

    public String toString() {
        return this.getSafeDescription();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        KindleDevice kindleDevice = (KindleDevice)object;
        return !(this.md5 == null ? kindleDevice.md5 != null : !this.md5.equals(kindleDevice.md5));
    }
}

