/*
 * Decompiled with CFR 0.152.
 */
package com.mobileread.ixtab.jbpatch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class I18n {
    private final String[] locales;
    private final Map[] translations;

    public I18n() {
        this((InputStream)null, null);
    }

    public I18n(URL uRL) {
        this(uRL, null);
    }

    public I18n(URL uRL, Locale locale) {
        this(I18n.safeStream(uRL), locale);
    }

    public I18n(InputStream inputStream) {
        this(inputStream, null);
    }

    public I18n(InputStream inputStream, Locale locale) {
        this.locales = this.determineLocalesSearchOrder(locale != null ? locale : Locale.getDefault());
        this.translations = this.initializeTranslations(this.locales.length);
        if (inputStream != null) {
            this.fillTranslations(inputStream);
        }
    }

    private static InputStream safeStream(URL uRL) {
        if (uRL == null) {
            return null;
        }
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private String[] determineLocalesSearchOrder(Locale locale) {
        ArrayList<Locale> arrayList = new ArrayList<Locale>(3);
        arrayList.add(locale);
        Locale locale2 = locale;
        locale = new Locale(locale2.getLanguage());
        if (!locale.equals(locale2)) {
            arrayList.add(locale);
        }
        if (!locale.equals(Locale.ENGLISH)) {
            arrayList.add(Locale.ENGLISH);
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((Locale)arrayList.get(i)).toString();
        }
        return stringArray;
    }

    private Map[] initializeTranslations(int n) {
        Map[] mapArray = new Map[n];
        for (int i = 0; i < n; ++i) {
            mapArray[i] = new TreeMap();
        }
        return mapArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillTranslations(InputStream inputStream) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            Map map = null;
            String string = bufferedReader.readLine();
            while (string != null) {
                if (!this.isIgnorable(string)) {
                    String string2 = this.interpretAsSection(string);
                    if (string2 != null) {
                        map = this.lookupTranslationFor(string2);
                    } else {
                        this.insertIfValid(string, map);
                    }
                }
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean isIgnorable(String string) {
        String string2 = string.trim();
        return string2.length() == 0 || string2.startsWith("#");
    }

    private String interpretAsSection(String string) {
        String string2 = string.trim();
        if (string.startsWith("[") && string2.endsWith("]")) {
            return string2.substring(1, string2.length() - 1);
        }
        return null;
    }

    private Map lookupTranslationFor(String string) {
        for (int i = 0; i < this.locales.length; ++i) {
            if (!this.locales[i].equals(string)) continue;
            return this.translations[i];
        }
        return null;
    }

    private void insertIfValid(String string, Map map) {
        if (map == null) {
            return;
        }
        int n = string.indexOf(61);
        if (n == -1) {
            return;
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        map.put(string2, string3);
    }

    public String[] getOrderedLocales() {
        String[] stringArray = new String[this.locales.length];
        System.arraycopy(this.locales, 0, stringArray, 0, this.locales.length);
        return stringArray;
    }

    public String i18n(String string) {
        string = string.trim();
        for (int i = 0; i < this.translations.length; ++i) {
            Object v = this.translations[i].get(string);
            if (v == null) continue;
            return (String)v;
        }
        return string;
    }
}

