#!/bin/sh
#
# Emergency jailbreak check script

_FUNCTIONS=/etc/rc.d/functions
[ -f ${_FUNCTIONS} ] && . ${_FUNCTIONS}

# Hack specific config
HACKLOG="/mnt/us/jb_emergency.log"

# Log
msg "running jb emergency script" I

# The goal here is to check that we're really in a vanilla state, to verify that our custom hacks properly stopped
echo "** JailBreak Check **" > ${HACKLOG}

# We start by checking the process list...
echo "** Process list:" >> ${HACKLOG}
ps faux >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

# Then the mtab
echo "** MTab:" >> ${HACKLOG}
cat /etc/mtab >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

# And df -h
echo "** Mounted Partitions:" >> ${HACKLOG}
df -h >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

# And the runlevels symlinks
echo "** Runlevels Symlinks:" >> ${HACKLOG}
ls -lash /etc/rc*.d >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

# Then the ss hack state files...
echo "** SS Hack state files:" >> ${HACKLOG}
ls -lash /mnt/us/linkss/ >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

# Check the original directory...
echo "** SS Hack original screensavers check (600x800):" >> ${HACKLOG}
ls -lash /opt/amazon/screen_saver/600x800/ >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

echo "** SS Hack original screensavers check (824x1200):" >> ${HACKLOG}
ls -lash /opt/amazon/screen_saver/824x1200/ >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

# The ss hack pidfiles...
echo "** SS Hack pidfiles:" >> ${HACKLOG}
ls -lash /mnt/us/linkss/run/ >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

# In detail, if there's one...
if [ -f /mnt/us/linkss/run/usb-watchdog.pid ] ; then
    echo "** SS Hack pidfiles (usb-watchdog.pid):" >> ${HACKLOG}
    cat /mnt/us/linkss/run/usb-watchdog.pid >> ${HACKLOG} 2>&1
    echo "" >> ${HACKLOG}
fi

# The ss viewer dir, if it exists
if [ -d /mnt/us/pictures/ssviewer ] ; then
    echo "** SS Hack ssviewer:"
    ls -lash /mnt/us/pictures/ssviewer/ >> ${HACKLOG} 2>&1
    echo "" >> ${HACKLOG}
fi

# We continue with the fonts hack...
echo "** Fonts Hack state files:" >> ${HACKLOG}
ls -lash /mnt/us/linkfonts/ >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

# The font hack pidfiles...
echo "** Font Hack pidfiles:" >> ${HACKLOG}
ls -lash /mnt/us/linkfonts/run/ >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

# In detail, if there's one...
if [ -f /mnt/us/linkfonts/run/usb-watchdog.pid ] ; then
    echo "** Font Hack pidfiles (usb-watchdog.pid):" >> ${HACKLOG}
    cat /mnt/us/linkfonts/run/usb-watchdog.pid >> ${HACKLOG} 2>&1
    echo "" >> ${HACKLOG}
fi

# The original fonts dir
echo "** Fonts Hack original fonts dir:" >> ${HACKLOG}
ls -lash /usr/java/lib/fonts/ >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

# The original reader font config
echo "** Fonts Hack original font.properties:" >> ${HACKLOG}
cat /usr/java/lib/font.properties >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

# The original browser font config, if it exists
if [ -f /opt/amazon/ebook/config/netfront.ini ] ; then
    echo "** Fonts Hack original netfront.ini:" >> ${HACKLOG}
    cat /opt/amazon/ebook/config/netfront.ini >> ${HACKLOG} 2>&1
    echo "" >> ${HACKLOG}
fi

# The default fontconfig cache timestamp, if it exists
if [ -f /usr/var/cache/fontconfig/f394b45e7a2716944ea2c0aeb5c008aa-arm.cache-2 ] ; then
    echo "** Original fontconfig cache timestamp:" >> ${HACKLOG}
    ls -lash /usr/var/cache/fontconfig/f394b45e7a2716944ea2c0aeb5c008aa-arm.cache-2 >> ${HACKLOG} 2>&1
    echo "" >> ${HACKLOG}
fi

# The original fonts.conf, if it exists
if [ -f /etc/fonts/fonts.conf ] ; then
    echo "** Original fonts.conf:" >> ${HACKLOG}
    cat /etc/fonts/fonts.conf >> ${HACKLOG} 2>&1
    echo "" >> ${HACKLOG}
fi

# The original local.conf, if it exists
if [ -f /etc/fonts/local.conf ] ; then
    echo "** Original local.conf:" >> ${HACKLOG}
    cat /etc/fonts/local.conf >> ${HACKLOG} 2>&1
    echo "" >> ${HACKLOG}
fi

# The update package private keys
echo "** Checking private keys..." >> ${HACKLOG}
echo "" >> ${HACKLOG}
for keyfile in /etc/uks/*.pem ; do
	echo "** ${keyfile} **" >> ${HACKLOG}
	cat ${keyfile} >> ${HACKLOG} 2>&1
	echo "" >> ${HACKLOG}
done
echo "" >> ${HACKLOG}

# The jailbreak
echo "** Checking jailbreak..." >> ${HACKLOG}
if [ -f /etc/init.d/jailbreak ] ; then
	echo "** found yifanlu's jailbreak **"
	cat /etc/init.d/jailbreak >> ${HACKLOG} 2>&1
	echo "" >> ${HACKLOG}
fi
if [ -f /etc/init.d/linkjail ] ; then
	echo "** found NiLuJe's jailbreak **"
	cat /etc/init.d/linkjail >> ${HACKLOG} 2>&1
	echo "" >> ${HACKLOG}
fi
echo "" >> ${HACKLOG}

# The otaup script...
echo "** Checking otaup..." >> ${HACKLOG}
cat /usr/sbin/otaup >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

# And we finish by the prettyversion
echo "** PrettyVersion:" >> ${HACKLOG}
cat /etc/prettyversion.txt >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

# Done!
echo "Done!" >> ${HACKLOG}

return 0
