/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ops;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.ops.OPSHandler;
import com.adobe.epubcheck.util.EpubTypeAttributes;
import com.adobe.epubcheck.util.HandlerUtil;
import com.adobe.epubcheck.util.Messages;
import com.adobe.epubcheck.util.MetaUtils;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLParser;
import java.util.HashSet;
import java.util.Set;

public class OPSHandler30
extends OPSHandler {
    String properties;
    HashSet<String> prefixSet;
    HashSet<String> propertiesSet;
    String mimeType;
    boolean video = false;
    boolean audio = false;
    boolean hasValidFallback = false;
    int imbricatedObjects = 0;
    int imbricatedCanvases = 0;
    public static HashSet<String> linkClassSet;
    boolean reportedUnsupportedXMLVersion;

    public OPSHandler30(String path, String mimeType, String properties, XRefChecker xrefChecker, XMLParser parser, Report report) {
        super(path, xrefChecker, parser, report);
        this.mimeType = mimeType;
        this.properties = properties;
        this.prefixSet = new HashSet();
        this.propertiesSet = new HashSet();
        this.reportedUnsupportedXMLVersion = false;
    }

    boolean checkPrefix(String prefix) {
        if (!this.prefixSet.contains(prefix = prefix.trim())) {
            this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "Undecleared prefix: " + prefix);
            return false;
        }
        return true;
    }

    private void checkType(String type) {
        if (type == null) {
            return;
        }
        MetaUtils.validateProperties(type, EpubTypeAttributes.EpubTypeSet, this.prefixSet, this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), this.report, false);
    }

    private void checkSSMLPh(String ph) {
        if (ph == null) {
            return;
        }
        if (ph.trim().length() < 1) {
            this.report.warning(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "Empty or whitespace-only value of attribute ssml:ph");
        }
    }

    @Override
    public void characters(char[] chars, int arg1, int arg2) {
        super.characters(chars, arg1, arg2);
        String str = new String(chars, arg1, arg2);
        str = str.trim();
        if (!str.equals("") && (this.audio || this.video || this.imbricatedObjects > 0 || this.imbricatedCanvases > 0)) {
            this.hasValidFallback = true;
        }
    }

    @Override
    public void startElement() {
        XMLElement e;
        String name;
        super.startElement();
        if (!this.reportedUnsupportedXMLVersion) {
            this.reportedUnsupportedXMLVersion = HandlerUtil.checkXMLVersion(this.parser);
        }
        if ((name = (e = this.parser.getCurrentElement()).getName()).equals("html")) {
            HandlerUtil.processPrefixes(e.getAttributeNS("http://www.idpf.org/2007/ops", "prefix"), this.prefixSet, this.report, this.path, this.parser.getLineNumber(), this.parser.getColumnNumber());
        } else if (name.equals("link")) {
            this.processLink(e);
        } else if (name.equals("object")) {
            this.processObject(e);
        } else if (name.equals("math")) {
            this.propertiesSet.add("mathml");
        } else if (!this.mimeType.equals("image/svg+xml") && name.equals("svg")) {
            this.propertiesSet.add("svg");
        } else if (name.equals("script")) {
            this.propertiesSet.add("scripted");
        } else if (name.equals("switch")) {
            this.propertiesSet.add("switch");
        } else if (name.equals("audio")) {
            this.processAudio(e);
        } else if (name.equals("video")) {
            this.processVideo(e);
        } else if (name.equals("canvas")) {
            this.processCanvas(e);
        } else if (name.equals("img")) {
            this.processImg(e);
        }
        this.processSrc(e.getName(), e.getAttribute("src"));
        this.checkType(e.getAttributeNS("http://www.idpf.org/2007/ops", "type"));
        this.checkSSMLPh(e.getAttributeNS("http://www.w3.org/2001/10/synthesis", "ph"));
    }

    private void processLink(XMLElement e) {
        String classAttribute = e.getAttribute("class");
        if (classAttribute == null) {
            return;
        }
        Set<String> values = MetaUtils.validateProperties(classAttribute, linkClassSet, null, this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), this.report, false);
        if (values.size() == 1) {
            return;
        }
        boolean vertical = false;
        boolean horizontal = false;
        boolean day = false;
        boolean night = false;
        for (String attribute : values) {
            if (attribute.equals("vertical")) {
                vertical = true;
                continue;
            }
            if (attribute.equals("horizontal")) {
                horizontal = true;
                continue;
            }
            if (attribute.equals("day")) {
                day = true;
                continue;
            }
            if (!attribute.equals("night")) continue;
            night = true;
        }
        if (vertical && horizontal || day && night) {
            this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), Messages.CONFLICTING_ATTRIBUTES + classAttribute);
        }
    }

    private void processImg(XMLElement e) {
        if (this.audio || this.video || this.imbricatedObjects > 0 || this.imbricatedCanvases > 0) {
            this.hasValidFallback = true;
        }
    }

    private void processCanvas(XMLElement e) {
        ++this.imbricatedCanvases;
    }

    private void processAudio(XMLElement e) {
        this.audio = true;
    }

    private void processVideo(XMLElement e) {
        this.video = true;
        String posterSrc = e.getAttribute("poster");
        String posterMimeType = null;
        if (this.xrefChecker != null && posterSrc != null) {
            posterMimeType = this.xrefChecker.getMimeType(PathUtil.resolveRelativeReference(this.path, posterSrc, this.base));
        }
        if (posterMimeType != null && !OPFChecker.isBlessedImageType(posterMimeType)) {
            this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "Video poster must have core media image type");
        }
        if (posterSrc != null) {
            this.hasValidFallback = true;
            this.processSrc(e.getName(), posterSrc);
        }
    }

    private void processSrc(String name, String src) {
        if (src != null) {
            src.trim();
            if (src.equals("")) {
                this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "The src attribute must not be empty");
            }
        }
        if (src == null || this.xrefChecker == null) {
            return;
        }
        if (src.startsWith("http://")) {
            this.propertiesSet.add("remote-resources");
        } else {
            src = PathUtil.resolveRelativeReference(this.path, src, this.base);
        }
        this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), src, 0);
        String srcMimeType = this.xrefChecker.getMimeType(src);
        if (srcMimeType == null) {
            return;
        }
        if (!this.mimeType.equals("image/svg+xml") && srcMimeType.equals("image/svg+xml")) {
            this.propertiesSet.add("svg");
        }
        if ((this.audio || this.video || this.imbricatedObjects > 0 || this.imbricatedCanvases > 0) && OPFChecker30.isCoreMediaType(srcMimeType) && !name.equals("track")) {
            this.hasValidFallback = true;
        }
    }

    private void processObject(XMLElement e) {
        ++this.imbricatedObjects;
        String type = e.getAttribute("type");
        String data = e.getAttribute("data");
        if (data != null) {
            this.processSrc(e.getName(), data);
            data = PathUtil.resolveRelativeReference(this.path, data, this.base);
        }
        if (type != null && data != null && this.xrefChecker != null && !type.equals(this.xrefChecker.getMimeType(data))) {
            this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "Object type and the item media-type declared in manifest, do not match");
        }
        if (type != null) {
            if (!this.mimeType.equals("image/svg+xml") && type.equals("image/svg+xml")) {
                this.propertiesSet.add("svg");
            }
            if (OPFChecker30.isCoreMediaType(type)) {
                this.hasValidFallback = true;
            }
        }
        if (this.hasValidFallback) {
            return;
        }
        if (this.xrefChecker != null && this.xrefChecker.getBindingHandlerSrc(type) != null) {
            this.hasValidFallback = true;
        }
    }

    @Override
    public void endElement() {
        super.endElement();
        XMLElement e = this.parser.getCurrentElement();
        String name = e.getName();
        if (this.openElements == 0L && (name.equals("html") || name.equals("svg"))) {
            this.checkProperties();
        } else if (name.equals("object")) {
            --this.imbricatedObjects;
            if (this.imbricatedObjects == 0 && this.imbricatedCanvases == 0) {
                this.checkFallback("Object");
            }
        } else if (name.equals("canvas")) {
            --this.imbricatedCanvases;
            if (this.imbricatedObjects == 0 && this.imbricatedCanvases == 0) {
                this.checkFallback("Canvas");
            }
        } else if (name.equals("video")) {
            if (this.imbricatedObjects == 0 && this.imbricatedCanvases == 0) {
                this.checkFallback("Video");
            }
            this.video = false;
        } else if (name.equals("audio")) {
            if (this.imbricatedObjects == 0 && this.imbricatedCanvases == 0) {
                this.checkFallback("Audio");
            }
            this.audio = false;
        }
    }

    private void checkFallback(String elementType) {
        if (this.hasValidFallback) {
            this.hasValidFallback = false;
        } else {
            this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), elementType + " element doesn't provide fallback");
        }
    }

    private void checkProperties() {
        if (this.properties != null && this.properties.equals("singleFileValidation")) {
            return;
        }
        if (this.properties != null) {
            this.properties = this.properties.replaceAll("nav", "");
            this.properties = this.properties.replaceAll("cover-image", "");
        }
        for (String prop : this.propertiesSet) {
            if (this.properties != null && this.properties.contains(prop)) {
                this.properties = this.properties.replaceAll(prop, "");
                continue;
            }
            this.report.error(this.path, 0, 0, "This file should declare in opf the property: " + prop);
        }
        if (this.properties != null) {
            this.properties = this.properties.trim();
        }
        if (this.properties != null && !this.properties.equals("")) {
            this.report.error(this.path, 0, 0, "This file should not declare in opf the properties: " + this.properties);
        }
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("vertical");
        set.add("horizontal");
        set.add("day");
        set.add("night");
        linkClassSet = set;
    }
}

