/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.ocf.EncryptionFilter;
import com.adobe.epubcheck.ocf.OCFPackage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class OCFZipPackage
extends OCFPackage {
    ZipFile zip;

    public OCFZipPackage(ZipFile zip) {
        this.zip = zip;
    }

    @Override
    public boolean hasEntry(String name) {
        return this.zip.getEntry(name) != null;
    }

    @Override
    public InputStream getInputStream(String name) throws IOException {
        ZipEntry entry = this.zip.getEntry(name);
        if (entry == null) {
            return null;
        }
        InputStream in = this.zip.getInputStream(entry);
        EncryptionFilter filter = (EncryptionFilter)this.enc.get(name);
        if (filter == null) {
            return in;
        }
        if (filter.canDecrypt()) {
            return filter.decrypt(in);
        }
        return null;
    }

    @Override
    public HashSet<String> getFileEntries() throws IOException {
        HashSet<String> entryNames = new HashSet<String>();
        Enumeration<? extends ZipEntry> entries = this.zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            entryNames.add(entry.getName());
        }
        return entryNames;
    }

    @Override
    public HashSet<String> getDirectoryEntries() throws IOException {
        HashSet<String> entryNames = new HashSet<String>();
        Enumeration<? extends ZipEntry> entries = this.zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.isDirectory()) continue;
            entryNames.add(entry.getName());
        }
        return entryNames;
    }
}

