/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ocf.EncryptionFilter;
import com.adobe.epubcheck.ocf.OCFData;
import com.adobe.epubcheck.ocf.OCFHandler;
import com.adobe.epubcheck.opf.OPFData;
import com.adobe.epubcheck.opf.OPFHandler;
import com.adobe.epubcheck.opf.VersionRetriever;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.GenericResourceProvider;
import com.adobe.epubcheck.util.InvalidVersionException;
import com.adobe.epubcheck.xml.XMLParser;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Hashtable;

public abstract class OCFPackage
implements GenericResourceProvider {
    Hashtable<String, EncryptionFilter> enc = new Hashtable();
    String uniqueIdentifier;

    public void setEncryption(String name, EncryptionFilter encryptionFilter) {
        this.enc.put(name, encryptionFilter);
    }

    public abstract boolean hasEntry(String var1);

    @Override
    public abstract InputStream getInputStream(String var1) throws IOException;

    public abstract HashSet<String> getFileEntries() throws IOException;

    public abstract HashSet<String> getDirectoryEntries() throws IOException;

    public boolean canDecrypt(String fileName) {
        EncryptionFilter filter = this.enc.get(fileName);
        if (filter == null) {
            return true;
        }
        return filter.canDecrypt();
    }

    public OCFData getOcfData(Report reporter) {
        XMLParser containerParser = null;
        InputStream in = null;
        try {
            in = this.getInputStream("META-INF/container.xml");
            containerParser = new XMLParser(in, "META-INF/container.xml", "xml", reporter, null);
            OCFHandler containerHandler = new OCFHandler(containerParser);
            containerParser.addXMLHandler(containerHandler);
            containerParser.process();
            OCFHandler oCFHandler = containerHandler;
            return oCFHandler;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e2) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPFData getOpfData(OCFData container, Report reporter) throws InvalidVersionException, IOException {
        InputStream inv = null;
        InputStream inp = null;
        try {
            String path = container.getRootPath();
            inv = this.getInputStream(path);
            EPUBVersion version = new VersionRetriever(path, reporter).retrieveOpfVersion(inv);
            inp = this.getInputStream(path);
            XMLParser opfParser = new XMLParser(new BufferedInputStream(inp), path, "opf", reporter, version);
            OPFHandler oPFHandler = new OPFHandler(this, path, reporter, new XRefChecker(this, reporter, version), opfParser, version);
            return oPFHandler;
        }
        finally {
            try {
                inv.close();
                inp.close();
            }
            catch (Exception e) {}
        }
    }
}

