/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.css;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.css.CSSHandler;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.helpers.ParserFactory;

public class CSSChecker
implements ContentChecker {
    private OCFPackage ocf;
    private Report report;
    private String path;
    private XRefChecker xrefChecker;
    private EPUBVersion version;
    private static final String SAC_PROPERTY = "org.w3c.css.sac.parser";

    public CSSChecker(OCFPackage ocf, Report report, String path, XRefChecker xrefChecker, EPUBVersion version) {
        this.ocf = ocf;
        this.report = report;
        this.path = path;
        this.xrefChecker = xrefChecker;
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runChecks() {
        InputStream is = null;
        try {
            if (!this.ocf.hasEntry(this.path)) {
                this.report.error(null, 0, 0, String.format(Messages.MISSING_FILE, this.path));
                return;
            }
            String systemProp = System.getProperty(SAC_PROPERTY);
            if (systemProp == null || systemProp.length() < 1) {
                System.setProperty(SAC_PROPERTY, "org.apache.batik.css.parser.Parser");
            }
            ParserFactory pf = new ParserFactory();
            Parser parser = pf.makeParser();
            CSSHandler ch = new CSSHandler(this.path, this.xrefChecker, this.report, this.version);
            parser.setDocumentHandler((DocumentHandler)ch);
            parser.setErrorHandler((ErrorHandler)ch);
            InputSource input = new InputSource();
            is = this.ocf.getInputStream(this.path);
            input.setByteStream(is);
            input.setURI(this.path);
            parser.parseStyleSheet(input);
        }
        catch (Exception e) {
            this.report.error(this.path, -1, 0, e.getMessage());
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    class NullOutputStream
    extends OutputStream {
        NullOutputStream() {
        }

        @Override
        public void write(int arg0) throws IOException {
        }
    }
}

