//var style;
//var STYLES = ["eraser", "sketchy", "shaded", "chrome", "fur", "longfur", "web", "", "drunk_master", "squares", "ribbon", "koch", "", "circles", "grid"];
//var compositeTypes = [ 'source-over','source-in','source-out','source-atop', 'destination-over','destination-in','destination-out','destination-atop', 'lighter','darker','copy','xor' ];


var SCREEN_WIDTH  = window.innerWidth;
var SCREEN_HEIGHT = window.innerHeight;

//var menu, selector, option;
var brush_shop = null; // all brushes

var canvas;
var context;
var hist = null;
var mouseX = 0;
var mouseY = 0;

var isMouseDown = false;
var isMouseOnCanvas = false;

// current brush alias
function brush()
{
    return brush_shop.brushObj();
}

function el(the_id) 
{
    return document.getElementById(the_id);
}

init();

function init() 
{
    canvas = el("the-canvas"); 
    canvas.width = SCREEN_WIDTH;
    canvas.height = SCREEN_HEIGHT;
    canvas.style.cursor = "crosshair";
    context = canvas.getContext("2d");
    clearCanvas( 255, 255, 255, 1 );

    el("the-save").addEventListener("click", onSave, false);
    el("the-clear").addEventListener("click", onClear, false);
    el("publish").addEventListener("click", onPublish, false);
    el("the-opacity").addEventListener("change", onOpacityChange, false);
    el("the-line-width").addEventListener("change", onLineWidthChange, false);
    el("the-composite-op").addEventListener("change", onCompositeOpChange, false);
    el("the-undo").addEventListener("click", onUndo, false);
    el("the-redo").addEventListener("click", onRedo, false);
    el("the-color").addEventListener("change", onColorChange, false);
   
    // set publish
    if( -1 == window.location.hostname.indexOf( "romakhin.ru" ) )
    {
        el( "publish" ).setAttribute( "title", "Can not publish in offline version" );
        el( "publish" ).setAttribute( "disabled", "true" );
    }
    
    hist = new History( getCurrentImg() ); // default history state
    
    brush_shop = new Brush_Shop( el("the-brush-shop") );
    var section_eraser = brush_shop.addSection( "main" );
    var section_1 = brush_shop.addSection( "1" );
    var section_2 = brush_shop.addSection( "2" );
    var section_3 = brush_shop.addSection( "3" );
    
    section_eraser.addBrush( new eraser(context, 7), "eraser", "Erase it all!" );
    section_eraser.addBrush( new eraser(context, 13), "eraser+", "Eraser, bigger size!" );
    
    section_1.addBrush( new sketchy(context), "sketchy", "" );
    section_1.addBrush( new shaded(context), "shaded", "" );
    section_1.addBrush( new chrome(context), "chrome", "" );
    section_1.addBrush( new web(context), "web", "" );
    section_1.addBrush( new fur(context), "fur", "" );
    section_1.addBrush( new longfur(context), "longfur", "" );

    section_2.addBrush( new drunk_master(context), "drunk", "Power of drunk master style." );
    section_2.addBrush( new squares(context), "squares", "Just stupid squares" );
    section_2.addBrush( new ribbon(context), "ribbon", "Just stupid ribbon." );
    section_2.addBrush( new koch(context), "koch", "Koch snowflakes" );

    section_3.addBrush( new circles(context), "circles", "" );
    section_3.addBrush( new grid(context), "grid", "" );
    
    if( !darker_supported )
    {
        el("the-composite-op").remove(3);
        el("the-composite-op").size--;
    }

    if( window.location.hash ) 
    {
        var hash = window.location.hash.substr(1, window.location.hash.length);
        brush_shop.uiSelect( hash );
    }
    
    if( !brush_shop.brush )
    {
        brush_shop.uiSelect( "sketchy" );
    }

    document.onmousedown = onDocumentMouseDown;
    document.onmousemove = onDocumentMouseMove;
    //document.onmouseout  = onDocumentMouseOut;
    
    canvas.onmouseout   = onCanvasMouseOut;
    canvas.onmouseover  = onCanvasMouseOver;
    
    canvas.onmouseup    = onCanvasMouseUp;
    canvas.onmousedown  = onCanvasMouseDown;
    canvas.onmousemove  = onCanvasMouseMove;
    
    canvas.ontouchstart = onCanvasTouchStart;
    canvas.ontouchend   = onCanvasTouchEnd;
    canvas.ontouchmove  = onCanvasTouchMove

    document.onkeydown  = onKey;
}



function updateUndoRedo()
{
    if( hist )
    {
        el("the-undo").disabled = !hist.can_undo();
        el("the-redo").disabled = !hist.can_redo();
    }
}

/*
// translate document mouse move to canvas coord
function translateCoodX( e )
{

}

function translateCoodY( e )
{
}
*/

function pageX(elem) 
{
       return elem.offsetParent ?
               elem.offsetLeft + pageX( elem.offsetParent ) :
               elem.offsetLeft;
}

//     
function pageY(elem) 
{
       return elem.offsetParent ?
               elem.offsetTop + pageY( elem.offsetParent ) :
               elem.offsetTop;
}

function getCurrentImg()
{
    return context.getImageData(0, 0, canvas.width, canvas.height);
}

function historySaveCurrent()
{
    hist.save( getCurrentImg() );
}

function historyRestoreCurrent() // restore current img to screen
{
    context.putImageData( hist.curr(), 0, 0 );
}


// for clear panel: update local color-picker
function setBackgroundClr( v )
{
    el("the-color-background").color.fromString(v)
}

function showClearConfirm( mode )
{
    el("the-color-background").color.hidePicker();
    el("the-clear-confirm").style.display = mode ? "block" : "none";
}

function clearCanvas( r, g, b, a )
{
    context.globalCompositeOperation = "source-over";
    context.fillStyle = color_str( r, g, b, a );
    context.fillRect( 0, 0, canvas.width, canvas.height );
}

// ---------------------------------------------------------On settings change

function onOpacityChange(e) 
{
    curr_opacity = el("the-opacity").value;
    brush_shop.resetAll();
}

function onLineWidthChange(e) 
{
    curr_line_width = el("the-line-width").value;
    brush_shop.resetAll();
}

function onCompositeOpChange(e)
{   
    curr_composite_op = el("the-composite-op").value;
    brush_shop.resetAll();
}

function onColorChange()
{
    var o = el("the-color");
    curr_color_r = Math.round(this.color.rgb[0]*255);
    curr_color_g = Math.round(this.color.rgb[1]*255);
    curr_color_b = Math.round(this.color.rgb[2]*255);
    brush_shop.resetAll();
}

// ---------------------------------------------------------On settings change [end]

// ---------------------------------------------------------On events

function onBrushChanged( bShop, brushDesc )
{
    var brush = brushDesc.brushObj;
    canvas.style.cursor = (typeof(brush.cursor) == "string") ? brush.cursor : "crosshair";
    window.location.hash = brushDesc.name;

    brush_shop.resetAll();
}


function onDocumentMouseDown(a) 
{
    return !isMouseOnCanvas;
}

function onDocumentMouseMove(a) 
{
    return !isMouseOnCanvas;
}

function onDocumentMouseOut(a) 
{
    return false;
}

function onCanvasMouseDown(a) 
{
    el("the-color").color.hidePicker();
    
    isMouseDown = true;
    brush_shop.brushObj().strokeStart(mouseX, mouseY);
    
    return false;
}

function onCanvasMouseOut(a) 
{
    isMouseOnCanvas = false;
    
    if( isMouseDown )
        onCanvasMouseUp( a );
}

function onCanvasMouseOver(a) 
{
    isMouseOnCanvas = true;
}

function onCanvasMouseUp(a) 
{
    isMouseDown = false;
    brush_shop.brushObj().strokeEnd(mouseX, mouseY);
    
    historySaveCurrent();
    updateUndoRedo();
}

function onCanvasMouseMove(a) 
{
    if (!a) 
    {
        a = window.event;
    }

    //mouseX = a.offsetX + (a.clientX - a.x); //a.clientX;
    //mouseY = a.offsetY + (a.clientY - a.y); //a.clientY;
    mouseX = (a.pageX - pageX(a.target));
    mouseY = (a.pageY - pageY(a.target));

    if (!isMouseDown) { return }

    brush_shop.brushObj().stroke(mouseX, mouseY);
    //style.stroke(mouseX, mouseY);
    
    return true;
}

function onCanvasTouchStart(a) 
{
    if (a.touches.length == 1) 
    {
        var b = a.touches[0];
        //var x = b.offsetX + (b.clientX - b.x);
        //var y = b.offsetY + (b.clientY - b.y);
        var x = (b.pageX - pageX(b.target));
        var y = (b.pageY - pageY(b.target));
        brush_shop.brushObj().strokeStart(x, y);
        //style.strokeStart(x, y);
    }
}

function onCanvasTouchEnd(a) 
{
    if (a.touches.length == 1) 
    {
        var b = a.touches[0];
        //var x = b.offsetX + (b.clientX - b.x);
        //var y = b.offsetY + (b.clientY - b.y);
        var x = (b.pageX - pageX(b.target));
        var y = (b.pageY - pageY(b.target));
        brush_shop.brushObj().strokeEnd(x, y);
        //style.strokeEnd(x, y)
        
        historySaveCurrent();
        updateUndoRedo();
    }
}

function onCanvasTouchMove(a) 
{
    if (a.touches.length == 1) 
    {
        var b = a.touches[0];
        //var x = b.offsetX + (b.clientX - b.x);
        //var y = b.offsetY + (b.clientY - b.y);
        var x = (b.pageX - pageX(b.target));
        var y = (b.pageY - pageY(b.target));
        brush_shop.brushObj().stroke(x, y);
        //style.stroke(x, y)
    }
}

function onKey(a) 
{
    if (!a) var a = window.event;

    if( a.keyCode == 27 ) // ESC
    {
        el("the-color").color.hidePicker();
        showClearConfirm( false ); 
        return false;
    }

    if (a.ctrlKey || a.shiftKey) 
    {
        if (a.keyCode == 90) // Z 
        {
            onUndo();
            return false;
        }
        else if (a.keyCode == 89) // Y 
        {
            onRedo();
            return false;
        }
        else if( a.keyCode == 83 ) // S
        {
            onSave();
            //a.preventDefault();
            return false;
        }
    }

    return true;
}

function onUndo() 
{
    if( hist.undo() )
    {
        historyRestoreCurrent();
        updateUndoRedo();
        brush_shop.resetAll();
    }
}

function onRedo() 
{
    if( hist.redo() )
    {
        historyRestoreCurrent();
        updateUndoRedo();
        brush_shop.resetAll();
    }
}

function onSave() 
{
    window.open(canvas.toDataURL("image/png"), "mywindow");
}

function onClear() 
{
    showClearConfirm( true );
}

function onPublish() 
{
    el("publish_data").value = canvas.toDataURL("image/png");
    el("publish_form").submit();
}

// on clear canvas
function onClearOk()
{
    var o = el("the-color-background");

    var r = Math.round(o.color.rgb[0] * 255);
    var g = Math.round(o.color.rgb[1] * 255);
    var b = Math.round(o.color.rgb[2] * 255);
    
    curr_color_bg_r = r;
    curr_color_bg_g = g;
    curr_color_bg_b = b;
    
    clearCanvas( r, g, b, 1 );
    
    showClearConfirm( false );
    
    historySaveCurrent();
    updateUndoRedo();
    brush_shop.resetAll();
}

// ---------------------------------------------------------On events [end]





