
//-----------------------------------------------------------Brush_Desc
function Brush_Desc( parent, brushObj, name, desc, uiObj )
{
    this.init( parent, brushObj, name, desc, uiObj );
}

Brush_Desc.prototype = 
{
    parent: null, 
    brushObj: null,
    name: null,
    desc: null,
    uiObj: null,
    
    init: function( parent, brushObj, name, desc, uiObj )
    {
        this.brushObj = brushObj;
        this.name = name;
        this.desc = desc;
        this.uiObj = uiObj;
    },
    
    uiSelect: function()
    {
        this.uiObj.setAttribute( "checked", "true" );
    },
    
    reset: function()
    {
        this.brushObj.reset();
    },
};


//-----------------------------------------------------------Brush_Section
function Brush_Section( parent, name, uiObj )
{
    this.init( parent, name, uiObj );
}

Brush_Section.prototype = 
{
    parent: null,
    name: null,
    uiObj: null,
    brushes: null,
    
    init: function( parent, name, uiObj )
    {
        this.parent = parent;
        this.name = name;
        this.uiObj = uiObj;
        this.brushes = new Array();
    },
    
    getBrush: function( name )
    {
        for( var i in this.brushes )
        {
            if( this.brushes[i].name == name ) 
                return this.brushes[i];
        }
        
        return null;
    },
    
    addBrush: function( brushObj, name, desc )
    {
        var b = this.getBrush( name );
        if( !b )
        {
            var el_label = document.createElement("label");
            
            el_label.appendChild( document.createTextNode(name) );
            if(desc) el_label.setAttribute( "title", desc )
            el_label.setAttribute( "unselectable", "on" )

            b = new Brush_Desc( this, brushObj, name, desc, el_label );
            var parentRef = this.parent;
            
            el_label.onmousedown = function() 
            {
                if( parentRef.brush.uiObj )
                    parentRef.brush.uiObj.removeAttribute( "checked" );
                parentRef.brush = b;
                this.setAttribute( "checked", "true" ); 
                if( onBrushChanged ) 
                    onBrushChanged( parentRef, b ); 
                return true;
            }

            this.uiObj.appendChild( el_label );
            
            this.brushes.push( b );
        }
    },
    
    uiSelect: function( name )
    {
        var b = this.getBrush( name );
        
        if( b ) 
        {
            this.parent.brush = b;
            b.uiSelect();
            if( onBrushChanged ) onBrushChanged( this.parent, b );
        }
        
        //alert( [this.name, name, b!=null] );
        
        return b != null;
    },
    
    resetAll: function()
    {
        for( var i in this.brushes )
        {
            this.brushes[i].reset();
        }
    },
};

//-----------------------------------------------------------Brush_Shop
function Brush_Shop( uiObj )
{
    this.init( uiObj );
}

Brush_Shop.prototype = 
{
    brush: null,
    uiObj: null,
    sections: null,
    
    init: function( uiObj )
    {
        this.uiObj = uiObj;
        this.sections = new Array();
    },
        
    getSection: function( name )
    {
        for( var i in this.sections )
        {
            if( this.sections[i].name == name )
            {
                return this.sections[i];
            }
        }
        
        return null;
    },
    
    addSection: function( name )
    {
        var s = this.getSection( name );

        if( s == null ) // add new section
        {
            var uiObj = document.createElement( "div" );
            uiObj.setAttribute( "class", "brush-section" );
            uiObj.setAttribute( "id", "the-brush-section-"+name )
            this.uiObj.appendChild( uiObj );
        
            s = new Brush_Section( this, name, uiObj );
            this.sections.push( s );
        }
        
        return s;
    },
    
    brushObj: function()
    {
        return this.brush ? this.brush.brushObj : null;
    },
    
    uiSelect: function( name )
    {
        for( var i in this.sections )
        {
            if( this.sections[i].uiSelect( name ) )
            {
                return true;
            }
        }

        return false;
    },
    
    resetAll: function()
    {
        for( var i in this.sections )
        {
            this.sections[i].resetAll();
        }
    },
};