//compile with tccmake gui -lpthread
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <pthread.h>
#include <string.h>

#define WIDTH 600
#define HEIGHT 800
#define STRIDE 608

#define FRAME_BUFFER "/dev/fb0"
#define TOUCH_SCREEN "/dev/input/event3"

#define PAUSE_FRAMEWORK "killall -STOP Xorg cvm"
#define RESUME_FRAMEWORK "killall -CONT cvm Xorg"

#define UP 0
#define DOWN 1

#define BUFFER_SIZE PIPE_BUF  
#define MESSAGE_SIZE 5000  
#define NAME_SIZE 256  
  
char buf[10240];
const char* FIFO="/tmp/mpgui.fifo";
int client_fifo_fd=0;

void update(int refresh);
void draw_grid(unsigned char *frame_buffer);
void check(int x,int y);

void *update_thread(void *running) {
    while(*(int *)running) {
        //update(0);
        memset(buf,0,sizeof buf);
        int res = read(client_fifo_fd, &buf, sizeof(buf));  
    		if (res > 0)  
    		{  
       		printf("%s", buf);  
       		if(strstr(buf,"Playing")){
       			system("/mnt/us/extensions/mplayer/mplayer.sh mute");
    			}
    		}
        usleep(1000000 / 60);
    }
}

int main(int argc, char **argv) {
    int frame_buffer_fd = 0;
    int touch_screen_fd = 0;
    unsigned char *frame_buffer = NULL;
    unsigned char event_buffer[16];
    
    /* First finger variables */
    int finger = UP;
    int x = 300; 
    int y = 400;
    
    /* Second finger variables */
    int finger2 = UP;
    int x2 = 0;
    int y2 = 0;
    int f2_mode = 0;
    
    int i = 0;
    int j = 0;
    
    /* Threads */
    pthread_t updater = 0;
    int running = 1;
    
    int sync = 0;


    /* Pause the Kindle framework */
    system(PAUSE_FRAMEWORK);

    /* Open files related to the screen */
    frame_buffer_fd = open(FRAME_BUFFER, O_RDWR);
    if(frame_buffer_fd == -1) {
        fprintf(stderr, "Error: Could not open frame buffer.\n");
        exit(EXIT_FAILURE);
    }
    frame_buffer = mmap(0, STRIDE * HEIGHT, PROT_READ | PROT_WRITE, MAP_SHARED, frame_buffer_fd, 0);
    touch_screen_fd = open(TOUCH_SCREEN, O_RDONLY);   
    if(touch_screen_fd == -1) {
        fprintf(stderr, "Error: Could not open touch screen.\n");
        exit(EXIT_FAILURE);
    }

    /* Draw a background */
    draw_grid(frame_buffer);
    update(1);
    
    system("rm /tmp/mpgui.fifo");
    if (mkfifo(FIFO, 0777) == -1)  
    {  
        fprintf(stderr, "Sorry, create fifo failure!/n");  
        exit(EXIT_FAILURE);  
    }  
    client_fifo_fd = open(FIFO, O_RDONLY|O_NONBLOCK);  
		if (client_fifo_fd == -1)  
    {  
        fprintf(stderr, "Sorry, fifo open failure!/n");  
        exit(EXIT_FAILURE);  
    }  
		pthread_create(&updater, NULL, update_thread, (void *)&running);
    /* Loop through touch screen input, writing pretty things to the screen */    
    while(1) {
        read(touch_screen_fd, event_buffer, 16);
        if(event_buffer[0x08] == 0x03) {
            switch(event_buffer[0x0A]) {
                case 0x2F:
                    /* When f2_mode is nonzero, data is treated as being for
                        the second finger */
                    f2_mode = event_buffer[0x0C];
                    break;
                case 0x35:
                    /* X Coordinate change */
                    if(!f2_mode) {
                        x = (WIDTH * (event_buffer[0x0C] + (event_buffer[0x0D] << 8))) / 0x1000;
                    }
                    else {
                        x2 = (WIDTH * (event_buffer[0x0C] + (event_buffer[0x0D] << 8))) / 0x1000;
                    }
                    break;
                case 0x36:
                    /* Y Coordinate change */
                    if(!f2_mode) {
                        y = (HEIGHT * (event_buffer[0x0C] + (event_buffer[0x0D] << 8))) / 0x1000;
                    }
                    else {
                        y2 = (HEIGHT * (event_buffer[0x0C] + (event_buffer[0x0D] << 8))) / 0x1000;
                    }
                    break;
                case 0x39:
                    /* Finger up / down */
                    if(event_buffer[0x0C] == 0x00) {
                        finger = DOWN;
                    }
                    else if(event_buffer[0x0C] == 0x01) {
                        finger2 = DOWN;
                    }
                    else {
                        if(finger2 == DOWN) {
                            finger2 = UP;
                        }
                        else {
                            finger = UP;
                        }
                            
                    }
                    break;
                default:
                    break;
            }
        }
        if(event_buffer[0x08] == 0x00) {
            sync = 1; 
        }
        
        if(sync) { /* We have recieved a sync */
            
            /* If finger 1 is down, draw for it */
            if(finger == DOWN) {
                if(finger2 == UP) {

                }
            }
        
            /* Fingers are up. Did we just push exit / clear? */
            if(finger == UP) { /* Release your finger in the top right to exit */
                if(x > 500 && y < 100) {
                    printf("Exiting.\n");
                    break;
                }
                if(x < 100 && y < 100) { /* Release your finger in the top left 
                                            to clear the screen */
                    draw_grid(frame_buffer);
                    x = 300; 
                    y = 400;
                    
                }
                check(x,y);
            }
        }
        sync = 0;
    }
    
    for(y = 0; y < HEIGHT; y++) {                                             
        for(x = 0; x < WIDTH; x++) {                                                                     
            frame_buffer[x + STRIDE * y] = 255;                                                                                       
        }                                                                     
    }
    update(1);

    running = 0;
    pthread_join(updater, NULL);
	  
    munmap(frame_buffer, STRIDE * HEIGHT);
    close(frame_buffer_fd);
    close(client_fifo_fd);  
    unlink(FIFO); 
    
    /* Resume the Kindle framework */
    
    system("lipc-send-event com.lab126.powerd.debug dbg_power_button_pressed");
    system(RESUME_FRAMEWORK);
    return EXIT_SUCCESS;
}

void update(int refresh) {
    if(refresh) {
        system("eips -f ''");
    }
    else {
        system("eips ''");
    }
}

void draw_rec(unsigned char *frame_buffer,int x1,int x2,int y1,int y2) {
	  int x,y;
    for(y = y1; y < y2; y++) {                                                                                                            
        frame_buffer[x1 + STRIDE * y] = 0;                                                                                       
        frame_buffer[x2-1 + STRIDE * y] = 0;                                                                     
    }
    for(x = x1; x < x2; x++) {                                                                     
        frame_buffer[x + STRIDE * y1] = 0;                                                                                       
        frame_buffer[x + STRIDE * (y2-1)] = 0;                                                                                        
    } 
}

void draw_grid(unsigned char *frame_buffer) {
    int x = 0;
    int y = 0;
    for(y = 0; y < HEIGHT; y++) {                                             
        for(x = 0; x < WIDTH; x++) {                                                                     
            frame_buffer[x + STRIDE * y] = 255;                                                                                       
        }                                                                     
    }
    draw_rec(frame_buffer,0,100,0,100);
    system("eips 1 2 Refresh");
    draw_rec(frame_buffer,500,600,0,100);
    system("eips 43 2 Close");
    draw_rec(frame_buffer,0,600,0,100);
    system("eips 19 2 'MPlayer GUI'");
    
    draw_rec(frame_buffer,50,250,140,200);
    system("eips 8 8 Playall");
		draw_rec(frame_buffer,50,250,220,280);
		system("eips 8 12 Playrand");
		draw_rec(frame_buffer,50,250,300,360);
		system("eips 8 16 Pause");
		draw_rec(frame_buffer,50,250,380,440);
		system("eips 8 20 Stop");
		draw_rec(frame_buffer,50,250,460,520);
		system("eips 8 24 VolDown");
		draw_rec(frame_buffer,350,550,140,200);
    system("eips 34 8 Prev");
		draw_rec(frame_buffer,350,550,220,280);
		system("eips 34 12 Next");
		draw_rec(frame_buffer,350,550,300,360);
		system("eips 34 16 Speed");
		draw_rec(frame_buffer,350,550,380,440);
		system("eips 34 20 Rewind");
		draw_rec(frame_buffer,350,550,460,520);
		system("eips 34 24 VolUp");
		system("eips 23 24 `cat /mnt/us/extensions/mplayer/volume`");
}

void check(int x,int y)
{
	  if(x>=50 && x<=250 && y>=140 && y<=200){
	  	  system("/mnt/us/extensions/mplayer/mplayer.sh playall");
	  }
	  if(x>=50 && x<=250 && y>=220 && y<=280){
	  	  system("/mnt/us/extensions/mplayer/mplayer.sh playrand");
	  }
	  if(x>=50 && x<=250 && y>=300 && y<=360){
	  	  system("/mnt/us/extensions/mplayer/mplayer.sh pause");
	  }
	  if(x>=50 && x<=250 && y>=380 && y<=440)
	  	  system("/mnt/us/extensions/mplayer/mplayer.sh stop");
	  if(x>=50 && x<=250 && y>=460 && y<=520){
	  	  system("/mnt/us/extensions/mplayer/mplayer.sh voldn");
		  system("eips 23 24 `cat /mnt/us/extensions/mplayer/volume`");
          }
	  if(x>=350 && x<=550 && y>=140 && y<=200){
	  	  system("/mnt/us/extensions/mplayer/mplayer.sh prev");
	  }
	  if(x>=350 && x<=550 && y>=220 && y<=280){
	  	  system("/mnt/us/extensions/mplayer/mplayer.sh next");
	  }
	  if(x>=350 && x<=550 && y>=300 && y<=360){
	  	  system("/mnt/us/extensions/mplayer/mplayer.sh speed");
          }
	  if(x>=350 && x<=550 && y>=380 && y<=440){
	  	  system("/mnt/us/extensions/mplayer/mplayer.sh rewind");
          }
	  if(x>=350 && x<=550 && y>=460 && y<=520){
	  	  system("/mnt/us/extensions/mplayer/mplayer.sh volup");
		  system("eips 23 24 `cat /mnt/us/extensions/mplayer/volume`");
	  }
	  
}