#!/bin/sh

old_path_=$(dirname $0)
exe_=$(basename $1)
exe_path_=$(dirname $1)
params_=${@#*${1}}

cd $exe_path_

if [ -z "$exe_" ]                # No argument passed?
then
  echo "Usage: qoqt.sh 'executable_file_name'" ; >>/var/log/messages
  return 1
fi

if [ ! -f "$exe_" ]       # Check if file exists and it is a regular one
then
   echo "goqt: "$exe_" -- regular file does not exist." ; >>/var/log/messages
   exit 1
fi

if [ ! -x "$exe_" ]
then
   echo "goqt: "$exe_" -- not an executable file." ; >>/var/log/messages
   exit 1
fi

if pidof $exe_ >/dev/null
then
    echo "goqt: "$exe_" -- already running." ; >>/var/log/messages
    exit 1
fi

export LD_LIBRARY_PATH=/mnt/us/qtKindle/lib:$exe_path_/lib
export QT_PLUGIN_PATH=/mnt/us/qtKindle/plugins
export QT_QWS_FONTDIR=/mnt/us/qtKindle/lib/fonts

#export QWS_MOUSE_PROTO=KindleFiveWay:keypad
#export QWS_MOUSE_PROTO=KindleFiveWay
export QWS_MOUSE_PROTO=none
export QWS_KEYBOARD=KindleKeyboard
#export QWS_DISPLAY=QKindleFb:flashing
export QWS_DISPLAY=QKindleFb

#echo "goqt: ./$exe_ -qws $params_" >>/var/log/messages
killall -stop cvm 2>/dev/null
"./$exe_" -qws $params_
killall -cont cvm 2>/dev/null

cd $old_path
