/*
 * Copyright (c) 2003, 2007-11 Matteo Frigo
 * Copyright (c) 2003, 2007-11 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 28 11:00:52 EDT 2012 */

#include "codelet-dft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_notw.native -fma -reorder-insns -schedule-for-pipeline -simd -compact -variables 4 -pipeline-latency 8 -n 32 -name n2sv_32 -with-ostride 1 -include n2s.h -store-multiple 4 */

/*
 * This function contains 372 FP additions, 136 FP multiplications,
 * (or, 236 additions, 0 multiplications, 136 fused multiply/add),
 * 194 stack variables, 7 constants, and 144 memory accesses
 */
#include "n2s.h"

static void n2sv_32(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, INT v, INT ivs, INT ovs)
{
     DVK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DVK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DVK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DVK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DVK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     DVK(KP414213562, +0.414213562373095048801688724209698078569671875);
     {
	  INT i;
	  for (i = v; i > 0; i = i - (2 * VL), ri = ri + ((2 * VL) * ivs), ii = ii + ((2 * VL) * ivs), ro = ro + ((2 * VL) * ovs), io = io + ((2 * VL) * ovs), MAKE_VOLATILE_STRIDE(is), MAKE_VOLATILE_STRIDE(os)) {
	       V T61, T62, T63, T64, T65, T66, T67, T68, T69, T6a, T6b, T6c, T6d, T6e, T6f;
	       V T6g, T6h, T6i, T6j, T6k, T6l, T6m, T6n, T6o, T6p, T6q, T6r, T6s, T6t, T6u;
	       V T6v, T6w, T3g, T3f, T6x, T6y, T6z, T6A, T6B, T6C, T6D, T6E, T4p, T49, T4l;
	       V T4j, T6F, T6G, T6H, T6I, T6J, T6K, T6L, T6M, T3n, T3b, T3r, T3l, T3o, T3e;
	       V T4q, T4o, T4k, T4g, T3h, T3p;
	       {
		    V T2T, T3T, T4r, T7, T3t, T1z, T18, T4Z, Te, T50, T1f, T4s, T1G, T3U, T2W;
		    V T3u, Tm, T1n, T3X, T3y, T2Z, T1O, T53, T4w, Tt, T1u, T3W, T3B, T2Y, T1V;
		    V T52, T4z, T3O, T2t, T3L, T2K, TZ, T5F, T4R, T5k, T5j, T4W, T5I, T5X, T2E;
		    V T3M, T2N, T3P, T3H, T22, T3E, T2j, T4G, T5h, TK, T5A, T5D, T5W, T2d, T3F;
		    V T4L, T5g, T3I, T2m;
		    {
			 V T1L, T1j, T1k, T1l, T4v, T1K, T3w;
			 {
			      V T1, T2, T12, T13, T4, T5, T15, T16;
			      T1 = LD(&(ri[0]), ivs, &(ri[0]));
			      T2 = LD(&(ri[WS(is, 16)]), ivs, &(ri[0]));
			      T12 = LD(&(ii[0]), ivs, &(ii[0]));
			      T13 = LD(&(ii[WS(is, 16)]), ivs, &(ii[0]));
			      T4 = LD(&(ri[WS(is, 8)]), ivs, &(ri[0]));
			      T5 = LD(&(ri[WS(is, 24)]), ivs, &(ri[0]));
			      T15 = LD(&(ii[WS(is, 8)]), ivs, &(ii[0]));
			      T16 = LD(&(ii[WS(is, 24)]), ivs, &(ii[0]));
			      {
				   V Tb, T1A, Ta, T1B, T1b, Tc, T1c, T1d;
				   {
					V T8, T1x, T3, T2R, T14, T2S, T6, T1y, T17, T9, T19, T1a;
					T8 = LD(&(ri[WS(is, 4)]), ivs, &(ri[0]));
					T1x = VSUB(T1, T2);
					T3 = VADD(T1, T2);
					T2R = VSUB(T12, T13);
					T14 = VADD(T12, T13);
					T2S = VSUB(T4, T5);
					T6 = VADD(T4, T5);
					T1y = VSUB(T15, T16);
					T17 = VADD(T15, T16);
					T9 = LD(&(ri[WS(is, 20)]), ivs, &(ri[0]));
					T19 = LD(&(ii[WS(is, 4)]), ivs, &(ii[0]));
					T1a = LD(&(ii[WS(is, 20)]), ivs, &(ii[0]));
					Tb = LD(&(ri[WS(is, 28)]), ivs, &(ri[0]));
					T2T = VSUB(T2R, T2S);
					T3T = VADD(T2S, T2R);
					T4r = VSUB(T3, T6);
					T7 = VADD(T3, T6);
					T3t = VSUB(T1x, T1y);
					T1z = VADD(T1x, T1y);
					T18 = VADD(T14, T17);
					T4Z = VSUB(T14, T17);
					T1A = VSUB(T8, T9);
					Ta = VADD(T8, T9);
					T1B = VSUB(T19, T1a);
					T1b = VADD(T19, T1a);
					Tc = LD(&(ri[WS(is, 12)]), ivs, &(ri[0]));
					T1c = LD(&(ii[WS(is, 28)]), ivs, &(ii[0]));
					T1d = LD(&(ii[WS(is, 12)]), ivs, &(ii[0]));
				   }
				   {
					V Ti, T1I, T1J, Tl;
					{
					     V T1h, T1C, T2U, T1D, Td, T1E, T1e, T1i, Tg, Th;
					     Tg = LD(&(ri[WS(is, 2)]), ivs, &(ri[0]));
					     Th = LD(&(ri[WS(is, 18)]), ivs, &(ri[0]));
					     T1h = LD(&(ii[WS(is, 2)]), ivs, &(ii[0]));
					     T1C = VADD(T1A, T1B);
					     T2U = VSUB(T1B, T1A);
					     T1D = VSUB(Tb, Tc);
					     Td = VADD(Tb, Tc);
					     T1E = VSUB(T1c, T1d);
					     T1e = VADD(T1c, T1d);
					     T1L = VSUB(Tg, Th);
					     Ti = VADD(Tg, Th);
					     T1i = LD(&(ii[WS(is, 18)]), ivs, &(ii[0]));
					     {
						  V T2V, T1F, Tj, Tk;
						  Tj = LD(&(ri[WS(is, 10)]), ivs, &(ri[0]));
						  Tk = LD(&(ri[WS(is, 26)]), ivs, &(ri[0]));
						  Te = VADD(Ta, Td);
						  T50 = VSUB(Td, Ta);
						  T2V = VADD(T1D, T1E);
						  T1F = VSUB(T1D, T1E);
						  T1f = VADD(T1b, T1e);
						  T4s = VSUB(T1b, T1e);
						  T1j = VADD(T1h, T1i);
						  T1I = VSUB(T1h, T1i);
						  T1J = VSUB(Tj, Tk);
						  Tl = VADD(Tj, Tk);
						  T1G = VADD(T1C, T1F);
						  T3U = VSUB(T1F, T1C);
						  T2W = VADD(T2U, T2V);
						  T3u = VSUB(T2U, T2V);
						  T1k = LD(&(ii[WS(is, 10)]), ivs, &(ii[0]));
						  T1l = LD(&(ii[WS(is, 26)]), ivs, &(ii[0]));
					     }
					}
					T4v = VSUB(Ti, Tl);
					Tm = VADD(Ti, Tl);
					T1K = VSUB(T1I, T1J);
					T3w = VADD(T1J, T1I);
				   }
			      }
			 }
			 {
			      V T1r, T1S, T1q, T1s, T4x, T1R, T3z;
			      {
				   V Tp, T1P, T1Q, Ts;
				   {
					V Tn, To, T1o, T1M, T1m, T1p;
					Tn = LD(&(ri[WS(is, 30)]), ivs, &(ri[0]));
					To = LD(&(ri[WS(is, 14)]), ivs, &(ri[0]));
					T1o = LD(&(ii[WS(is, 30)]), ivs, &(ii[0]));
					T1M = VSUB(T1k, T1l);
					T1m = VADD(T1k, T1l);
					T1p = LD(&(ii[WS(is, 14)]), ivs, &(ii[0]));
					{
					     V Tq, Tr, T3x, T1N, T4u;
					     Tq = LD(&(ri[WS(is, 6)]), ivs, &(ri[0]));
					     Tr = LD(&(ri[WS(is, 22)]), ivs, &(ri[0]));
					     T1r = LD(&(ii[WS(is, 6)]), ivs, &(ii[0]));
					     T1S = VSUB(Tn, To);
					     Tp = VADD(Tn, To);
					     T3x = VSUB(T1L, T1M);
					     T1N = VADD(T1L, T1M);
					     T4u = VSUB(T1j, T1m);
					     T1n = VADD(T1j, T1m);
					     T1P = VSUB(T1o, T1p);
					     T1q = VADD(T1o, T1p);
					     T1Q = VSUB(Tq, Tr);
					     Ts = VADD(Tq, Tr);
					     T3X = VFNMS(LDK(KP414213562), T3w, T3x);
					     T3y = VFMA(LDK(KP414213562), T3x, T3w);
					     T2Z = VFMA(LDK(KP414213562), T1K, T1N);
					     T1O = VFNMS(LDK(KP414213562), T1N, T1K);
					     T53 = VADD(T4v, T4u);
					     T4w = VSUB(T4u, T4v);
					     T1s = LD(&(ii[WS(is, 22)]), ivs, &(ii[0]));
					}
				   }
				   T4x = VSUB(Tp, Ts);
				   Tt = VADD(Tp, Ts);
				   T1R = VSUB(T1P, T1Q);
				   T3z = VADD(T1Q, T1P);
			      }
			      {
				   V T4S, T5G, T2y, T2L, T4V, T5H, T2D, T2M;
				   {
					V T2G, TN, T4N, T2r, T2s, TQ, T2A, T4O, T2J, T2x, TU, T4T, T2w, T2z, TX;
					V T2B, T2H, T2I, TR;
					{
					     V TL, TM, T2p, T1T, T1t, T2q;
					     TL = LD(&(ri[WS(is, 31)]), ivs, &(ri[WS(is, 1)]));
					     TM = LD(&(ri[WS(is, 15)]), ivs, &(ri[WS(is, 1)]));
					     T2p = LD(&(ii[WS(is, 31)]), ivs, &(ii[WS(is, 1)]));
					     T1T = VSUB(T1r, T1s);
					     T1t = VADD(T1r, T1s);
					     T2q = LD(&(ii[WS(is, 15)]), ivs, &(ii[WS(is, 1)]));
					     {
						  V TO, TP, T3A, T1U, T4y;
						  TO = LD(&(ri[WS(is, 7)]), ivs, &(ri[WS(is, 1)]));
						  TP = LD(&(ri[WS(is, 23)]), ivs, &(ri[WS(is, 1)]));
						  T2H = LD(&(ii[WS(is, 7)]), ivs, &(ii[WS(is, 1)]));
						  T2G = VSUB(TL, TM);
						  TN = VADD(TL, TM);
						  T3A = VSUB(T1S, T1T);
						  T1U = VADD(T1S, T1T);
						  T4y = VSUB(T1q, T1t);
						  T1u = VADD(T1q, T1t);
						  T4N = VADD(T2p, T2q);
						  T2r = VSUB(T2p, T2q);
						  T2s = VSUB(TO, TP);
						  TQ = VADD(TO, TP);
						  T3W = VFMA(LDK(KP414213562), T3z, T3A);
						  T3B = VFNMS(LDK(KP414213562), T3A, T3z);
						  T2Y = VFNMS(LDK(KP414213562), T1R, T1U);
						  T1V = VFMA(LDK(KP414213562), T1U, T1R);
						  T52 = VSUB(T4x, T4y);
						  T4z = VADD(T4x, T4y);
						  T2I = LD(&(ii[WS(is, 23)]), ivs, &(ii[WS(is, 1)]));
					     }
					}
					{
					     V TS, TT, T2u, T2v, TV, TW;
					     TS = LD(&(ri[WS(is, 3)]), ivs, &(ri[WS(is, 1)]));
					     TT = LD(&(ri[WS(is, 19)]), ivs, &(ri[WS(is, 1)]));
					     T2u = LD(&(ii[WS(is, 3)]), ivs, &(ii[WS(is, 1)]));
					     T2v = LD(&(ii[WS(is, 19)]), ivs, &(ii[WS(is, 1)]));
					     TV = LD(&(ri[WS(is, 27)]), ivs, &(ri[WS(is, 1)]));
					     TW = LD(&(ri[WS(is, 11)]), ivs, &(ri[WS(is, 1)]));
					     T2A = LD(&(ii[WS(is, 27)]), ivs, &(ii[WS(is, 1)]));
					     T4O = VADD(T2H, T2I);
					     T2J = VSUB(T2H, T2I);
					     T2x = VSUB(TS, TT);
					     TU = VADD(TS, TT);
					     T4T = VADD(T2u, T2v);
					     T2w = VSUB(T2u, T2v);
					     T2z = VSUB(TV, TW);
					     TX = VADD(TV, TW);
					     T2B = LD(&(ii[WS(is, 11)]), ivs, &(ii[WS(is, 1)]));
					}
					T3O = VADD(T2s, T2r);
					T2t = VSUB(T2r, T2s);
					T3L = VSUB(T2G, T2J);
					T2K = VADD(T2G, T2J);
					T4S = VSUB(TN, TQ);
					TR = VADD(TN, TQ);
					{
					     V T4P, T4Q, TY, T4U, T2C;
					     T5G = VADD(T4N, T4O);
					     T4P = VSUB(T4N, T4O);
					     T4Q = VSUB(TX, TU);
					     TY = VADD(TU, TX);
					     T4U = VADD(T2A, T2B);
					     T2C = VSUB(T2A, T2B);
					     T2y = VSUB(T2w, T2x);
					     T2L = VADD(T2x, T2w);
					     TZ = VADD(TR, TY);
					     T5F = VSUB(TR, TY);
					     T4V = VSUB(T4T, T4U);
					     T5H = VADD(T4T, T4U);
					     T2D = VADD(T2z, T2C);
					     T2M = VSUB(T2z, T2C);
					     T4R = VSUB(T4P, T4Q);
					     T5k = VADD(T4Q, T4P);
					}
				   }
				   {
					V T2f, Ty, T23, T4C, T20, T21, TB, T4D, T2i, T26, TF, T24, TG, TH, T29;
					V T2a;
					{
					     V T1Y, T1Z, Tz, TA, T2g, T2h, Tw, Tx, TD, TE;
					     Tw = LD(&(ri[WS(is, 1)]), ivs, &(ri[WS(is, 1)]));
					     Tx = LD(&(ri[WS(is, 17)]), ivs, &(ri[WS(is, 1)]));
					     T5j = VADD(T4S, T4V);
					     T4W = VSUB(T4S, T4V);
					     T5I = VSUB(T5G, T5H);
					     T5X = VADD(T5G, T5H);
					     T2E = VADD(T2y, T2D);
					     T3M = VSUB(T2D, T2y);
					     T2N = VADD(T2L, T2M);
					     T3P = VSUB(T2L, T2M);
					     T2f = VSUB(Tw, Tx);
					     Ty = VADD(Tw, Tx);
					     T1Y = LD(&(ii[WS(is, 1)]), ivs, &(ii[WS(is, 1)]));
					     T1Z = LD(&(ii[WS(is, 17)]), ivs, &(ii[WS(is, 1)]));
					     Tz = LD(&(ri[WS(is, 9)]), ivs, &(ri[WS(is, 1)]));
					     TA = LD(&(ri[WS(is, 25)]), ivs, &(ri[WS(is, 1)]));
					     T2g = LD(&(ii[WS(is, 9)]), ivs, &(ii[WS(is, 1)]));
					     T2h = LD(&(ii[WS(is, 25)]), ivs, &(ii[WS(is, 1)]));
					     TD = LD(&(ri[WS(is, 5)]), ivs, &(ri[WS(is, 1)]));
					     TE = LD(&(ri[WS(is, 21)]), ivs, &(ri[WS(is, 1)]));
					     T23 = LD(&(ii[WS(is, 5)]), ivs, &(ii[WS(is, 1)]));
					     T4C = VADD(T1Y, T1Z);
					     T20 = VSUB(T1Y, T1Z);
					     T21 = VSUB(Tz, TA);
					     TB = VADD(Tz, TA);
					     T4D = VADD(T2g, T2h);
					     T2i = VSUB(T2g, T2h);
					     T26 = VSUB(TD, TE);
					     TF = VADD(TD, TE);
					     T24 = LD(&(ii[WS(is, 21)]), ivs, &(ii[WS(is, 1)]));
					     TG = LD(&(ri[WS(is, 29)]), ivs, &(ri[WS(is, 1)]));
					     TH = LD(&(ri[WS(is, 13)]), ivs, &(ri[WS(is, 1)]));
					     T29 = LD(&(ii[WS(is, 29)]), ivs, &(ii[WS(is, 1)]));
					     T2a = LD(&(ii[WS(is, 13)]), ivs, &(ii[WS(is, 1)]));
					}
					{
					     V T4I, T25, T28, TI, T4J, T2b, T4H, TC, T5B, T4E;
					     T3H = VADD(T21, T20);
					     T22 = VSUB(T20, T21);
					     T3E = VSUB(T2f, T2i);
					     T2j = VADD(T2f, T2i);
					     T4I = VADD(T23, T24);
					     T25 = VSUB(T23, T24);
					     T28 = VSUB(TG, TH);
					     TI = VADD(TG, TH);
					     T4J = VADD(T29, T2a);
					     T2b = VSUB(T29, T2a);
					     T4H = VSUB(Ty, TB);
					     TC = VADD(Ty, TB);
					     T5B = VADD(T4C, T4D);
					     T4E = VSUB(T4C, T4D);
					     {
						  V T27, T2k, TJ, T4F, T4K, T5C, T2c, T2l;
						  T27 = VSUB(T25, T26);
						  T2k = VADD(T26, T25);
						  TJ = VADD(TF, TI);
						  T4F = VSUB(TI, TF);
						  T4K = VSUB(T4I, T4J);
						  T5C = VADD(T4I, T4J);
						  T2c = VADD(T28, T2b);
						  T2l = VSUB(T28, T2b);
						  T4G = VSUB(T4E, T4F);
						  T5h = VADD(T4F, T4E);
						  TK = VADD(TC, TJ);
						  T5A = VSUB(TC, TJ);
						  T5D = VSUB(T5B, T5C);
						  T5W = VADD(T5B, T5C);
						  T2d = VADD(T27, T2c);
						  T3F = VSUB(T2c, T27);
						  T4L = VSUB(T4H, T4K);
						  T5g = VADD(T4H, T4K);
						  T3I = VSUB(T2k, T2l);
						  T2m = VADD(T2k, T2l);
					     }
					}
				   }
			      }
			 }
		    }
		    {
			 V T1v, T1g, T5V, Tv, T60, T5Y, T11, T10;
			 {
			      V T5o, T5n, T5i, T5r, T5f, T5l, T5w, T5u;
			      {
				   V T5d, T4t, T4A, T4X, T58, T51, T4M, T59, T54, T5e, T5b, T4B;
				   T5d = VADD(T4r, T4s);
				   T4t = VSUB(T4r, T4s);
				   T4A = VSUB(T4w, T4z);
				   T5o = VADD(T4w, T4z);
				   T4X = VFNMS(LDK(KP414213562), T4W, T4R);
				   T58 = VFMA(LDK(KP414213562), T4R, T4W);
				   T5n = VADD(T50, T4Z);
				   T51 = VSUB(T4Z, T50);
				   T4M = VFMA(LDK(KP414213562), T4L, T4G);
				   T59 = VFNMS(LDK(KP414213562), T4G, T4L);
				   T54 = VSUB(T52, T53);
				   T5e = VADD(T53, T52);
				   T5b = VFNMS(LDK(KP707106781), T4A, T4t);
				   T4B = VFMA(LDK(KP707106781), T4A, T4t);
				   {
					V T5s, T56, T4Y, T5c, T5a, T57, T55, T5t;
					T5i = VFMA(LDK(KP414213562), T5h, T5g);
					T5s = VFNMS(LDK(KP414213562), T5g, T5h);
					T56 = VADD(T4M, T4X);
					T4Y = VSUB(T4M, T4X);
					T5c = VADD(T59, T58);
					T5a = VSUB(T58, T59);
					T57 = VFMA(LDK(KP707106781), T54, T51);
					T55 = VFNMS(LDK(KP707106781), T54, T51);
					T5r = VFNMS(LDK(KP707106781), T5e, T5d);
					T5f = VFMA(LDK(KP707106781), T5e, T5d);
					T5t = VFMA(LDK(KP414213562), T5j, T5k);
					T5l = VFNMS(LDK(KP414213562), T5k, T5j);
					T61 = VFMA(LDK(KP923879532), T4Y, T4B);
					STM4(&(ro[6]), T61, ovs, &(ro[0]));
					T62 = VFNMS(LDK(KP923879532), T4Y, T4B);
					STM4(&(ro[22]), T62, ovs, &(ro[0]));
					T63 = VFMA(LDK(KP923879532), T5c, T5b);
					STM4(&(ro[30]), T63, ovs, &(ro[0]));
					T64 = VFNMS(LDK(KP923879532), T5c, T5b);
					STM4(&(ro[14]), T64, ovs, &(ro[0]));
					T65 = VFMA(LDK(KP923879532), T5a, T57);
					STM4(&(io[6]), T65, ovs, &(io[0]));
					T66 = VFNMS(LDK(KP923879532), T5a, T57);
					STM4(&(io[22]), T66, ovs, &(io[0]));
					T67 = VFMA(LDK(KP923879532), T56, T55);
					STM4(&(io[30]), T67, ovs, &(io[0]));
					T68 = VFNMS(LDK(KP923879532), T56, T55);
					STM4(&(io[14]), T68, ovs, &(io[0]));
					T5w = VADD(T5s, T5t);
					T5u = VSUB(T5s, T5t);
				   }
			      }
			      {
				   V Tf, T5P, T5z, T5S, T5U, T5O, T5K, T5L, T5M, Tu, T5T, T5N;
				   {
					V T5E, T5Q, T5q, T5m, T5v, T5p, T5R, T5J, T5x, T5y;
					Tf = VADD(T7, Te);
					T5x = VSUB(T7, Te);
					T5y = VSUB(T1n, T1u);
					T1v = VADD(T1n, T1u);
					T69 = VFMA(LDK(KP923879532), T5u, T5r);
					STM4(&(ro[10]), T69, ovs, &(ro[0]));
					T6a = VFNMS(LDK(KP923879532), T5u, T5r);
					STM4(&(ro[26]), T6a, ovs, &(ro[0]));
					T5E = VADD(T5A, T5D);
					T5Q = VSUB(T5D, T5A);
					T5q = VSUB(T5l, T5i);
					T5m = VADD(T5i, T5l);
					T5v = VFMA(LDK(KP707106781), T5o, T5n);
					T5p = VFNMS(LDK(KP707106781), T5o, T5n);
					T5P = VSUB(T5x, T5y);
					T5z = VADD(T5x, T5y);
					T5R = VADD(T5F, T5I);
					T5J = VSUB(T5F, T5I);
					T6b = VFMA(LDK(KP923879532), T5m, T5f);
					STM4(&(ro[2]), T6b, ovs, &(ro[0]));
					T6c = VFNMS(LDK(KP923879532), T5m, T5f);
					STM4(&(ro[18]), T6c, ovs, &(ro[0]));
					T6d = VFMA(LDK(KP923879532), T5w, T5v);
					STM4(&(io[2]), T6d, ovs, &(io[0]));
					T6e = VFNMS(LDK(KP923879532), T5w, T5v);
					STM4(&(io[18]), T6e, ovs, &(io[0]));
					T6f = VFMA(LDK(KP923879532), T5q, T5p);
					STM4(&(io[10]), T6f, ovs, &(io[0]));
					T6g = VFNMS(LDK(KP923879532), T5q, T5p);
					STM4(&(io[26]), T6g, ovs, &(io[0]));
					T5S = VSUB(T5Q, T5R);
					T5U = VADD(T5Q, T5R);
					T5O = VSUB(T5J, T5E);
					T5K = VADD(T5E, T5J);
					T1g = VADD(T18, T1f);
					T5L = VSUB(T18, T1f);
					T5M = VSUB(Tt, Tm);
					Tu = VADD(Tm, Tt);
				   }
				   T6h = VFMA(LDK(KP707106781), T5S, T5P);
				   STM4(&(ro[12]), T6h, ovs, &(ro[0]));
				   T6i = VFNMS(LDK(KP707106781), T5S, T5P);
				   STM4(&(ro[28]), T6i, ovs, &(ro[0]));
				   T6j = VFMA(LDK(KP707106781), T5K, T5z);
				   STM4(&(ro[4]), T6j, ovs, &(ro[0]));
				   T6k = VFNMS(LDK(KP707106781), T5K, T5z);
				   STM4(&(ro[20]), T6k, ovs, &(ro[0]));
				   T5T = VADD(T5M, T5L);
				   T5N = VSUB(T5L, T5M);
				   T5V = VSUB(Tf, Tu);
				   Tv = VADD(Tf, Tu);
				   T6l = VFMA(LDK(KP707106781), T5U, T5T);
				   STM4(&(io[4]), T6l, ovs, &(io[0]));
				   T6m = VFNMS(LDK(KP707106781), T5U, T5T);
				   STM4(&(io[20]), T6m, ovs, &(io[0]));
				   T6n = VFMA(LDK(KP707106781), T5O, T5N);
				   STM4(&(io[12]), T6n, ovs, &(io[0]));
				   T6o = VFNMS(LDK(KP707106781), T5O, T5N);
				   STM4(&(io[28]), T6o, ovs, &(io[0]));
				   T60 = VADD(T5W, T5X);
				   T5Y = VSUB(T5W, T5X);
				   T11 = VSUB(TZ, TK);
				   T10 = VADD(TK, TZ);
			      }
			 }
			 {
			      V T39, T3k, T3j, T3a, T1X, T37, T33, T31, T3d, T3c, T47, T4i, T4h, T48, T4b;
			      V T4a, T4e, T3N, T41, T3D, T45, T3Z, T38, T36, T32, T2Q, T42, T3K, T3Q, T4d;
			      {
				   V T2e, T2n, T2F, T2O, T1w, T5Z;
				   {
					V T1H, T1W, T2X, T30;
					T39 = VFMA(LDK(KP707106781), T1G, T1z);
					T1H = VFNMS(LDK(KP707106781), T1G, T1z);
					T1W = VSUB(T1O, T1V);
					T3k = VADD(T1O, T1V);
					T3j = VFMA(LDK(KP707106781), T2W, T2T);
					T2X = VFNMS(LDK(KP707106781), T2W, T2T);
					T30 = VSUB(T2Y, T2Z);
					T3a = VADD(T2Z, T2Y);
					T6p = VSUB(T5V, T5Y);
					STM4(&(ro[24]), T6p, ovs, &(ro[0]));
					T6q = VADD(T5V, T5Y);
					STM4(&(ro[8]), T6q, ovs, &(ro[0]));
					T6r = VADD(Tv, T10);
					STM4(&(ro[0]), T6r, ovs, &(ro[0]));
					T6s = VSUB(Tv, T10);
					STM4(&(ro[16]), T6s, ovs, &(ro[0]));
					T1w = VSUB(T1g, T1v);
					T5Z = VADD(T1g, T1v);
					T1X = VFMA(LDK(KP923879532), T1W, T1H);
					T37 = VFNMS(LDK(KP923879532), T1W, T1H);
					T33 = VFMA(LDK(KP923879532), T30, T2X);
					T31 = VFNMS(LDK(KP923879532), T30, T2X);
				   }
				   T3d = VFMA(LDK(KP707106781), T2d, T22);
				   T2e = VFNMS(LDK(KP707106781), T2d, T22);
				   T2n = VFNMS(LDK(KP707106781), T2m, T2j);
				   T3c = VFMA(LDK(KP707106781), T2m, T2j);
				   T6t = VADD(T5Z, T60);
				   STM4(&(io[0]), T6t, ovs, &(io[0]));
				   T6u = VSUB(T5Z, T60);
				   STM4(&(io[16]), T6u, ovs, &(io[0]));
				   T6v = VSUB(T1w, T11);
				   STM4(&(io[24]), T6v, ovs, &(io[0]));
				   T6w = VADD(T11, T1w);
				   STM4(&(io[8]), T6w, ovs, &(io[0]));
				   T3g = VFMA(LDK(KP707106781), T2E, T2t);
				   T2F = VFNMS(LDK(KP707106781), T2E, T2t);
				   T2O = VFNMS(LDK(KP707106781), T2N, T2K);
				   T3f = VFMA(LDK(KP707106781), T2N, T2K);
				   {
					V T3v, T35, T2o, T3C, T3V, T3Y;
					T47 = VFNMS(LDK(KP707106781), T3u, T3t);
					T3v = VFMA(LDK(KP707106781), T3u, T3t);
					T35 = VFNMS(LDK(KP668178637), T2e, T2n);
					T2o = VFMA(LDK(KP668178637), T2n, T2e);
					T3C = VSUB(T3y, T3B);
					T4i = VADD(T3y, T3B);
					T4h = VFNMS(LDK(KP707106781), T3U, T3T);
					T3V = VFMA(LDK(KP707106781), T3U, T3T);
					T3Y = VSUB(T3W, T3X);
					T48 = VADD(T3X, T3W);
					{
					     V T3G, T34, T2P, T3J;
					     T4b = VFMA(LDK(KP707106781), T3F, T3E);
					     T3G = VFNMS(LDK(KP707106781), T3F, T3E);
					     T34 = VFMA(LDK(KP668178637), T2F, T2O);
					     T2P = VFNMS(LDK(KP668178637), T2O, T2F);
					     T3J = VFNMS(LDK(KP707106781), T3I, T3H);
					     T4a = VFMA(LDK(KP707106781), T3I, T3H);
					     T4e = VFMA(LDK(KP707106781), T3M, T3L);
					     T3N = VFNMS(LDK(KP707106781), T3M, T3L);
					     T41 = VFNMS(LDK(KP923879532), T3C, T3v);
					     T3D = VFMA(LDK(KP923879532), T3C, T3v);
					     T45 = VFMA(LDK(KP923879532), T3Y, T3V);
					     T3Z = VFNMS(LDK(KP923879532), T3Y, T3V);
					     T38 = VADD(T35, T34);
					     T36 = VSUB(T34, T35);
					     T32 = VADD(T2o, T2P);
					     T2Q = VSUB(T2o, T2P);
					     T42 = VFNMS(LDK(KP668178637), T3G, T3J);
					     T3K = VFMA(LDK(KP668178637), T3J, T3G);
					     T3Q = VFNMS(LDK(KP707106781), T3P, T3O);
					     T4d = VFMA(LDK(KP707106781), T3P, T3O);
					}
				   }
			      }
			      {
				   V T4n, T4c, T43, T3R, T4m, T4f;
				   T6x = VFMA(LDK(KP831469612), T38, T37);
				   STM4(&(ro[29]), T6x, ovs, &(ro[1]));
				   T6y = VFNMS(LDK(KP831469612), T38, T37);
				   STM4(&(ro[13]), T6y, ovs, &(ro[1]));
				   T6z = VFMA(LDK(KP831469612), T36, T33);
				   STM4(&(io[5]), T6z, ovs, &(io[1]));
				   T6A = VFNMS(LDK(KP831469612), T36, T33);
				   STM4(&(io[21]), T6A, ovs, &(io[1]));
				   T6B = VFMA(LDK(KP831469612), T32, T31);
				   STM4(&(io[29]), T6B, ovs, &(io[1]));
				   T6C = VFNMS(LDK(KP831469612), T32, T31);
				   STM4(&(io[13]), T6C, ovs, &(io[1]));
				   T6D = VFMA(LDK(KP831469612), T2Q, T1X);
				   STM4(&(ro[5]), T6D, ovs, &(ro[1]));
				   T6E = VFNMS(LDK(KP831469612), T2Q, T1X);
				   STM4(&(ro[21]), T6E, ovs, &(ro[1]));
				   T43 = VFMA(LDK(KP668178637), T3N, T3Q);
				   T3R = VFNMS(LDK(KP668178637), T3Q, T3N);
				   {
					V T44, T46, T40, T3S;
					T44 = VSUB(T42, T43);
					T46 = VADD(T42, T43);
					T40 = VSUB(T3R, T3K);
					T3S = VADD(T3K, T3R);
					T4p = VFMA(LDK(KP923879532), T48, T47);
					T49 = VFNMS(LDK(KP923879532), T48, T47);
					T4l = VFNMS(LDK(KP923879532), T4i, T4h);
					T4j = VFMA(LDK(KP923879532), T4i, T4h);
					T4n = VFNMS(LDK(KP198912367), T4a, T4b);
					T4c = VFMA(LDK(KP198912367), T4b, T4a);
					T6F = VFMA(LDK(KP831469612), T44, T41);
					STM4(&(ro[11]), T6F, ovs, &(ro[1]));
					T6G = VFNMS(LDK(KP831469612), T44, T41);
					STM4(&(ro[27]), T6G, ovs, &(ro[1]));
					T6H = VFMA(LDK(KP831469612), T46, T45);
					STM4(&(io[3]), T6H, ovs, &(io[1]));
					T6I = VFNMS(LDK(KP831469612), T46, T45);
					STM4(&(io[19]), T6I, ovs, &(io[1]));
					T6J = VFMA(LDK(KP831469612), T40, T3Z);
					STM4(&(io[11]), T6J, ovs, &(io[1]));
					T6K = VFNMS(LDK(KP831469612), T40, T3Z);
					STM4(&(io[27]), T6K, ovs, &(io[1]));
					T6L = VFMA(LDK(KP831469612), T3S, T3D);
					STM4(&(ro[3]), T6L, ovs, &(ro[1]));
					T6M = VFNMS(LDK(KP831469612), T3S, T3D);
					STM4(&(ro[19]), T6M, ovs, &(ro[1]));
				   }
				   T4m = VFMA(LDK(KP198912367), T4d, T4e);
				   T4f = VFNMS(LDK(KP198912367), T4e, T4d);
				   T3n = VFNMS(LDK(KP923879532), T3a, T39);
				   T3b = VFMA(LDK(KP923879532), T3a, T39);
				   T3r = VFMA(LDK(KP923879532), T3k, T3j);
				   T3l = VFNMS(LDK(KP923879532), T3k, T3j);
				   T3o = VFNMS(LDK(KP198912367), T3c, T3d);
				   T3e = VFMA(LDK(KP198912367), T3d, T3c);
				   T4q = VADD(T4n, T4m);
				   T4o = VSUB(T4m, T4n);
				   T4k = VADD(T4c, T4f);
				   T4g = VSUB(T4c, T4f);
			      }
			 }
		    }
	       }
	       {
		    V T6N, T6O, T6P, T6Q;
		    T6N = VFMA(LDK(KP980785280), T4q, T4p);
		    STM4(&(ro[31]), T6N, ovs, &(ro[1]));
		    STN4(&(ro[28]), T6i, T6x, T63, T6N, ovs);
		    T6O = VFNMS(LDK(KP980785280), T4q, T4p);
		    STM4(&(ro[15]), T6O, ovs, &(ro[1]));
		    STN4(&(ro[12]), T6h, T6y, T64, T6O, ovs);
		    T6P = VFMA(LDK(KP980785280), T4o, T4l);
		    STM4(&(io[7]), T6P, ovs, &(io[1]));
		    STN4(&(io[4]), T6l, T6z, T65, T6P, ovs);
		    T6Q = VFNMS(LDK(KP980785280), T4o, T4l);
		    STM4(&(io[23]), T6Q, ovs, &(io[1]));
		    STN4(&(io[20]), T6m, T6A, T66, T6Q, ovs);
		    {
			 V T6R, T6S, T6T, T6U;
			 T6R = VFMA(LDK(KP980785280), T4k, T4j);
			 STM4(&(io[31]), T6R, ovs, &(io[1]));
			 STN4(&(io[28]), T6o, T6B, T67, T6R, ovs);
			 T6S = VFNMS(LDK(KP980785280), T4k, T4j);
			 STM4(&(io[15]), T6S, ovs, &(io[1]));
			 STN4(&(io[12]), T6n, T6C, T68, T6S, ovs);
			 T6T = VFMA(LDK(KP980785280), T4g, T49);
			 STM4(&(ro[7]), T6T, ovs, &(ro[1]));
			 STN4(&(ro[4]), T6j, T6D, T61, T6T, ovs);
			 T6U = VFNMS(LDK(KP980785280), T4g, T49);
			 STM4(&(ro[23]), T6U, ovs, &(ro[1]));
			 STN4(&(ro[20]), T6k, T6E, T62, T6U, ovs);
			 T3h = VFNMS(LDK(KP198912367), T3g, T3f);
			 T3p = VFMA(LDK(KP198912367), T3f, T3g);
		    }
	       }
	       {
		    V T3s, T3q, T3i, T3m;
		    T3s = VADD(T3o, T3p);
		    T3q = VSUB(T3o, T3p);
		    T3i = VADD(T3e, T3h);
		    T3m = VSUB(T3h, T3e);
		    {
			 V T6V, T6W, T6X, T6Y;
			 T6V = VFMA(LDK(KP980785280), T3q, T3n);
			 STM4(&(ro[9]), T6V, ovs, &(ro[1]));
			 STN4(&(ro[8]), T6q, T6V, T69, T6F, ovs);
			 T6W = VFNMS(LDK(KP980785280), T3q, T3n);
			 STM4(&(ro[25]), T6W, ovs, &(ro[1]));
			 STN4(&(ro[24]), T6p, T6W, T6a, T6G, ovs);
			 T6X = VFMA(LDK(KP980785280), T3s, T3r);
			 STM4(&(io[1]), T6X, ovs, &(io[1]));
			 STN4(&(io[0]), T6t, T6X, T6d, T6H, ovs);
			 T6Y = VFNMS(LDK(KP980785280), T3s, T3r);
			 STM4(&(io[17]), T6Y, ovs, &(io[1]));
			 STN4(&(io[16]), T6u, T6Y, T6e, T6I, ovs);
			 {
			      V T6Z, T70, T71, T72;
			      T6Z = VFMA(LDK(KP980785280), T3m, T3l);
			      STM4(&(io[9]), T6Z, ovs, &(io[1]));
			      STN4(&(io[8]), T6w, T6Z, T6f, T6J, ovs);
			      T70 = VFNMS(LDK(KP980785280), T3m, T3l);
			      STM4(&(io[25]), T70, ovs, &(io[1]));
			      STN4(&(io[24]), T6v, T70, T6g, T6K, ovs);
			      T71 = VFMA(LDK(KP980785280), T3i, T3b);
			      STM4(&(ro[1]), T71, ovs, &(ro[1]));
			      STN4(&(ro[0]), T6r, T71, T6b, T6L, ovs);
			      T72 = VFNMS(LDK(KP980785280), T3i, T3b);
			      STM4(&(ro[17]), T72, ovs, &(ro[1]));
			      STN4(&(ro[16]), T6s, T72, T6c, T6M, ovs);
			 }
		    }
	       }
	  }
     }
     VLEAVE();
}

static const kdft_desc desc = { 32, XSIMD_STRING("n2sv_32"), {236, 0, 136, 0}, &GENUS, 0, 1, 0, 0 };

void XSIMD(codelet_n2sv_32) (planner *p) {
     X(kdft_register) (p, n2sv_32, &desc);
}

#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_notw.native -simd -compact -variables 4 -pipeline-latency 8 -n 32 -name n2sv_32 -with-ostride 1 -include n2s.h -store-multiple 4 */

/*
 * This function contains 372 FP additions, 84 FP multiplications,
 * (or, 340 additions, 52 multiplications, 32 fused multiply/add),
 * 130 stack variables, 7 constants, and 144 memory accesses
 */
#include "n2s.h"

static void n2sv_32(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, INT v, INT ivs, INT ovs)
{
     DVK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DVK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DVK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DVK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DVK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DVK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT i;
	  for (i = v; i > 0; i = i - (2 * VL), ri = ri + ((2 * VL) * ivs), ii = ii + ((2 * VL) * ivs), ro = ro + ((2 * VL) * ovs), io = io + ((2 * VL) * ovs), MAKE_VOLATILE_STRIDE(is), MAKE_VOLATILE_STRIDE(os)) {
	       V T7, T4r, T4Z, T18, T1z, T3t, T3T, T2T, Te, T1f, T50, T4s, T2W, T3u, T1G;
	       V T3U, Tm, T1n, T1O, T2Z, T3y, T3X, T4w, T53, Tt, T1u, T1V, T2Y, T3B, T3W;
	       V T4z, T52, T2t, T3L, T3O, T2K, TR, TY, T5F, T5G, T5H, T5I, T4R, T5j, T2E;
	       V T3P, T4W, T5k, T2N, T3M, T22, T3E, T3H, T2j, TC, TJ, T5A, T5B, T5C, T5D;
	       V T4G, T5g, T2d, T3F, T4L, T5h, T2m, T3I;
	       {
		    V T3, T1x, T14, T2S, T6, T2R, T17, T1y;
		    {
			 V T1, T2, T12, T13;
			 T1 = LD(&(ri[0]), ivs, &(ri[0]));
			 T2 = LD(&(ri[WS(is, 16)]), ivs, &(ri[0]));
			 T3 = VADD(T1, T2);
			 T1x = VSUB(T1, T2);
			 T12 = LD(&(ii[0]), ivs, &(ii[0]));
			 T13 = LD(&(ii[WS(is, 16)]), ivs, &(ii[0]));
			 T14 = VADD(T12, T13);
			 T2S = VSUB(T12, T13);
		    }
		    {
			 V T4, T5, T15, T16;
			 T4 = LD(&(ri[WS(is, 8)]), ivs, &(ri[0]));
			 T5 = LD(&(ri[WS(is, 24)]), ivs, &(ri[0]));
			 T6 = VADD(T4, T5);
			 T2R = VSUB(T4, T5);
			 T15 = LD(&(ii[WS(is, 8)]), ivs, &(ii[0]));
			 T16 = LD(&(ii[WS(is, 24)]), ivs, &(ii[0]));
			 T17 = VADD(T15, T16);
			 T1y = VSUB(T15, T16);
		    }
		    T7 = VADD(T3, T6);
		    T4r = VSUB(T3, T6);
		    T4Z = VSUB(T14, T17);
		    T18 = VADD(T14, T17);
		    T1z = VSUB(T1x, T1y);
		    T3t = VADD(T1x, T1y);
		    T3T = VSUB(T2S, T2R);
		    T2T = VADD(T2R, T2S);
	       }
	       {
		    V Ta, T1B, T1b, T1A, Td, T1D, T1e, T1E;
		    {
			 V T8, T9, T19, T1a;
			 T8 = LD(&(ri[WS(is, 4)]), ivs, &(ri[0]));
			 T9 = LD(&(ri[WS(is, 20)]), ivs, &(ri[0]));
			 Ta = VADD(T8, T9);
			 T1B = VSUB(T8, T9);
			 T19 = LD(&(ii[WS(is, 4)]), ivs, &(ii[0]));
			 T1a = LD(&(ii[WS(is, 20)]), ivs, &(ii[0]));
			 T1b = VADD(T19, T1a);
			 T1A = VSUB(T19, T1a);
		    }
		    {
			 V Tb, Tc, T1c, T1d;
			 Tb = LD(&(ri[WS(is, 28)]), ivs, &(ri[0]));
			 Tc = LD(&(ri[WS(is, 12)]), ivs, &(ri[0]));
			 Td = VADD(Tb, Tc);
			 T1D = VSUB(Tb, Tc);
			 T1c = LD(&(ii[WS(is, 28)]), ivs, &(ii[0]));
			 T1d = LD(&(ii[WS(is, 12)]), ivs, &(ii[0]));
			 T1e = VADD(T1c, T1d);
			 T1E = VSUB(T1c, T1d);
		    }
		    Te = VADD(Ta, Td);
		    T1f = VADD(T1b, T1e);
		    T50 = VSUB(Td, Ta);
		    T4s = VSUB(T1b, T1e);
		    {
			 V T2U, T2V, T1C, T1F;
			 T2U = VSUB(T1D, T1E);
			 T2V = VADD(T1B, T1A);
			 T2W = VMUL(LDK(KP707106781), VSUB(T2U, T2V));
			 T3u = VMUL(LDK(KP707106781), VADD(T2V, T2U));
			 T1C = VSUB(T1A, T1B);
			 T1F = VADD(T1D, T1E);
			 T1G = VMUL(LDK(KP707106781), VSUB(T1C, T1F));
			 T3U = VMUL(LDK(KP707106781), VADD(T1C, T1F));
		    }
	       }
	       {
		    V Ti, T1L, T1j, T1J, Tl, T1I, T1m, T1M, T1K, T1N;
		    {
			 V Tg, Th, T1h, T1i;
			 Tg = LD(&(ri[WS(is, 2)]), ivs, &(ri[0]));
			 Th = LD(&(ri[WS(is, 18)]), ivs, &(ri[0]));
			 Ti = VADD(Tg, Th);
			 T1L = VSUB(Tg, Th);
			 T1h = LD(&(ii[WS(is, 2)]), ivs, &(ii[0]));
			 T1i = LD(&(ii[WS(is, 18)]), ivs, &(ii[0]));
			 T1j = VADD(T1h, T1i);
			 T1J = VSUB(T1h, T1i);
		    }
		    {
			 V Tj, Tk, T1k, T1l;
			 Tj = LD(&(ri[WS(is, 10)]), ivs, &(ri[0]));
			 Tk = LD(&(ri[WS(is, 26)]), ivs, &(ri[0]));
			 Tl = VADD(Tj, Tk);
			 T1I = VSUB(Tj, Tk);
			 T1k = LD(&(ii[WS(is, 10)]), ivs, &(ii[0]));
			 T1l = LD(&(ii[WS(is, 26)]), ivs, &(ii[0]));
			 T1m = VADD(T1k, T1l);
			 T1M = VSUB(T1k, T1l);
		    }
		    Tm = VADD(Ti, Tl);
		    T1n = VADD(T1j, T1m);
		    T1K = VADD(T1I, T1J);
		    T1N = VSUB(T1L, T1M);
		    T1O = VFNMS(LDK(KP923879532), T1N, VMUL(LDK(KP382683432), T1K));
		    T2Z = VFMA(LDK(KP923879532), T1K, VMUL(LDK(KP382683432), T1N));
		    {
			 V T3w, T3x, T4u, T4v;
			 T3w = VSUB(T1J, T1I);
			 T3x = VADD(T1L, T1M);
			 T3y = VFNMS(LDK(KP382683432), T3x, VMUL(LDK(KP923879532), T3w));
			 T3X = VFMA(LDK(KP382683432), T3w, VMUL(LDK(KP923879532), T3x));
			 T4u = VSUB(T1j, T1m);
			 T4v = VSUB(Ti, Tl);
			 T4w = VSUB(T4u, T4v);
			 T53 = VADD(T4v, T4u);
		    }
	       }
	       {
		    V Tp, T1S, T1q, T1Q, Ts, T1P, T1t, T1T, T1R, T1U;
		    {
			 V Tn, To, T1o, T1p;
			 Tn = LD(&(ri[WS(is, 30)]), ivs, &(ri[0]));
			 To = LD(&(ri[WS(is, 14)]), ivs, &(ri[0]));
			 Tp = VADD(Tn, To);
			 T1S = VSUB(Tn, To);
			 T1o = LD(&(ii[WS(is, 30)]), ivs, &(ii[0]));
			 T1p = LD(&(ii[WS(is, 14)]), ivs, &(ii[0]));
			 T1q = VADD(T1o, T1p);
			 T1Q = VSUB(T1o, T1p);
		    }
		    {
			 V Tq, Tr, T1r, T1s;
			 Tq = LD(&(ri[WS(is, 6)]), ivs, &(ri[0]));
			 Tr = LD(&(ri[WS(is, 22)]), ivs, &(ri[0]));
			 Ts = VADD(Tq, Tr);
			 T1P = VSUB(Tq, Tr);
			 T1r = LD(&(ii[WS(is, 6)]), ivs, &(ii[0]));
			 T1s = LD(&(ii[WS(is, 22)]), ivs, &(ii[0]));
			 T1t = VADD(T1r, T1s);
			 T1T = VSUB(T1r, T1s);
		    }
		    Tt = VADD(Tp, Ts);
		    T1u = VADD(T1q, T1t);
		    T1R = VADD(T1P, T1Q);
		    T1U = VSUB(T1S, T1T);
		    T1V = VFMA(LDK(KP382683432), T1R, VMUL(LDK(KP923879532), T1U));
		    T2Y = VFNMS(LDK(KP923879532), T1R, VMUL(LDK(KP382683432), T1U));
		    {
			 V T3z, T3A, T4x, T4y;
			 T3z = VSUB(T1Q, T1P);
			 T3A = VADD(T1S, T1T);
			 T3B = VFMA(LDK(KP923879532), T3z, VMUL(LDK(KP382683432), T3A));
			 T3W = VFNMS(LDK(KP382683432), T3z, VMUL(LDK(KP923879532), T3A));
			 T4x = VSUB(Tp, Ts);
			 T4y = VSUB(T1q, T1t);
			 T4z = VADD(T4x, T4y);
			 T52 = VSUB(T4x, T4y);
		    }
	       }
	       {
		    V TN, T2p, T2J, T4S, TQ, T2G, T2s, T4T, TU, T2x, T2w, T4O, TX, T2z, T2C;
		    V T4P;
		    {
			 V TL, TM, T2H, T2I;
			 TL = LD(&(ri[WS(is, 31)]), ivs, &(ri[WS(is, 1)]));
			 TM = LD(&(ri[WS(is, 15)]), ivs, &(ri[WS(is, 1)]));
			 TN = VADD(TL, TM);
			 T2p = VSUB(TL, TM);
			 T2H = LD(&(ii[WS(is, 31)]), ivs, &(ii[WS(is, 1)]));
			 T2I = LD(&(ii[WS(is, 15)]), ivs, &(ii[WS(is, 1)]));
			 T2J = VSUB(T2H, T2I);
			 T4S = VADD(T2H, T2I);
		    }
		    {
			 V TO, TP, T2q, T2r;
			 TO = LD(&(ri[WS(is, 7)]), ivs, &(ri[WS(is, 1)]));
			 TP = LD(&(ri[WS(is, 23)]), ivs, &(ri[WS(is, 1)]));
			 TQ = VADD(TO, TP);
			 T2G = VSUB(TO, TP);
			 T2q = LD(&(ii[WS(is, 7)]), ivs, &(ii[WS(is, 1)]));
			 T2r = LD(&(ii[WS(is, 23)]), ivs, &(ii[WS(is, 1)]));
			 T2s = VSUB(T2q, T2r);
			 T4T = VADD(T2q, T2r);
		    }
		    {
			 V TS, TT, T2u, T2v;
			 TS = LD(&(ri[WS(is, 3)]), ivs, &(ri[WS(is, 1)]));
			 TT = LD(&(ri[WS(is, 19)]), ivs, &(ri[WS(is, 1)]));
			 TU = VADD(TS, TT);
			 T2x = VSUB(TS, TT);
			 T2u = LD(&(ii[WS(is, 3)]), ivs, &(ii[WS(is, 1)]));
			 T2v = LD(&(ii[WS(is, 19)]), ivs, &(ii[WS(is, 1)]));
			 T2w = VSUB(T2u, T2v);
			 T4O = VADD(T2u, T2v);
		    }
		    {
			 V TV, TW, T2A, T2B;
			 TV = LD(&(ri[WS(is, 27)]), ivs, &(ri[WS(is, 1)]));
			 TW = LD(&(ri[WS(is, 11)]), ivs, &(ri[WS(is, 1)]));
			 TX = VADD(TV, TW);
			 T2z = VSUB(TV, TW);
			 T2A = LD(&(ii[WS(is, 27)]), ivs, &(ii[WS(is, 1)]));
			 T2B = LD(&(ii[WS(is, 11)]), ivs, &(ii[WS(is, 1)]));
			 T2C = VSUB(T2A, T2B);
			 T4P = VADD(T2A, T2B);
		    }
		    T2t = VSUB(T2p, T2s);
		    T3L = VADD(T2p, T2s);
		    T3O = VSUB(T2J, T2G);
		    T2K = VADD(T2G, T2J);
		    TR = VADD(TN, TQ);
		    TY = VADD(TU, TX);
		    T5F = VSUB(TR, TY);
		    {
			 V T4N, T4Q, T2y, T2D;
			 T5G = VADD(T4S, T4T);
			 T5H = VADD(T4O, T4P);
			 T5I = VSUB(T5G, T5H);
			 T4N = VSUB(TN, TQ);
			 T4Q = VSUB(T4O, T4P);
			 T4R = VSUB(T4N, T4Q);
			 T5j = VADD(T4N, T4Q);
			 T2y = VSUB(T2w, T2x);
			 T2D = VADD(T2z, T2C);
			 T2E = VMUL(LDK(KP707106781), VSUB(T2y, T2D));
			 T3P = VMUL(LDK(KP707106781), VADD(T2y, T2D));
			 {
			      V T4U, T4V, T2L, T2M;
			      T4U = VSUB(T4S, T4T);
			      T4V = VSUB(TX, TU);
			      T4W = VSUB(T4U, T4V);
			      T5k = VADD(T4V, T4U);
			      T2L = VSUB(T2z, T2C);
			      T2M = VADD(T2x, T2w);
			      T2N = VMUL(LDK(KP707106781), VSUB(T2L, T2M));
			      T3M = VMUL(LDK(KP707106781), VADD(T2M, T2L));
			 }
		    }
	       }
	       {
		    V Ty, T2f, T21, T4C, TB, T1Y, T2i, T4D, TF, T28, T2b, T4I, TI, T23, T26;
		    V T4J;
		    {
			 V Tw, Tx, T1Z, T20;
			 Tw = LD(&(ri[WS(is, 1)]), ivs, &(ri[WS(is, 1)]));
			 Tx = LD(&(ri[WS(is, 17)]), ivs, &(ri[WS(is, 1)]));
			 Ty = VADD(Tw, Tx);
			 T2f = VSUB(Tw, Tx);
			 T1Z = LD(&(ii[WS(is, 1)]), ivs, &(ii[WS(is, 1)]));
			 T20 = LD(&(ii[WS(is, 17)]), ivs, &(ii[WS(is, 1)]));
			 T21 = VSUB(T1Z, T20);
			 T4C = VADD(T1Z, T20);
		    }
		    {
			 V Tz, TA, T2g, T2h;
			 Tz = LD(&(ri[WS(is, 9)]), ivs, &(ri[WS(is, 1)]));
			 TA = LD(&(ri[WS(is, 25)]), ivs, &(ri[WS(is, 1)]));
			 TB = VADD(Tz, TA);
			 T1Y = VSUB(Tz, TA);
			 T2g = LD(&(ii[WS(is, 9)]), ivs, &(ii[WS(is, 1)]));
			 T2h = LD(&(ii[WS(is, 25)]), ivs, &(ii[WS(is, 1)]));
			 T2i = VSUB(T2g, T2h);
			 T4D = VADD(T2g, T2h);
		    }
		    {
			 V TD, TE, T29, T2a;
			 TD = LD(&(ri[WS(is, 5)]), ivs, &(ri[WS(is, 1)]));
			 TE = LD(&(ri[WS(is, 21)]), ivs, &(ri[WS(is, 1)]));
			 TF = VADD(TD, TE);
			 T28 = VSUB(TD, TE);
			 T29 = LD(&(ii[WS(is, 5)]), ivs, &(ii[WS(is, 1)]));
			 T2a = LD(&(ii[WS(is, 21)]), ivs, &(ii[WS(is, 1)]));
			 T2b = VSUB(T29, T2a);
			 T4I = VADD(T29, T2a);
		    }
		    {
			 V TG, TH, T24, T25;
			 TG = LD(&(ri[WS(is, 29)]), ivs, &(ri[WS(is, 1)]));
			 TH = LD(&(ri[WS(is, 13)]), ivs, &(ri[WS(is, 1)]));
			 TI = VADD(TG, TH);
			 T23 = VSUB(TG, TH);
			 T24 = LD(&(ii[WS(is, 29)]), ivs, &(ii[WS(is, 1)]));
			 T25 = LD(&(ii[WS(is, 13)]), ivs, &(ii[WS(is, 1)]));
			 T26 = VSUB(T24, T25);
			 T4J = VADD(T24, T25);
		    }
		    T22 = VADD(T1Y, T21);
		    T3E = VADD(T2f, T2i);
		    T3H = VSUB(T21, T1Y);
		    T2j = VSUB(T2f, T2i);
		    TC = VADD(Ty, TB);
		    TJ = VADD(TF, TI);
		    T5A = VSUB(TC, TJ);
		    {
			 V T4E, T4F, T27, T2c;
			 T5B = VADD(T4C, T4D);
			 T5C = VADD(T4I, T4J);
			 T5D = VSUB(T5B, T5C);
			 T4E = VSUB(T4C, T4D);
			 T4F = VSUB(TI, TF);
			 T4G = VSUB(T4E, T4F);
			 T5g = VADD(T4F, T4E);
			 T27 = VSUB(T23, T26);
			 T2c = VADD(T28, T2b);
			 T2d = VMUL(LDK(KP707106781), VSUB(T27, T2c));
			 T3F = VMUL(LDK(KP707106781), VADD(T2c, T27));
			 {
			      V T4H, T4K, T2k, T2l;
			      T4H = VSUB(Ty, TB);
			      T4K = VSUB(T4I, T4J);
			      T4L = VSUB(T4H, T4K);
			      T5h = VADD(T4H, T4K);
			      T2k = VSUB(T2b, T28);
			      T2l = VADD(T23, T26);
			      T2m = VMUL(LDK(KP707106781), VSUB(T2k, T2l));
			      T3I = VMUL(LDK(KP707106781), VADD(T2k, T2l));
			 }
		    }
	       }
	       {
		    V T61, T62, T63, T64, T65, T66, T67, T68, T69, T6a, T6b, T6c, T6d, T6e, T6f;
		    V T6g, T6h, T6i, T6j, T6k, T6l, T6m, T6n, T6o, T6p, T6q, T6r, T6s, T6t, T6u;
		    V T6v, T6w;
		    {
			 V T4B, T57, T5a, T5c, T4Y, T56, T55, T5b;
			 {
			      V T4t, T4A, T58, T59;
			      T4t = VSUB(T4r, T4s);
			      T4A = VMUL(LDK(KP707106781), VSUB(T4w, T4z));
			      T4B = VADD(T4t, T4A);
			      T57 = VSUB(T4t, T4A);
			      T58 = VFNMS(LDK(KP923879532), T4L, VMUL(LDK(KP382683432), T4G));
			      T59 = VFMA(LDK(KP382683432), T4W, VMUL(LDK(KP923879532), T4R));
			      T5a = VSUB(T58, T59);
			      T5c = VADD(T58, T59);
			 }
			 {
			      V T4M, T4X, T51, T54;
			      T4M = VFMA(LDK(KP923879532), T4G, VMUL(LDK(KP382683432), T4L));
			      T4X = VFNMS(LDK(KP923879532), T4W, VMUL(LDK(KP382683432), T4R));
			      T4Y = VADD(T4M, T4X);
			      T56 = VSUB(T4X, T4M);
			      T51 = VSUB(T4Z, T50);
			      T54 = VMUL(LDK(KP707106781), VSUB(T52, T53));
			      T55 = VSUB(T51, T54);
			      T5b = VADD(T51, T54);
			 }
			 T61 = VSUB(T4B, T4Y);
			 STM4(&(ro[22]), T61, ovs, &(ro[0]));
			 T62 = VSUB(T5b, T5c);
			 STM4(&(io[22]), T62, ovs, &(io[0]));
			 T63 = VADD(T4B, T4Y);
			 STM4(&(ro[6]), T63, ovs, &(ro[0]));
			 T64 = VADD(T5b, T5c);
			 STM4(&(io[6]), T64, ovs, &(io[0]));
			 T65 = VSUB(T55, T56);
			 STM4(&(io[30]), T65, ovs, &(io[0]));
			 T66 = VSUB(T57, T5a);
			 STM4(&(ro[30]), T66, ovs, &(ro[0]));
			 T67 = VADD(T55, T56);
			 STM4(&(io[14]), T67, ovs, &(io[0]));
			 T68 = VADD(T57, T5a);
			 STM4(&(ro[14]), T68, ovs, &(ro[0]));
		    }
		    {
			 V T5f, T5r, T5u, T5w, T5m, T5q, T5p, T5v;
			 {
			      V T5d, T5e, T5s, T5t;
			      T5d = VADD(T4r, T4s);
			      T5e = VMUL(LDK(KP707106781), VADD(T53, T52));
			      T5f = VADD(T5d, T5e);
			      T5r = VSUB(T5d, T5e);
			      T5s = VFNMS(LDK(KP382683432), T5h, VMUL(LDK(KP923879532), T5g));
			      T5t = VFMA(LDK(KP923879532), T5k, VMUL(LDK(KP382683432), T5j));
			      T5u = VSUB(T5s, T5t);
			      T5w = VADD(T5s, T5t);
			 }
			 {
			      V T5i, T5l, T5n, T5o;
			      T5i = VFMA(LDK(KP382683432), T5g, VMUL(LDK(KP923879532), T5h));
			      T5l = VFNMS(LDK(KP382683432), T5k, VMUL(LDK(KP923879532), T5j));
			      T5m = VADD(T5i, T5l);
			      T5q = VSUB(T5l, T5i);
			      T5n = VADD(T50, T4Z);
			      T5o = VMUL(LDK(KP707106781), VADD(T4w, T4z));
			      T5p = VSUB(T5n, T5o);
			      T5v = VADD(T5n, T5o);
			 }
			 T69 = VSUB(T5f, T5m);
			 STM4(&(ro[18]), T69, ovs, &(ro[0]));
			 T6a = VSUB(T5v, T5w);
			 STM4(&(io[18]), T6a, ovs, &(io[0]));
			 T6b = VADD(T5f, T5m);
			 STM4(&(ro[2]), T6b, ovs, &(ro[0]));
			 T6c = VADD(T5v, T5w);
			 STM4(&(io[2]), T6c, ovs, &(io[0]));
			 T6d = VSUB(T5p, T5q);
			 STM4(&(io[26]), T6d, ovs, &(io[0]));
			 T6e = VSUB(T5r, T5u);
			 STM4(&(ro[26]), T6e, ovs, &(ro[0]));
			 T6f = VADD(T5p, T5q);
			 STM4(&(io[10]), T6f, ovs, &(io[0]));
			 T6g = VADD(T5r, T5u);
			 STM4(&(ro[10]), T6g, ovs, &(ro[0]));
		    }
		    {
			 V T5z, T5P, T5S, T5U, T5K, T5O, T5N, T5T;
			 {
			      V T5x, T5y, T5Q, T5R;
			      T5x = VSUB(T7, Te);
			      T5y = VSUB(T1n, T1u);
			      T5z = VADD(T5x, T5y);
			      T5P = VSUB(T5x, T5y);
			      T5Q = VSUB(T5D, T5A);
			      T5R = VADD(T5F, T5I);
			      T5S = VMUL(LDK(KP707106781), VSUB(T5Q, T5R));
			      T5U = VMUL(LDK(KP707106781), VADD(T5Q, T5R));
			 }
			 {
			      V T5E, T5J, T5L, T5M;
			      T5E = VADD(T5A, T5D);
			      T5J = VSUB(T5F, T5I);
			      T5K = VMUL(LDK(KP707106781), VADD(T5E, T5J));
			      T5O = VMUL(LDK(KP707106781), VSUB(T5J, T5E));
			      T5L = VSUB(T18, T1f);
			      T5M = VSUB(Tt, Tm);
			      T5N = VSUB(T5L, T5M);
			      T5T = VADD(T5M, T5L);
			 }
			 T6h = VSUB(T5z, T5K);
			 STM4(&(ro[20]), T6h, ovs, &(ro[0]));
			 T6i = VSUB(T5T, T5U);
			 STM4(&(io[20]), T6i, ovs, &(io[0]));
			 T6j = VADD(T5z, T5K);
			 STM4(&(ro[4]), T6j, ovs, &(ro[0]));
			 T6k = VADD(T5T, T5U);
			 STM4(&(io[4]), T6k, ovs, &(io[0]));
			 T6l = VSUB(T5N, T5O);
			 STM4(&(io[28]), T6l, ovs, &(io[0]));
			 T6m = VSUB(T5P, T5S);
			 STM4(&(ro[28]), T6m, ovs, &(ro[0]));
			 T6n = VADD(T5N, T5O);
			 STM4(&(io[12]), T6n, ovs, &(io[0]));
			 T6o = VADD(T5P, T5S);
			 STM4(&(ro[12]), T6o, ovs, &(ro[0]));
		    }
		    {
			 V Tv, T5V, T5Y, T60, T10, T11, T1w, T5Z;
			 {
			      V Tf, Tu, T5W, T5X;
			      Tf = VADD(T7, Te);
			      Tu = VADD(Tm, Tt);
			      Tv = VADD(Tf, Tu);
			      T5V = VSUB(Tf, Tu);
			      T5W = VADD(T5B, T5C);
			      T5X = VADD(T5G, T5H);
			      T5Y = VSUB(T5W, T5X);
			      T60 = VADD(T5W, T5X);
			 }
			 {
			      V TK, TZ, T1g, T1v;
			      TK = VADD(TC, TJ);
			      TZ = VADD(TR, TY);
			      T10 = VADD(TK, TZ);
			      T11 = VSUB(TZ, TK);
			      T1g = VADD(T18, T1f);
			      T1v = VADD(T1n, T1u);
			      T1w = VSUB(T1g, T1v);
			      T5Z = VADD(T1g, T1v);
			 }
			 T6p = VSUB(Tv, T10);
			 STM4(&(ro[16]), T6p, ovs, &(ro[0]));
			 T6q = VSUB(T5Z, T60);
			 STM4(&(io[16]), T6q, ovs, &(io[0]));
			 T6r = VADD(Tv, T10);
			 STM4(&(ro[0]), T6r, ovs, &(ro[0]));
			 T6s = VADD(T5Z, T60);
			 STM4(&(io[0]), T6s, ovs, &(io[0]));
			 T6t = VADD(T11, T1w);
			 STM4(&(io[8]), T6t, ovs, &(io[0]));
			 T6u = VADD(T5V, T5Y);
			 STM4(&(ro[8]), T6u, ovs, &(ro[0]));
			 T6v = VSUB(T1w, T11);
			 STM4(&(io[24]), T6v, ovs, &(io[0]));
			 T6w = VSUB(T5V, T5Y);
			 STM4(&(ro[24]), T6w, ovs, &(ro[0]));
		    }
		    {
			 V T6x, T6y, T6z, T6A, T6B, T6C, T6D, T6E;
			 {
			      V T1X, T33, T31, T37, T2o, T34, T2P, T35;
			      {
				   V T1H, T1W, T2X, T30;
				   T1H = VSUB(T1z, T1G);
				   T1W = VSUB(T1O, T1V);
				   T1X = VADD(T1H, T1W);
				   T33 = VSUB(T1H, T1W);
				   T2X = VSUB(T2T, T2W);
				   T30 = VSUB(T2Y, T2Z);
				   T31 = VSUB(T2X, T30);
				   T37 = VADD(T2X, T30);
			      }
			      {
				   V T2e, T2n, T2F, T2O;
				   T2e = VSUB(T22, T2d);
				   T2n = VSUB(T2j, T2m);
				   T2o = VFMA(LDK(KP980785280), T2e, VMUL(LDK(KP195090322), T2n));
				   T34 = VFNMS(LDK(KP980785280), T2n, VMUL(LDK(KP195090322), T2e));
				   T2F = VSUB(T2t, T2E);
				   T2O = VSUB(T2K, T2N);
				   T2P = VFNMS(LDK(KP980785280), T2O, VMUL(LDK(KP195090322), T2F));
				   T35 = VFMA(LDK(KP195090322), T2O, VMUL(LDK(KP980785280), T2F));
			      }
			      {
				   V T2Q, T38, T32, T36;
				   T2Q = VADD(T2o, T2P);
				   T6x = VSUB(T1X, T2Q);
				   STM4(&(ro[23]), T6x, ovs, &(ro[1]));
				   T6y = VADD(T1X, T2Q);
				   STM4(&(ro[7]), T6y, ovs, &(ro[1]));
				   T38 = VADD(T34, T35);
				   T6z = VSUB(T37, T38);
				   STM4(&(io[23]), T6z, ovs, &(io[1]));
				   T6A = VADD(T37, T38);
				   STM4(&(io[7]), T6A, ovs, &(io[1]));
				   T32 = VSUB(T2P, T2o);
				   T6B = VSUB(T31, T32);
				   STM4(&(io[31]), T6B, ovs, &(io[1]));
				   T6C = VADD(T31, T32);
				   STM4(&(io[15]), T6C, ovs, &(io[1]));
				   T36 = VSUB(T34, T35);
				   T6D = VSUB(T33, T36);
				   STM4(&(ro[31]), T6D, ovs, &(ro[1]));
				   T6E = VADD(T33, T36);
				   STM4(&(ro[15]), T6E, ovs, &(ro[1]));
			      }
			 }
			 {
			      V T3D, T41, T3Z, T45, T3K, T42, T3R, T43;
			      {
				   V T3v, T3C, T3V, T3Y;
				   T3v = VSUB(T3t, T3u);
				   T3C = VSUB(T3y, T3B);
				   T3D = VADD(T3v, T3C);
				   T41 = VSUB(T3v, T3C);
				   T3V = VSUB(T3T, T3U);
				   T3Y = VSUB(T3W, T3X);
				   T3Z = VSUB(T3V, T3Y);
				   T45 = VADD(T3V, T3Y);
			      }
			      {
				   V T3G, T3J, T3N, T3Q;
				   T3G = VSUB(T3E, T3F);
				   T3J = VSUB(T3H, T3I);
				   T3K = VFMA(LDK(KP555570233), T3G, VMUL(LDK(KP831469612), T3J));
				   T42 = VFNMS(LDK(KP831469612), T3G, VMUL(LDK(KP555570233), T3J));
				   T3N = VSUB(T3L, T3M);
				   T3Q = VSUB(T3O, T3P);
				   T3R = VFNMS(LDK(KP831469612), T3Q, VMUL(LDK(KP555570233), T3N));
				   T43 = VFMA(LDK(KP831469612), T3N, VMUL(LDK(KP555570233), T3Q));
			      }
			      {
				   V T3S, T6F, T6G, T46, T6H, T6I;
				   T3S = VADD(T3K, T3R);
				   T6F = VSUB(T3D, T3S);
				   STM4(&(ro[21]), T6F, ovs, &(ro[1]));
				   STN4(&(ro[20]), T6h, T6F, T61, T6x, ovs);
				   T6G = VADD(T3D, T3S);
				   STM4(&(ro[5]), T6G, ovs, &(ro[1]));
				   STN4(&(ro[4]), T6j, T6G, T63, T6y, ovs);
				   T46 = VADD(T42, T43);
				   T6H = VSUB(T45, T46);
				   STM4(&(io[21]), T6H, ovs, &(io[1]));
				   STN4(&(io[20]), T6i, T6H, T62, T6z, ovs);
				   T6I = VADD(T45, T46);
				   STM4(&(io[5]), T6I, ovs, &(io[1]));
				   STN4(&(io[4]), T6k, T6I, T64, T6A, ovs);
			      }
			      {
				   V T40, T6J, T6K, T44, T6L, T6M;
				   T40 = VSUB(T3R, T3K);
				   T6J = VSUB(T3Z, T40);
				   STM4(&(io[29]), T6J, ovs, &(io[1]));
				   STN4(&(io[28]), T6l, T6J, T65, T6B, ovs);
				   T6K = VADD(T3Z, T40);
				   STM4(&(io[13]), T6K, ovs, &(io[1]));
				   STN4(&(io[12]), T6n, T6K, T67, T6C, ovs);
				   T44 = VSUB(T42, T43);
				   T6L = VSUB(T41, T44);
				   STM4(&(ro[29]), T6L, ovs, &(ro[1]));
				   STN4(&(ro[28]), T6m, T6L, T66, T6D, ovs);
				   T6M = VADD(T41, T44);
				   STM4(&(ro[13]), T6M, ovs, &(ro[1]));
				   STN4(&(ro[12]), T6o, T6M, T68, T6E, ovs);
			      }
			 }
		    }
		    {
			 V T6N, T6O, T6P, T6Q, T6R, T6S, T6T, T6U;
			 {
			      V T49, T4l, T4j, T4p, T4c, T4m, T4f, T4n;
			      {
				   V T47, T48, T4h, T4i;
				   T47 = VADD(T3t, T3u);
				   T48 = VADD(T3X, T3W);
				   T49 = VADD(T47, T48);
				   T4l = VSUB(T47, T48);
				   T4h = VADD(T3T, T3U);
				   T4i = VADD(T3y, T3B);
				   T4j = VSUB(T4h, T4i);
				   T4p = VADD(T4h, T4i);
			      }
			      {
				   V T4a, T4b, T4d, T4e;
				   T4a = VADD(T3E, T3F);
				   T4b = VADD(T3H, T3I);
				   T4c = VFMA(LDK(KP980785280), T4a, VMUL(LDK(KP195090322), T4b));
				   T4m = VFNMS(LDK(KP195090322), T4a, VMUL(LDK(KP980785280), T4b));
				   T4d = VADD(T3L, T3M);
				   T4e = VADD(T3O, T3P);
				   T4f = VFNMS(LDK(KP195090322), T4e, VMUL(LDK(KP980785280), T4d));
				   T4n = VFMA(LDK(KP195090322), T4d, VMUL(LDK(KP980785280), T4e));
			      }
			      {
				   V T4g, T4q, T4k, T4o;
				   T4g = VADD(T4c, T4f);
				   T6N = VSUB(T49, T4g);
				   STM4(&(ro[17]), T6N, ovs, &(ro[1]));
				   T6O = VADD(T49, T4g);
				   STM4(&(ro[1]), T6O, ovs, &(ro[1]));
				   T4q = VADD(T4m, T4n);
				   T6P = VSUB(T4p, T4q);
				   STM4(&(io[17]), T6P, ovs, &(io[1]));
				   T6Q = VADD(T4p, T4q);
				   STM4(&(io[1]), T6Q, ovs, &(io[1]));
				   T4k = VSUB(T4f, T4c);
				   T6R = VSUB(T4j, T4k);
				   STM4(&(io[25]), T6R, ovs, &(io[1]));
				   T6S = VADD(T4j, T4k);
				   STM4(&(io[9]), T6S, ovs, &(io[1]));
				   T4o = VSUB(T4m, T4n);
				   T6T = VSUB(T4l, T4o);
				   STM4(&(ro[25]), T6T, ovs, &(ro[1]));
				   T6U = VADD(T4l, T4o);
				   STM4(&(ro[9]), T6U, ovs, &(ro[1]));
			      }
			 }
			 {
			      V T3b, T3n, T3l, T3r, T3e, T3o, T3h, T3p;
			      {
				   V T39, T3a, T3j, T3k;
				   T39 = VADD(T1z, T1G);
				   T3a = VADD(T2Z, T2Y);
				   T3b = VADD(T39, T3a);
				   T3n = VSUB(T39, T3a);
				   T3j = VADD(T2T, T2W);
				   T3k = VADD(T1O, T1V);
				   T3l = VSUB(T3j, T3k);
				   T3r = VADD(T3j, T3k);
			      }
			      {
				   V T3c, T3d, T3f, T3g;
				   T3c = VADD(T22, T2d);
				   T3d = VADD(T2j, T2m);
				   T3e = VFMA(LDK(KP555570233), T3c, VMUL(LDK(KP831469612), T3d));
				   T3o = VFNMS(LDK(KP555570233), T3d, VMUL(LDK(KP831469612), T3c));
				   T3f = VADD(T2t, T2E);
				   T3g = VADD(T2K, T2N);
				   T3h = VFNMS(LDK(KP555570233), T3g, VMUL(LDK(KP831469612), T3f));
				   T3p = VFMA(LDK(KP831469612), T3g, VMUL(LDK(KP555570233), T3f));
			      }
			      {
				   V T3i, T6V, T6W, T3s, T6X, T6Y;
				   T3i = VADD(T3e, T3h);
				   T6V = VSUB(T3b, T3i);
				   STM4(&(ro[19]), T6V, ovs, &(ro[1]));
				   STN4(&(ro[16]), T6p, T6N, T69, T6V, ovs);
				   T6W = VADD(T3b, T3i);
				   STM4(&(ro[3]), T6W, ovs, &(ro[1]));
				   STN4(&(ro[0]), T6r, T6O, T6b, T6W, ovs);
				   T3s = VADD(T3o, T3p);
				   T6X = VSUB(T3r, T3s);
				   STM4(&(io[19]), T6X, ovs, &(io[1]));
				   STN4(&(io[16]), T6q, T6P, T6a, T6X, ovs);
				   T6Y = VADD(T3r, T3s);
				   STM4(&(io[3]), T6Y, ovs, &(io[1]));
				   STN4(&(io[0]), T6s, T6Q, T6c, T6Y, ovs);
			      }
			      {
				   V T3m, T6Z, T70, T3q, T71, T72;
				   T3m = VSUB(T3h, T3e);
				   T6Z = VSUB(T3l, T3m);
				   STM4(&(io[27]), T6Z, ovs, &(io[1]));
				   STN4(&(io[24]), T6v, T6R, T6d, T6Z, ovs);
				   T70 = VADD(T3l, T3m);
				   STM4(&(io[11]), T70, ovs, &(io[1]));
				   STN4(&(io[8]), T6t, T6S, T6f, T70, ovs);
				   T3q = VSUB(T3o, T3p);
				   T71 = VSUB(T3n, T3q);
				   STM4(&(ro[27]), T71, ovs, &(ro[1]));
				   STN4(&(ro[24]), T6w, T6T, T6e, T71, ovs);
				   T72 = VADD(T3n, T3q);
				   STM4(&(ro[11]), T72, ovs, &(ro[1]));
				   STN4(&(ro[8]), T6u, T6U, T6g, T72, ovs);
			      }
			 }
		    }
	       }
	  }
     }
     VLEAVE();
}

static const kdft_desc desc = { 32, XSIMD_STRING("n2sv_32"), {340, 52, 32, 0}, &GENUS, 0, 1, 0, 0 };

void XSIMD(codelet_n2sv_32) (planner *p) {
     X(kdft_register) (p, n2sv_32, &desc);
}

#endif				/* HAVE_FMA */
