#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/ptrace.h>
#include <asm/ptrace.h>
#include "mxcfb.h"


int main( int argc, char *argv[] )
{

	int i;
	__u8 buffer[100];
	
	pid_t p;
	struct mxcfb_update_data *updata;
printf("arv2: %s\n",argv[2]);
char *args[3] = {"-qws","-qws",0};
	if (!(p=fork()))
	{
		ptrace(PTRACE_TRACEME, 0, 0, 0);
		 execv( argv[1], &argv[1]);
		//execv( argv[1], args);
	}

	int status, io = 0;

	waitpid( p, &status, 0 );
	while( ptrace( PTRACE_SYSCALL, p, 0, 0 ) == 0 )
	{
		struct pt_regs regs;
		int i, len;
		unsigned int data;

		waitpid( p, &status, 0 );
		if( WIFEXITED( status ) )
		{
			printf("exit\n" );
			break;
		}
		
		ptrace(PTRACE_GETREGS, p, 0, &regs);

	/*	#define MXCFB_SEND_UPDATE		_IOW('F', 0x2E, struct mxcfb_update_data)
#define MXCFB_WAIT_FOR_UPDATE_COMPLETE	_IOW('F', 0x2F, __u32)
*/
		
		// List of syscall number is defined in kernel_source_root/arch/arm/include/asm/asm/unistd.h
		if ( (regs.uregs[7] == 0x00000036) && ((regs.uregs[1] & 0xff000000) == 0x40000000) )
		{
		// case 0x00000036regs.uregs[1]: // ioctl
		printf("enter/leave syscall %lx\n Regs: ", regs.uregs[7] );
		for( i = 0; i < 8; i ++ )
			printf( "0x%08lx ", regs.uregs[i] );
		printf("\n       ");
		for( i = 8; i < 16; i ++ )
			printf( "0x%08lx ", regs.uregs[i] );
		printf("\n       ");
		for( i = 16; i < 18; i ++ )
			printf( "0x%08lx ", regs.uregs[i] );
		printf("\n");
			len = ( regs.uregs[1] & 0x1FFF0000 ) >> 16;
			printf( " ioctl 0x%08lx ( sizeof(arg) = %d )\n", regs.uregs[1], len );
	

	
	

			if( len > 0 )
			{ 
				
				printf( " Memdump: 0x%08lx", regs.uregs[2] );
				for( i = 0; i < len; i ++ )
				{
					if( i % 8 == 0 )
					{
						printf("\n  ");
					}
					data = ptrace( PTRACE_PEEKDATA, p, (void*)( regs.uregs[2] + i ), &data );
		buffer[i] = (__u8) (data & 0xFF);
					printf( "%02lx ", data & 0xFF );
				}
				printf("\n");
			}
if ((regs.uregs[1] & 0xff) == 0x2e) 
	{
	updata = (struct mxcfb_update_data *) buffer;
	printf("waveform_mode: %d\n",(updata->waveform_mode));
	printf("update_mode: %d\n",(updata->update_mode));
	printf("flags: %d\n",(updata->flags));
	printf("top: %d\n ",(updata->update_region.top));
	printf("left: %d\n ",(updata->update_region.left));
	printf("width: %d\n ",updata->update_region.width);
	printf("height: %d\n ",updata->update_region.height);
	}
		}

		fflush(stdout);
	}
	return 0;
}
