// screenplugin.cpp
//
// Copyright (C) 2010, 2009 Griffin I'Net, Inc. (blog@griffin.net)
//
// This file is licensed under the LGPL version 2.1, the text of which should
// be in the LICENSE.txt file, or alternately at this location:
// http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt
//
// DISCLAIMER: This software is released AS-IS with ABSOLUTELY NO WARRANTY OF
// ANY KIND.  The use of this software indicates your knowledge and acceptance
// of this.

#include "screenplugin.h"
#include "kindlescreen.h"


ScreenPlugin::ScreenPlugin() : QScreenDriverPlugin()
{
    // NOP
}

QStringList ScreenPlugin::keys() const
{
    QStringList list;
    list << QLatin1String("KindleFb");
    list << QLatin1String("KindleDirectFb");
    return list;
}

QScreen* ScreenPlugin::create(const QString& driver, int displayId)
{
    if (driver.toLower() == QLatin1String("kindlefb"))
        return new KindleScreen(displayId, false);
    else if (driver.toLower() == QLatin1String("kindledirectfb"))
        return new KindleScreen(displayId, true);

    return 0;
}

Q_EXPORT_PLUGIN2(KindleFb, ScreenPlugin)
