// kindlescreenthread.cpp
//
// Copyright (C) 2010, 2009 Griffin I'Net, Inc. (blog@griffin.net)
//
// This file is licensed under the LGPL version 2.1, the text of which should
// be in the LICENSE.txt file, or alternately at this location:
// http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt
//
// DISCLAIMER: This software is released AS-IS with ABSOLUTELY NO WARRANTY OF
// ANY KIND.  The use of this software indicates your knowledge and acceptance
// of this.

#include <fcntl.h>
#include <asm/types.h>
typedef __u8 u8;
#include "mxcfb.h"
#include <sys/ioctl.h>
#include "kindlescreen.h"
#include <QFile>

#include "kindlescreenthread.h"

KindleScreenThread::KindleScreenThread(KindleScreen* screen, QObject* parent) : QThread(parent)
{
    _screen = screen;
    _quit = false;
}

KindleScreenThread::~KindleScreenThread()
{
    quitNow();
}

void KindleScreenThread::quitNow()
{
    _quit = true;
    wait();
}

void KindleScreenThread::run()
{
    while(!_quit)
    {
        _screen->_mutex.lock();
        if (_screen->_dirty)
        {
            QRect r = _screen->_updateRect;
            _screen->_dirty = false;
            _screen->_mutex.unlock();
            /*update_area_t ua;
            ua.x1 = r.left();
            ua.y1 = r.top();
            ua.x2 = r.right() + 1;
            ua.y2 = r.bottom() + 1;
            ua.which_fx = fx_invert;
            ua.buffer = NULL;
            ioctl(_screen->_fbd, FBIO_EINK_UPDATE_DISPLAY_AREA, &ua); */
 		struct mxcfb_update_data region;
                int marker;
                region.update_region.top = r.top();
                region.update_region.left = r.left();
                region.update_region.width = r.width();
                region.update_region.height = r.height() ;
                region.waveform_mode = WAVEFORM_MODE_AUTO;
                region.update_mode = UPDATE_MODE_PARTIAL ;
                region.update_marker = marker;
                region.temp = TEMP_USE_AMBIENT;
                region.flags = 0; ioctl(_screen->_fbd, MXCFB_SEND_UPDATE, &region);
                
        }
        else
        {
            _screen->_mutex.unlock();
        }

        msleep(50);
    }
}

