// kindlescreen.h
//
// Copyright (C) 2010, 2009 Griffin I'Net, Inc. (blog@griffin.net)
//
// This file is licensed under the LGPL version 2.1, the text of which should
// be in the LICENSE.txt file, or alternately at this location:
// http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt
//
// DISCLAIMER: This software is released AS-IS with ABSOLUTELY NO WARRANTY OF
// ANY KIND.  The use of this software indicates your knowledge and acceptance
// of this.

#ifndef KINDLESCREEN_H
#define KINDLESCREEN_H


#include <qscreenlinuxfb_qws.h>
#include <QThread>
#include <QRect>
#include <QMutex>
#include <QRegion>


class KindleScreenThread;

class KindleScreen : public QLinuxFbScreen
{
    friend class KindleScreenThread;
public:
    KindleScreen(int display_id, bool direct);
    virtual ~KindleScreen();

    virtual bool initDevice();
    virtual void shutdownDevice();

    virtual void solidFill(const QColor& color, const QRegion& region);
    virtual void blit(const QImage& image, const QPoint& topLeft, const QRegion& region);

    virtual void setDirty ( const QRect & rectangle );
    virtual void updateRect ( const QRect & rectangle );

    virtual int alloc(unsigned int red, unsigned int green, unsigned int blue);

protected:
    uchar* _dataLast;
    bool _dirty;
    QMutex _mutex;
    QRect _updateRect;
    int _fbd;
    int _type;

private:
    KindleScreenThread* _thread;
};


#endif // KINDLESCREEN_H
