// kindlescreen.cpp
//
// Copyright (C) 2010, 2009 Griffin I'Net, Inc. (blog@griffin.net)
//
// This file is licensed under the LGPL version 2.1, the text of which should
// be in the LICENSE.txt file, or alternately at this location:
// http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt
//
// DISCLAIMER: This software is released AS-IS with ABSOLUTELY NO WARRANTY OF
// ANY KIND.  The use of this software indicates your knowledge and acceptance
// of this.

#include <fcntl.h>
#include <asm/types.h>
typedef __u8 u8;
#include "mxcfb.h"
#include <sys/ioctl.h>
#include "kindlescreen.h"
#include <QFile>

#include "kindlescreenthread.h"


KindleScreen::KindleScreen(int display_id, bool direct) : QLinuxFbScreen(display_id)
{
    qDebug("KindleScreen(%d)", display_id);

    direct = !direct;

    if (direct)
        _type = 0;
    else
        _type = 1;

    _dirty = false;

    _dataLast = NULL;
}

KindleScreen::~KindleScreen()
{
    // NOP
}

bool KindleScreen::initDevice()
{
//    qDebug("KindleScreen::initDevice()");

    _fbd = open("/dev/fb0", O_RDWR);

    if (_fbd == -1)
        qDebug("FAILED to open framebuffer.");
//    else
//        qDebug("OPENED framebuffer!");

    if (_type == 0)
    {
        _thread = new KindleScreenThread(this);
        _thread->start();
    }
    else
        _thread = NULL;

    if (!QLinuxFbScreen::initDevice())
        return false;

//    QRgb* table = clut();
//
//    qDebug("Color table count: %d", colorCount());
//
//    for(int i=0;i<colorCount();i++)
//        qDebug("%d : %08X", i, (unsigned int)table[i]);

    if ((data != NULL) && (size > 0))
    {
        _dataLast = (uchar*)malloc(size);
        memcpy(_dataLast, data, size);
    }

    return true;
}

int KindleScreen::alloc(unsigned int red, unsigned int green, unsigned int blue)
{
//    return colorCount() - 1 - QLinuxFbScreen::alloc(red, green, blue);
    return QLinuxFbScreen::alloc(red, green, blue);
}

void KindleScreen::shutdownDevice()
{
//    qDebug("KindleScreen::shutdownDevice()");

    // TODO : stop screen update service here
    _thread->quitNow();
    delete _thread;

    QLinuxFbScreen::shutdownDevice();

    close(_fbd);

    if (_dataLast != NULL)
    {
        free(_dataLast);
        _dataLast = NULL;
    }
}

void KindleScreen::solidFill(const QColor& color, const QRegion& region)
{
    QLinuxFbScreen::solidFill(color, region);
}

void KindleScreen::blit(const QImage& image, const QPoint& topLeft, const QRegion& region)
{
    QImage imageInverted = image;
    imageInverted.invertPixels();

    QLinuxFbScreen::blit(imageInverted, topLeft, region);
}

/*
void KindleScreen::solidFill(const QColor& color, const QRegion& region)
{
    QLinuxFbScreen::solidFill(color, region);

    QRect r = region.boundingRect();

    if (!r.isNull())
    {
        qDebug("fill region: %d, %d, %d, %d", r.topLeft().x(), r.topLeft().y(), r.width(), r.height());
        updateRect(r);
    }
}

void KindleScreen::blit(const QImage& image, const QPoint& topLeft, const QRegion& region)
{
    QLinuxFbScreen::blit(image, topLeft, region);

    QRect b = region.boundingRect();

    if (!b.isNull())
    {
        QRect r(topLeft, QPoint(b.width() - 1, b.height() - 1));
        qDebug("region: %d, %d, %d, %d", r.topLeft().x(), r.topLeft().y(), r.width(), r.height());

        updateRect(r);
    }
}
*/

void KindleScreen::setDirty ( const QRect & r )
{
    updateRect(r);
//    qDebug("setDirty: %d, %d, %d, %d", r.topLeft().x(), r.topLeft().y(), r.width(), r.height());

    QLinuxFbScreen::setDirty(r);
}

void KindleScreen::updateRect ( const QRect & rc )
{
    QRect r = rc;

//    qDebug("updateRect: %d, %d, %d, %d", r.topLeft().x(), r.topLeft().y(), r.width(), r.height());

    if (data != NULL)
    {
        // STATE: compare with image copy

//        qDebug("updateRect() : data = %p, size = %d, dh = %d, dw = %d", data, size, dh, dw);

        int adw = dw / 2;

        uchar* cmpData = data;
        uchar* cmpDataLast = _dataLast;
        for(int i=0;i<dh*adw;i++)
        {
            if (*(cmpData++) != *(cmpDataLast++))
            {
                cmpData--;
                break;
            }
        }

        // find first change
        int position = cmpData - data;
        int sy = position / adw;

        if (sy >= dh)
        {
            // STATE: nothing changed!
//            qDebug("NC");
            _mutex.unlock();
            return;
        }

        // find last change
        cmpData = data + size - 1;
        cmpDataLast = _dataLast + size - 1;
        for(int i=0;i<dh*adw;i++)
        {
            if (*(cmpData--) != *(cmpDataLast--))
            {
                cmpData++;
                break;
            }
        }

        position = cmpData - data;
        int ey = position / adw;

        // find start x
        int sx = adw;
        for(int y=sy;y<=ey;y++)
        {
            cmpData = data + y * adw;
            cmpDataLast = _dataLast + y * adw;
            for(int x=0;x<sx;x++)
            {
                if (*(cmpData++) != *(cmpDataLast++))
                {
                    sx = x;
                    if (sx == 0)
                        break;
                }
            }
            if (sx == 0)
                break;
        }

        // find end x
        int ex = adw;
        for(int y=sy+1;y<=ey+1;y++)
        {
            cmpData = data + y * adw - 1;
            cmpDataLast = _dataLast + y * adw - 1;
            for(int x=0;x<ex;x++)
            {
                if (*(cmpData--) != *(cmpDataLast--))
                {
                    ex = x;
                    if (sx == 0)
                        break;
                }
            }
            if (sx == 0)
                break;
        }

        // expand rectange by one pixel (2 for x) in all directions just in case
        if (sx > 0)
            sx--;
        if (sy > 0)
            sy--;
        if (ey < dh - 1)
            ey++;

        sx = sx * 2;
        ex = (adw - ex - 1) * 2;
        if (ex < adw - 1)
            ex++;

//        qDebug("%d,%d-%d,%d", sx, sy, ex, ey);

        //r.setCoords(r.left(), sy, r.right(), ey);
        r.setCoords(sx, sy, ex, ey);

        memcpy(_dataLast + sy * adw, data + sy * adw, ((ey - sy + 1) * adw));
    }

    if (_type == 1)
    {
        _mutex.lock();
        _dirty = true;
        _updateRect = _updateRect.united(r);
        _mutex.unlock();
    }
    else
    {
        struct mxcfb_update_data region;
                int marker;
                region.update_region.top = 0;
                region.update_region.left = 0;
                region.update_region.width = 800;
                region.update_region.height = 600 ;
                region.waveform_mode = WAVEFORM_MODE_AUTO;
                region.update_mode = UPDATE_MODE_FULL ;
                region.update_marker = marker;
                region.temp = TEMP_USE_AMBIENT;
                region.flags = 0;
                ioctl(_fbd, MXCFB_SEND_UPDATE, &region);
		ioctl(_fbd, 0x4040462e, &region);




       /* update_area_t ua;
        ua.x1 = r.left();
        ua.y1 = r.top();
        ua.x2 = r.right() + 1;
        ua.y2 = r.bottom() + 1;
        ua.which_fx = fx_update_partial; //fx_invert;
        ua.buffer = NULL;
        ioctl(_fbd, FBIO_EINK_UPDATE_DISPLAY_AREA, &ua); */
    }
}
