package com.mobileread.ixtab.imgex;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import org.json.simple.JSONObject;

import com.amazon.ebook.pl.SystemServices;
import com.amazon.ebook.util.lang.UUID;
import com.amazon.ebook.util.text.LString;
import com.amazon.kindle.content.catalog.CatalogEntry;
import com.amazon.kindle.content.catalog.CatalogService;
import com.amazon.kindle.content.catalog.CatalogTransaction;
import com.amazon.kindle.content.catalog.CatalogTransaction.TransactionResult;
import com.amazon.kindle.content.catalog.MutableCollection;
import com.amazon.kindle.content.catalog.MutableEntry;
import com.amazon.kindle.content.catalog.MutableItem;
import com.amazon.kindle.restricted.content.catalog.k;
import com.amazon.kindle.restricted.content.catalog.p;
import com.amazon.kindle.restricted.content.catalog.z;
import com.amazon.kindle.restricted.runtime.Framework;

public class ImageExtractUI extends JPanel {

	private final JButton diagsButton = new JButton("Dump diagnostics partition");
	private final JButton mainButton = new JButton("Dump main partition");
	private final JButton kernelsButton = new JButton("Dump kernels");
	private final JLabel label = new JLabel("ImageExtract 1.0.1 by ixtab");
	
	public ImageExtractUI(Container root) {
		root.setLayout(new BorderLayout());
		root.add(this);
		root.validate();
	}

	private static final long serialVersionUID = -8491590137002394394L;

	public void init() {
		JPanel buttons = new JPanel();
		buttons.setLayout(new BoxLayout(buttons, BoxLayout.Y_AXIS));
		buttons.add(Box.createVerticalGlue());
		buttons.add(mainButton);
		buttons.add(Box.createVerticalGlue());
		buttons.add(diagsButton);
		buttons.add(Box.createVerticalGlue());
		buttons.add(kernelsButton);
		buttons.add(Box.createVerticalGlue());
		this.setLayout(new BorderLayout(30,30));
		this.setBorder(BorderFactory.createLineBorder(Color.WHITE, 30));
		this.add(buttons, BorderLayout.CENTER);
		this.add(label, BorderLayout.SOUTH);
		this.validate();
		
		boolean ok = extract("main.sh");
		if (ok) ok = extract("diags.sh");
		if (ok) ok = extract("getkernels.sh");
		if (!ok) {
			mainButton.setEnabled(false);
			diagsButton.setEnabled(false);
			kernelsButton.setEnabled(false);
		}
		addButtonAction(mainButton, "/tmp/main.sh", "/mnt/us/mmcblk0p1.img.gz");
		addButtonAction(diagsButton, "/tmp/diags.sh", "/mnt/us/mmcblk0p2.img.gz");
		addButtonAction(kernelsButton, "/tmp/getkernels.sh /dev/mmcblk0", null);
	}

	private boolean extract(String resource) {
		try {
			String output = "/tmp/"+resource;
			InputStream is = getClass().getResourceAsStream(resource);
			FileOutputStream os = new FileOutputStream(output);
			copy(is,os);
			Process p = exec("chmod 755 "+output);
			p.waitFor();
			return p.exitValue() == 0;
		} catch (Throwable t) {
			label.setText("Error while extracting "+resource);
			t.printStackTrace();
			return false;
		}
	}

	private void copy(InputStream is, FileOutputStream os) throws IOException {
		byte[] buf = new byte[1024];
		for (int read = is.read(buf); read > 0; read = is.read(buf)) {
			os.write(buf, 0, read);
		}
		is.close();
		os.close();
	}

	private Process exec(String command) throws Exception {
		return Runtime.getRuntime().exec(command);
	}

	private void enableButtons(boolean b) {
		mainButton.setEnabled(b);
		diagsButton.setEnabled(b);
		kernelsButton.setEnabled(b);
	}

	private void addButtonAction(final JButton button, final String command,
			final String outputFile) {
		button.addActionListener(new ActionListener() {
			
			public void actionPerformed(ActionEvent e) {
				enableButtons(false);
				label.setText("Action running, please wait...");
				
				FileWatchThread watchdog = null;
				if (outputFile != null) {
					watchdog = new FileWatchThread(outputFile);
				}
				
				new ProcessThread(command, watchdog).start();
			}

		});
	}

	private class FileWatchThread extends Thread {
		private volatile boolean shutdown = false;
		private final File file;
		
		private FileWatchThread(String filename) {
			file = new File(filename);
		}

		public void run() {
			synchronized (this) {
				while (!shutdown) {
					try {
						this.wait(1000);
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
					if (shutdown) {
						break;
					}
					final StringBuffer status = new StringBuffer(file.toString());
					status.append(": ");
					if (!file.exists() || !file.isFile()) {
						status.append(" nonexistent");
					} else {
						status.append(file.length());
						status.append(" bytes");
					}
					
					SwingUtilities.invokeLater(new Runnable() {
						
						public void run() {
							label.setText(status.toString());
						}
					});
				}
			}
		}
	}
	
	private class ProcessThread extends Thread {

		private final String command;
		private final FileWatchThread watch;
		public ProcessThread(String command,
				FileWatchThread watchdog) {
			this.command = command;
			this.watch = watchdog;
		}
		
		public void run() {
			int exit = -1;
			try {
				if (watch != null) watch.start();
				Process p = exec(command);
				p.waitFor();
				exit = p.exitValue();
			} catch (Throwable t) {
				t.printStackTrace();
				exit = -1;
			}
			if (watch != null) {
				synchronized (watch) {
					watch.shutdown = true;
					watch.notifyAll();
				}
			}
			final StringBuffer status = new StringBuffer();
			if (exit == 0) {
				status.append("Process exited successfully");
			} else {
				status.append("Process exited with errors");
			}
			SwingUtilities.invokeLater(new Runnable() {
				
				public void run() {
					label.setText(status.toString());
					enableButtons(true);
				}
			});
		}
		
		
	}
}
