#!/bin/sh
#===================================================================================
# getkernels v1.3 - get kernel images from kindle mmc device or backup image file
# Usage:
#   getkernels /dev/mmcblk0 : get linux kernel(s) from mmc
#   getkernels mmcblk0.img : get linux kernel(s) from file
# Copyright (C) 2012 by geekmaster
# Licensed under the MIT license: http://www.opensource.org/licenses/mit-license.php
#-----------------------------------------------------------------------------------
IN="$1"; [[ "$IN" == "" ]]&& head -n6 $0|tail -n4 && exit
BS=1024; BI=$((32*1024*1024/BS)); S1=$((0x41000/BS)); S2=$((0xe41000/BS)) 
DN=/dev/null; KF=_kernel.img; MK=/mnt/us/main$KF; DK=/mnt/us/diags$KF; R=1                         
EM="No linux kernels found in $IN"; ED="No diags kernel found in $IN"
echo "Searching for linux kernels in $IN ..."                        
HD="$(dd if=$IN bs=$BS skip=$S1 count=$R 2>$DN|hexdump -C|grep -B2 Linux-|cut -b-60)"
[[ "$HD" == "" ]]&& echo $EM && exit                                                 
set $(echo $HD); [[ $# -lt 16 ]]&& echo $EM && exit
shift 13; BO=$(((0x$1$2$3$4+64+$BS-1)/$BS))
dd if=$IN of=$MK bs=$BS skip=$S1 count=$BO && echo "~> $MK"
HD="$(dd if=$IN bs=$BS skip=$S2 count=$R 2>$DN|hexdump -C|grep -B2 Linux-|cut -b-60)" 
[[ "$HD" == "" ]]&& echo $ED && exit                                                 
set $(echo $HD); [[ $# -lt 16 ]]&& echo $ED && exit
shift 13; BO=$(((0x$1$2$3$4+$BS-1)/$BS))
dd if=$IN of=$DK bs=$BS skip=$S2 count=$BO && echo "~> $DK"  