#!/bin/sh

# By Yifan Lu
# Let's try to use as much of Amazon's functions as we can

LIPC_SET_PROP=/usr/bin/lipc-set-prop
LIPC_GET_PROP=/usr/bin/lipc-get-prop
USBNET_STATUS=/tmp/USBNET_ON
USE_USBNET=1
EXTENSION=/mnt/us/extensions/usbnetwork

# set root password?
if [ "$1" == "password" -a ! -z "$2" ]; then
	PASSWORD=$2
	mntroot rw
	passwd root <<EOF
${PASSWORD}
${PASSWORD}
EOF
	mntroot ro
fi

rm "${EXTENSION}/menu.json"
if [ -f "${USBNET_STATUS}" ]; then
	USE_USBNET=0
	rm -f "${USBNET_STATUS}"
	iptables -D INPUT -i wlan0 -p tcp --dport ssh -j ACCEPT
	cp -a "${EXTENSION}/start.json" "${EXTENSION}/menu.json"
else
	USE_USBNET=1
	touch "${USBNET_STATUS}"
	iptables -A INPUT -i wlan0 -p tcp --dport ssh -j ACCEPT
	cp -a "${EXTENSION}/stop.json" "${EXTENSION}/menu.json"
fi

${LIPC_SET_PROP} -i -- com.lab126.volumd useUsbForNetwork ${USE_USBNET}
