/*
 * Decompiled with CFR 0.152.
 */
package com.yifanlu.Kindle;

import com.amazon.ebook.util.log.LogMessage;
import com.yifanlu.Kindle.KindleLauncher;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class JARClassLoader
extends URLClassLoader {
    private static JARClassLoader myInstance;
    private static final LogMessage JAR_LOAD_ERROR;

    static {
        JAR_LOAD_ERROR = new LogMessage("JarLoad", new String[]{"jar file", "java error"});
    }

    private JARClassLoader() {
        super(new URL[0]);
    }

    public void addURL(URL url) {
        super.addURL(url);
    }

    public static JARClassLoader getInstance() {
        if (myInstance == null) {
            myInstance = new JARClassLoader();
        }
        return myInstance;
    }

    public void addJar(File jarFile) {
        try {
            URL jarURL = jarFile.toURI().toURL();
            this.addURL(jarURL);
        }
        catch (MalformedURLException e) {
            KindleLauncher.LOG.error(JAR_LOAD_ERROR, new String[]{jarFile.getAbsolutePath(), e.toString()}, "");
            e.printStackTrace();
        }
    }
}

