/*
 * Decompiled with CFR 0.152.
 */
package com.yifanlu.Kindle;

import com.amazon.agui.swing.MenuDialog;
import com.amazon.kindle.util.lipc.LipcException;
import com.amazon.kindle.util.lipc.LipcService;
import com.yifanlu.Kindle.KindleLauncher;
import com.yifanlu.Kindle.LauncherAction;
import edu.emory.mathcs.backport.java.util.PriorityQueue;
import javax.swing.Action;

public class LauncherMenu
extends LauncherAction {
    private static final long serialVersionUID = 1L;
    private MenuDialog mDialog;
    private PriorityQueue mItems = new PriorityQueue();
    private LauncherMenu mParent;

    public LauncherMenu(String name, int priority) {
        this(name, priority, (LauncherMenu)null);
    }

    public LauncherMenu(String name, int priority, LauncherMenu parent) {
        super(name, priority);
        this.mParent = parent;
        this.setHasArrow(true);
    }

    public synchronized void doAction() {
        this.getMenu().postDialog(this.getCurrentAppId(), true);
        if (this.mParent != null) {
            this.mParent.putValue("Name", this.mParent.getValue());
        }
    }

    private String getCurrentAppId() {
        try {
            return LipcService.getInstance().getDefaultSource().getTarget("com.lab126.appmgrd").getStringProperty("activeApp");
        }
        catch (LipcException e) {
            KindleLauncher.LOG.error("Cannot get current running app from lipc.");
            e.printStackTrace();
            return "com.lab126.booklet.home";
        }
    }

    public void initMenu() {
        this.mDialog = new MenuDialog(this.getCurrentAppId());
        this.mDialog.setTitle(this.getValue());
        PriorityQueue copy = new PriorityQueue();
        while (!this.mItems.isEmpty()) {
            LauncherAction item = (LauncherAction)this.mItems.remove();
            if (item.hasArrow()) {
                this.mDialog.addActionWithIndicator((Action)((Object)item));
            } else {
                this.mDialog.addAction((Action)((Object)item));
            }
            copy.add((Object)item);
        }
        if (this.mParent != null) {
            this.mParent.putValue("Name", "\u00ab Previous");
            this.mDialog.addAction((Action)((Object)this.mParent));
        }
        this.mItems = copy;
    }

    public void addMenuItem(LauncherAction item) {
        this.mItems.add((Object)item);
        this.mDialog = null;
    }

    public void removeMenuItem(LauncherAction item) {
        this.mItems.remove((Object)item);
        this.mDialog = null;
    }

    public LauncherAction[] getMenuItems() {
        return (LauncherAction[])this.mItems.toArray((Object[])new LauncherAction[0]);
    }

    public boolean isMenuEmpty() {
        return this.mItems.isEmpty();
    }

    public void clearMenu() {
        this.mItems.clear();
    }

    public MenuDialog getMenu() {
        if (this.mDialog == null) {
            this.initMenu();
        }
        return this.mDialog;
    }

    public void setParent(LauncherMenu parent) {
        this.mParent = parent;
    }

    public LauncherMenu getParent() {
        return this.mParent;
    }
}

