/*
 * Decompiled with CFR 0.152.
 */
package com.yifanlu.Kindle;

import com.amazon.ebook.util.log.LogMessage;
import com.yifanlu.Kindle.KindleLauncher;
import com.yifanlu.Kindle.LauncherAction;
import com.yifanlu.Kindle.LauncherMenu;
import com.yifanlu.Kindle.LauncherScript;
import com.yifanlu.Kindle.Menuable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JSONMenu
implements Menuable {
    private static final LogMessage JSON_MENU_ITEM = new LogMessage("JsonMenuItem", new String[]{"name", "action", "params"});
    private File mJsonFile;
    private LauncherAction[] mMenuItems;

    public JSONMenu(File jsonFile) {
        this.mJsonFile = jsonFile;
        this.mMenuItems = new LauncherAction[0];
    }

    public void addItemsToMenu(LauncherMenu menu) {
        if (this.isDynamic()) {
            KindleLauncher.LOG.debug("Reloading the menu.");
            this.mJsonFile = new File(this.mJsonFile.getAbsolutePath());
            try {
                this.parseJSONMenu();
            }
            catch (IOException e) {
                KindleLauncher.LOG.error("Cannot create menu because file " + this.mJsonFile.getAbsolutePath() + " cannot be read.");
                e.printStackTrace();
            }
            catch (ParseException e) {
                KindleLauncher.LOG.error("Cannot create menu because file " + this.mJsonFile.getAbsolutePath() + " cannot be parsed.");
                e.printStackTrace();
            }
        }
        int i = 0;
        while (i < this.mMenuItems.length) {
            if (this.mMenuItems[i] instanceof LauncherMenu) {
                ((LauncherMenu)this.mMenuItems[i]).setParent(menu);
            }
            menu.addMenuItem(this.mMenuItems[i]);
            ++i;
        }
    }

    public void setDynamic(boolean dynamic) {
    }

    public boolean isDynamic() {
        return true;
    }

    public void parseJSONMenu() throws IOException, ParseException {
        this.mMenuItems = new LauncherMenu[0];
        JSONParser parse = new JSONParser();
        FileReader read = new FileReader(this.mJsonFile);
        JSONObject obj = (JSONObject)parse.parse((Reader)read);
        LauncherAction action = this.jsonToAction(obj, null);
        this.mMenuItems = action instanceof LauncherMenu && action.getValue().equals("No Text") ? ((LauncherMenu)action).getMenuItems() : new LauncherAction[]{action};
    }

    protected LauncherAction jsonToAction(JSONObject json, LauncherMenu parent) throws IOException {
        LauncherAction launcherAction;
        String name = (String)json.get((Object)"name");
        Number priorityNum = (Number)json.get((Object)"priority");
        String action = (String)json.get((Object)"action");
        String params = (String)json.get((Object)"params");
        JSONArray items = (JSONArray)json.get((Object)"items");
        if (name == null) {
            name = "No Text";
        }
        int priority = priorityNum == null ? 0 : priorityNum.intValue();
        if (items != null) {
            launcherAction = new LauncherMenu(name, priority, parent);
            KindleLauncher.LOG.debug(JSON_MENU_ITEM, new String[]{name, "submenu", ""}, "");
            Iterator it = items.iterator();
            while (it.hasNext()) {
                JSONObject itemObj = (JSONObject)it.next();
                ((LauncherMenu)launcherAction).addMenuItem(this.jsonToAction(itemObj, (LauncherMenu)launcherAction));
            }
        } else if (action != null) {
            if (params == null) {
                params = "";
            }
            File script = action.startsWith("/") ? new File(action) : new File(this.mJsonFile.getParentFile(), action);
            launcherAction = new LauncherScript(name, priority, script, params);
            KindleLauncher.LOG.debug(JSON_MENU_ITEM, new String[]{name, action, params}, "");
        } else {
            throw new IOException("No valid action found for menu item: " + json.toJSONString());
        }
        return launcherAction;
    }
}

