package com.mobileread.mapeper.kindlettoe;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * This class implements a simple TicTacToe Game with Swing Components
 * @author matthias
 *
 */
public class KindLetToe implements MouseListener {
	public static final Boolean X=new Boolean(true);
	public static final Boolean O=new Boolean(!X.booleanValue());
	public static final Boolean FREE=null;
	public static final Boolean startingTurn=X;
	private TicTacToePanel[][] field;
	private JPanel fieldpanel;
	private JLabel statuslabel;//The label for the text, that will display which turn it is and who has won. 
	private Boolean nextTurn=startingTurn; //Who has the next Turn? 
	private boolean gameFinished=false;
	private byte counter=0;//This variable is used to count, how many marks have been set. The game will end, when this reaches 9
	/**
	 * This Method will add our Swing-Components to the specified Container
	 * @param c The container the Components will be added to.
	 */
	public void addComponents(Container c)
	{
		c.setLayout(new BorderLayout());
		//Creating of our components
		fieldpanel=new JPanel();
		statuslabel=new JLabel("Next Turn: " + (nextTurn==X?"X":"O"));
		fieldpanel.addMouseListener(this);
		fieldpanel.setLayout(new GridLayout(3,3));
		//Creating the Field
		field= new TicTacToePanel[3][3];
		for(int y=0;y<3;y++)
			for(int x=0;x<3;x++)
			{
				field[y][x]=new TicTacToePanel();
				fieldpanel.add(field[y][x]);
			}
		//And add everything to the Container
		c.add(fieldpanel,BorderLayout.CENTER);
		c.add(statuslabel,BorderLayout.SOUTH);
	}
	/**
	 * This resets the game, so that a new game can be started.
	 */
	public void resetGame()
	{
		for(int y=0;y<3;y++)
			for(int x=0;x<3;x++)
				//We clear all the TicTacToe Fields
				field[y][x].setFree();
		gameFinished=false;
		nextTurn=startingTurn;
		statuslabel.setText("New Game. Next Turn: " + (nextTurn==X?"X":"O"));
		counter=0;
	}
	/**
	 * When the Play-Field has been Clicked this is called.
	 * See in-line commentary for more information
	 */
	public void mouseClicked(MouseEvent e) {
		if(gameFinished)
		{ //We start a new game.
			resetGame();
			return;
		}
		TicTacToePanel clickedField;
		try
		{
			//We try to estimate, which of our TicTacToePanels has been clicked.
			//This should succeed MOST of the time.
			clickedField=(TicTacToePanel) fieldpanel.getComponentAt(e.getX(), e.getY());
		}
		catch(ClassCastException c)
		{
			System.err.println("Couldn't find the clicked Field!");
			return;
		}
		
		//What a dumb user. He clicked a field, that is not free, we do nothing.
		if(!clickedField.isFree())
			return;
		//We set the Field to the mark of the current player.
		if(nextTurn==X)
		{
			clickedField.setX();
			nextTurn=O;
		}
		else
		{
			clickedField.setO();
			nextTurn=X;
		}
		counter++;
		Boolean won = checkFinished();
		if(won==FREE)
		{
			if(counter==9)
			{
				gameFinished=true;
				statuslabel.setText("DRAW");
			}
			else
				statuslabel.setText("Next Turn: " + (nextTurn==X?"X":"O"));
		}
		else if(won==X)
		{
			statuslabel.setText("X has won! Click to start a new Game");
			gameFinished=true;
		}
		else if(won==O)
		{
			statuslabel.setText("O has won! Click to start a new Game");
			gameFinished=true;
		}
	}
	/**
	 * This will check the board for a winning Position.
	 * @return X, when X has won. O, when O has won, FREE, when nobody has one
	 * @see KindLetToe.X
	 * @see KindLetToe.O
	 * @see KindLetToe.FREE
	 */
	public Boolean checkFinished()
	{
		
		for(int i=0;i<3;i++)
		{
			//Check for a horizontal win
			if 	(field[i][0].state!=FREE &&field[i][0].state==field[i][1].state&&field[i][1].state==field[i][2].state)
				return field[i][0].state;
			//Check for a vertical win.
			if	(field[0][i].state!=FREE &&field[0][i].state==field[1][i].state&&field[1][i].state==field[2][i].state)
				return field[0][i].state;
		}
		//Check for a diagonally win.
		if 	(
				(field[0][0].state==field[1][1].state && field[1][1].state==field[2][2].state)
				||
				(field[2][0].state==field[1][1].state && field[1][1].state==field[0][2].state)
			)
			return field[1][1].state;
		return FREE;
	}
	public void mousePressed(MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {}
	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}
}
