package com.mobileread.mapeper.kindlettoe;
import java.awt.Graphics;
import javax.swing.JPanel;

/**
 * This class is used to show either nothing, an X or an O.
 * @author matthias
 *
 */
public class TicTacToePanel extends JPanel
{
	private static final long serialVersionUID = 425098223040388487L;
	
	/**
	 * The current state of this field.
	 */
	public Boolean state = KindLetToe.FREE;

	/**
	 * Sets the state to X and issues a repaint
	 * @see repaint()
	 */
	public void setX()
	{
		state=KindLetToe.X;
		this.repaint();
	}
	/**
	 * Sets the state to O and issues a repaint
	 * @see repaint()
	 */
	public void setO()
	{
		state=KindLetToe.O;
		this.repaint();
	}
	/**
	 * Clears the field and issues a repaint
	 * @see repaint()
	 */
	public void setFree()
	{
		state=KindLetToe.FREE;
		this.repaint();
	}
	
	public boolean isX()
	{
		return state==KindLetToe.X;
	}
	public boolean isO()
	{
		return state==KindLetToe.O;
	}
	public boolean isFree()
	{
		return state==KindLetToe.FREE;
	}
	/**
	 * Draws an X or an O dependent on the current state of the field.
	 */
	public void paint(Graphics g)
	{
		super.paint(g);
		
		g.drawRect(0, 0, this.getWidth(), this.getHeight());
		//This calculates the maximum possible size for the Symbols to be displayed with an 1:1 aspect ratio.
		int minSize = Math.min(this.getWidth(), this.getHeight());
		//and then centers the Symbol in the supplied space.
		int x=(this.getWidth()-minSize)/2;
		int y=(this.getHeight()-minSize)/2;
		
		if(isO())
		{
			g.drawOval(x+1, y+1, minSize-2, minSize-2);
		}
		else if(isX())
		{
			g.drawLine(x+1, y+1, x+minSize-2, y+minSize-2);
			g.drawLine(x+minSize-2, y+1, x+1, y+minSize-2);
		}
	}


}
