<?xml version="1.0" encoding="Windows-1252"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output encoding="UTF-8" indent="yes" method="xml"/>
	<xsl:param name="directory"/>
	<xsl:param name="hotsync-user"/>
	<xsl:param name="hotsync-card"/>
	<xsl:template match="jxl">
		<documentList xmlns="http://www.distantchord.com/sdl/" version="0.1">
			<xsl:apply-templates select="site|feed">
				<xsl:sort select="name"/>
			</xsl:apply-templates>
		</documentList>
	</xsl:template>
	<xsl:template match="feed|site">
		<document xmlns="http://www.distantchord.com/sdl/">
			<xsl:if test="@outputEncoding">
				<xsl:attribute name="encoding">
					<xsl:value-of select="@outputEncoding"/>
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="@language">
				<xsl:attribute name="language">
					<xsl:value-of select="@language"/>
				</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="name"/>
			<xsl:if test="category">
				<category xmlns="http://www.distantchord.com/sdl/">
					<xsl:value-of select="category[1]"/>
				</category>
			</xsl:if>
			<xsl:apply-templates select="uri"/>
			<xsl:apply-templates select="uriPatterns"/>
			<xsl:apply-templates select="images/embedded"/>
			<xsl:if test="@userAgent">
				<userAgent>
					<xsl:value-of select="@userAgent"/>
				</userAgent>
			</xsl:if>
			<xsl:apply-templates select="schedule"/>
			<destinations>
				<xsl:if test="$hotsync-user">
					<hotsync>
						<xsl:if test="$hotsync-card">
							<xsl:attribute name="type">card</xsl:attribute>
						</xsl:if>
						<xsl:value-of select="$hotsync-user"/>
					</hotsync>
				</xsl:if>
				<xsl:if test="$directory">
					<directory>
						<xsl:value-of select="$directory"/>
					</directory>
				</xsl:if>
			</destinations>
		</document>
	</xsl:template>
	<xsl:template match="images/embedded">
		<images xmlns="http://www.distantchord.com/sdl/" maxWidth="{@maxWidth}" maxHeight="{@maxHeight}" 
			bpp="{@bpp}"/>
	</xsl:template>
	<xsl:template match="name">
		<name xmlns="http://www.distantchord.com/sdl/">
			<xsl:value-of select="."/>
		</name>
	</xsl:template>
	<xsl:template match="schedule">
		<schedules xmlns="http://www.distantchord.com/sdl/">
			<xsl:choose>
				<xsl:when test="daily">
					<daily xmlns="http://www.distantchord.com/sdl/" time="{daily/@hour}:{daily/@minute}"/>
				</xsl:when>
				<xsl:when test="weekly">
					<weekly xmlns="http://www.distantchord.com/sdl/" day="{weekly/@day}" 
						time="{weekly/@hour}:{weekly/@minute}"/>
				</xsl:when>
			</xsl:choose>
		</schedules>
	</xsl:template>
	<xsl:template match="uri">
		<source xmlns="http://www.distantchord.com/sdl/">
			<xsl:if test="@maxDepth">
				<xsl:attribute name="maxLinkDepth">
					<xsl:value-of select="@maxDepth"/>
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="@restrict">
				<xsl:attribute name="restrict">
					<xsl:value-of select="@restrict"/>
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="@referrer">
				<xsl:attribute name="referrer">
					<xsl:value-of select="@referrer"/>
				</xsl:attribute>
			</xsl:if>
			<xsl:value-of select="."/>
		</source>
	</xsl:template>
	<xsl:template match="uriPatterns">
		<uriFilters xmlns="http://www.distantchord.com/sdl/">
			<xsl:for-each select="include">
				<include type="regexp" xmlns="http://www.distantchord.com/sdl/">
					<xsl:value-of select="."/>
				</include>
			</xsl:for-each>
			<xsl:for-each select="exclude">
				<exclude type="regexp" xmlns="http://www.distantchord.com/sdl/">
					<xsl:value-of select="."/>
				</exclude>
			</xsl:for-each>
		</uriFilters>
	</xsl:template>
</xsl:stylesheet>