<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sdl="http://www.distantchord.com/sdl/">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:template match="/sdl:documentList">
		<sxl>
			<xsl:for-each select="sdl:document">
				<xsl:sort select="sdl:name"/>
				<document>
					<xsl:apply-templates select="."/>
				</document>
			</xsl:for-each>
		</sxl>
	</xsl:template>
	<xsl:template match="sdl:document">
		<xsl:apply-templates select="sdl:name"/>
		<xsl:apply-templates select="sdl:category"/>
		<xsl:apply-templates select="sdl:source"/>
		<xsl:apply-templates select="sdl:images"/>
		<xsl:apply-templates select="sdl:linkFilters"/>
		<xsl:apply-templates select="sdl:schedules"/>
		<xsl:apply-templates select="sdl:destinations"/>
	</xsl:template>
	<xsl:template match="sdl:name">
		<name>
			<xsl:value-of select="."/>
		</name>
	</xsl:template>
	<xsl:template match="sdl:category">
		<category>
			<xsl:value-of select="."/>
		</category>
	</xsl:template>
	<xsl:template match="sdl:source">
		<content linkDepth="{@maxLinkDepth}" conditionalUpdate="{@conditionalUpdate}" language="{../@language}">
			<xsl:if test="@restrict">
				<xsl:attribute name="restrict">
					<xsl:value-of select="@restrict"/>
				</xsl:attribute>
			</xsl:if>
			<update enabled="true" interval="3" unit="hours"/>
			<source checksum="{@checksum}">
				<xsl:value-of select="."/>
			</source>
		</content>
	</xsl:template>
	<xsl:template match="sdl:images">
		<images included="{@enabled}" bpp="{@bpp}" maxWidth="{@maxWidth}" maxHeight="{@maxHeight}"/>
	</xsl:template>
	<xsl:template match="sdl:linkFilters">
		<filters>
			<xsl:for-each select="sdl:include">
				<linkFilter type="inclusion" match="{@type}">
					<xsl:if test="@link">
						<xsl:attribute name="link"><xsl:value-of select="@link"/></xsl:attribute>
					</xsl:if>
					<xsl:value-of select="."/>
				</linkFilter>
			</xsl:for-each>
			<xsl:for-each select="sdl:exclude">
				<linkFilter type="exclusion" match="{@type}">
					<xsl:if test="@link">
						<xsl:attribute name="link"><xsl:value-of select="@link"/></xsl:attribute>
					</xsl:if>
					<xsl:value-of select="."/>
				</linkFilter>
			</xsl:for-each>
		</filters>
	</xsl:template>
	<xsl:template match="sdl:destinations">
		<output lastGenerated="{../@lastConverted}" size="{../@size}">
			<xsl:if test="../@outputEncoding">
				<xsl:attribute name="encoding">
					<xsl:value-of select="../@outputEncoding"/>
				</xsl:attribute>
			</xsl:if>
			<xsl:for-each select="sdl:hotsync">
				<hotsync storage="{@type}">
					<xsl:if test="@slot">
						<xsl:attribute name="slot">
							<xsl:value-of select="@slot"/>
						</xsl:attribute>
					</xsl:if>
					<xsl:value-of select="."/>
				</hotsync>
			</xsl:for-each>
			<xsl:for-each select="sdl:directory">
				<directory>
					<xsl:value-of select="."/>
				</directory>
			</xsl:for-each>
		</output>
	</xsl:template>
	<xsl:template match="sdl:schedules">
		<schedule start="{../@created}" lastUpdated="{../@lastUpdated}">
			<xsl:apply-templates select="sdl:hourly"/>
			<xsl:apply-templates select="sdl:daily"/>
			<xsl:apply-templates select="sdl:weekly"/>
			<xsl:apply-templates select="sdl:monthly"/>
		</schedule>
	</xsl:template>
	<xsl:template match="sdl:hourly">
		<hourly minutes="{@minute}" start="{substring(../../@created, 1, 10)}" interval="1" enabled="true"/>
	</xsl:template>
	<xsl:template match="sdl:daily">
		<daily time="{@time}" start="{substring(../../@created, 1, 10)}" interval="1" enabled="true"/>
	</xsl:template>
	<xsl:template match="sdl:weekly">
		<weekly time="{@time}" start="{substring(../../@created, 1, 10)}" interval="1" enabled="true">
			<xsl:element name="{@day}"/>
		</weekly>
	</xsl:template>	
	<xsl:template match="sdl:monthly">
		<monthly time="{@time}" day="{@day}"/>
	</xsl:template>
</xsl:stylesheet>
