#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__docformat__ = 'restructuredtext en'

# The class that all Interface Action plugin wrappers must inherit from
from calibre.customize import Plugin
import imp

def wrapper(mod_path,func,*args, **kwargs):
    '''

    :param mod_path: path to python source code containing module that needs to be imported

    :param func_name: Function to call in the worker process from the imported
    module

    :param args: Positional arguments to pass to the function

    :param kwargs: Keyword arguments to pass to the function
    '''
    mod = imp.load_source('calibre_plugins.recipe_fork_helper.temp', mod_path)
    func = getattr(mod, func)
    return func(*args,**kwargs)    
        

class RecipeForkHelper(Plugin):
    name                = 'Recipe fork helper'
    description         = 'loads module from source'
    supported_platforms = ['windows', 'osx', 'linux']
    author              = 'Will'
    version             = (1, 0, 0)
    minimum_calibre_version = (0, 7, 53)


