/* A touch-screen Dvorak keyboard
 */

/* Copyright (C) 2012 JoppyFurr
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy 
 * of this software and associated documentation files (the "Software"), to 
 * deal in the Software without restriction, including without limitation the 
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or 
 * sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 * DEALINGS IN THE SOFTWARE.
 */

#define KEYBOARD_ROWS 5
#define KEYBOARD_COLUMNS 14
#define KEY_WIDTH 42

/* Modifier state */
#define NONE 0
#define SHIFT 1


/* Using high character values that will not interfear with plaintext (for now) */
#define ESCAPE_KEY 255
#define BACKSPACE_KEY 254
#define DELETE_KEY 253
#define TAB_KEY 252
#define SHIFT_KEY 251
#define CTRL_KEY 250
#define ALT_KEY 249
#define UP_ARROW 248
#define DOWN_ARROW 247
#define LEFT_ARROW 246
#define RIGHT_ARROW 245

/* Prototypes */
void draw_keyboard(unsigned char *frame_buffer, int modifier);
unsigned char read_keyboard(int x, int y, int modifier);

// Added by Reza June 12, 2012
static unsigned char keyboard_lower[] = {
    '`',        '1',      '2',      '3',     '4',     '5',  '6',  '7',  '8',  '9',  '0',  '-',        '=',        BACKSPACE_KEY,
    TAB_KEY,    'q',     'w',      'e',     'r',     't',  'y',  'u',  'i',  'o',  'p',  '[',        ']',        '\\',
    SHIFT_KEY,  'a',      's',      'd',     'f',     'g',  'h',  'j',  'k',  'l',  ';',  '\'',        '\n',       '\n',
    SHIFT_KEY,  'z',      'x',      'c',     'v',     'b',  'n',  'm',  ',',  '.',  '/',  SHIFT_KEY,  UP_ARROW,   DELETE_KEY,
    ESCAPE_KEY, CTRL_KEY, ALT_KEY,  ' ',  ' ',  ' ',  ' ',  ' ',  ' ', ALT_KEY, CTRL_KEY, LEFT_ARROW, DOWN_ARROW, RIGHT_ARROW
};
static unsigned char keyboard_higher[] = {
    '~',        '!',      '@',      '#',     '$',      '%',  '^',  '&',  '*',  '(',  ')',  '_',        '+',        BACKSPACE_KEY,
    TAB_KEY,    'Q',     'W',      'E',     'R',      'T',  'Y',  'U',  'I',  'O',  'P',  '{',        '}',        '|',
    SHIFT_KEY,  'A',      'S',      'D',     'F',      'G',  'H',  'J',  'K',  'L',  ':',  '\"',        '\n',       '\n',
    SHIFT_KEY,  'Z',      'X',      'C',     'V',      'B',  'N',  'M',  '<',  '>',  '?',  SHIFT_KEY,  UP_ARROW,   DELETE_KEY,
    ESCAPE_KEY, CTRL_KEY, ALT_KEY,  ' ',  ' ',  ' ',  ' ',  ' ',  ' ', ALT_KEY, CTRL_KEY, LEFT_ARROW, DOWN_ARROW, RIGHT_ARROW
};
/////////////////////////////

/*
static unsigned char keyboard_lower[] = {
    '`',        '1',      '2',      '3',     '4',     '5',  '6',  '7',  '8',  '9',  '0',  '[',        ']',        BACKSPACE_KEY,
    TAB_KEY,    '\'',     ',',      '.',     'p',     'y',  'f',  'g',  'c',  'r',  'l',  '/',        '=',        '\\',
    SHIFT_KEY,  'a',      'o',      'e',     'u',     'i',  'd',  'h',  't',  'n',  's',  '-',        '\n',       '\n',
    SHIFT_KEY,  ';',      'q',      'j',     'k',     'x',  'b',  'm',  'w',  'v',  'z',  SHIFT_KEY,  UP_ARROW,   DELETE_KEY,
    ESCAPE_KEY, CTRL_KEY, CTRL_KEY, ALT_KEY, ALT_KEY, ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  LEFT_ARROW, DOWN_ARROW, RIGHT_ARROW
};
static unsigned char keyboard_higher[] = {
    '~',        '!',      '@',      '#',     '$',      '%',  '^',  '&',  '*',  '(',  ')',  '{',        '}',        BACKSPACE_KEY,
    TAB_KEY,    '\"',     '<',      '>',     'P',      'Y',  'F',  'G',  'C',  'R',  'L',  '?',        '+',        '|',
    SHIFT_KEY,  'A',      'O',      'E',     'U',      'I',  'D',  'H',  'T',  'N',  'S',  '_',        '\n',       '\n',
    SHIFT_KEY,  ':',      'Q',      'J',     'K',      'X',  'B',  'M',  'W',  'V',  'Z',  SHIFT_KEY,  UP_ARROW,   DELETE_KEY,
    ESCAPE_KEY, CTRL_KEY, CTRL_KEY, ALT_KEY, ALT_KEY,  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  LEFT_ARROW, DOWN_ARROW, RIGHT_ARROW
};
*/